/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.refresh.core;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.v4.view.NestedScrollingChild;
import android.support.v4.view.NestedScrollingChildHelper;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.NestedScrollingParentHelper;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewParentCompat;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.AbsListView;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import com.taobao.weex.ui.view.refresh.core.WXRefreshView;
import java.util.LinkedList;
import java.util.List;

public class WXSwipeLayout
extends FrameLayout
implements NestedScrollingParent,
NestedScrollingChild {
    private NestedScrollingParentHelper mNestedScrollingParentHelper;
    private NestedScrollingChildHelper mNestedScrollingChildHelper;
    private final int[] mParentScrollConsumed = new int[2];
    private final int[] mParentOffsetInWindow = new int[2];
    private boolean mNestedScrollInProgress;
    private WXOnRefreshListener onRefreshListener;
    private WXOnLoadingListener onLoadingListener;
    private ViewParent mNestedScrollAcceptedParent;
    private final List<OnRefreshOffsetChangedListener> mRefreshOffsetChangedListeners = new LinkedList<OnRefreshOffsetChangedListener>();
    private WXRefreshView headerView;
    private WXRefreshView footerView;
    private View mTargetView;
    private static final int INVALID = -1;
    private static final int PULL_REFRESH = 0;
    private static final int LOAD_MORE = 1;
    private boolean mPullRefreshEnable = false;
    private boolean mPullLoadEnable = false;
    private volatile boolean mRefreshing = false;
    private volatile float refreshViewHeight = 0.0f;
    private volatile float loadingViewHeight = 0.0f;
    private volatile float refreshViewFlowHeight = 0.0f;
    private volatile float loadingViewFlowHeight = 0.0f;
    private static final float overFlow = 1.0f;
    private static final float DAMPING = 0.4f;
    private int mCurrentAction = -1;
    private boolean isConfirm = false;
    private int mRefreshViewBgColor;
    private int mProgressBgColor;
    private int mProgressColor;

    public WXSwipeLayout(Context context) {
        super(context);
        this.initAttrs(context, null);
    }

    public WXSwipeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(context, attrs);
    }

    public WXSwipeLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(context, attrs);
    }

    @TargetApi(value=21)
    public WXSwipeLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initAttrs(context, attrs);
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        if (this.getChildCount() > 1) {
            throw new RuntimeException("WXSwipeLayout should not have more than one child");
        }
        this.mNestedScrollingParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
        this.mNestedScrollingChildHelper = new NestedScrollingChildHelper((View)this);
        this.setNestedScrollingEnabled(false);
        if (this.isInEditMode() && attrs == null) {
            return;
        }
        this.mRefreshViewBgColor = 0;
        this.mProgressBgColor = 0;
        this.mProgressColor = -65536;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mTargetView == null && this.getChildCount() > 0) {
            this.mTargetView = this.getChildAt(0);
        }
        if (this.mTargetView != null && (this.headerView == null || this.footerView == null)) {
            this.setRefreshView();
        }
    }

    public void addTargetView(View mInnerView) {
        this.addView(mInnerView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.setRefreshView();
    }

    private void setRefreshView() {
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, 0);
        this.headerView = new WXRefreshView(this.getContext());
        this.headerView.setStartEndTrim(0.0f, 0.75f);
        this.headerView.setBackgroundColor(this.mRefreshViewBgColor);
        this.headerView.setProgressBgColor(this.mProgressBgColor);
        this.headerView.setProgressColor(this.mProgressColor);
        this.headerView.setContentGravity(80);
        this.addView((View)this.headerView, (ViewGroup.LayoutParams)lp);
        lp = new FrameLayout.LayoutParams(-1, 0);
        lp.gravity = 80;
        this.footerView = new WXRefreshView(this.getContext());
        this.footerView.setStartEndTrim(0.5f, 1.25f);
        this.footerView.setBackgroundColor(this.mRefreshViewBgColor);
        this.footerView.setProgressBgColor(this.mProgressBgColor);
        this.footerView.setProgressColor(this.mProgressColor);
        this.footerView.setContentGravity(48);
        this.addView((View)this.footerView, (ViewGroup.LayoutParams)lp);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (!this.mPullRefreshEnable && !this.mPullLoadEnable) {
            return false;
        }
        if (!this.isEnabled() || this.canChildScrollUp() || this.mRefreshing || this.mNestedScrollInProgress) {
            return false;
        }
        return super.onInterceptTouchEvent(ev);
    }

    public void setNestedScrollingEnabled(boolean enabled) {
        this.mNestedScrollingChildHelper.setNestedScrollingEnabled(enabled);
    }

    public boolean isNestedScrollingEnabled() {
        return this.mNestedScrollingChildHelper.isNestedScrollingEnabled();
    }

    public boolean startNestedScroll(int axes) {
        boolean result = this.mNestedScrollingChildHelper.startNestedScroll(axes);
        if (result && this.mNestedScrollAcceptedParent == null) {
            WXSwipeLayout child = this;
            for (ViewParent parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (ViewParentCompat.onStartNestedScroll((ViewParent)parent, (View)child, (View)this, (int)axes)) {
                    this.mNestedScrollAcceptedParent = parent;
                    break;
                }
                if (!(parent instanceof View)) continue;
                child = (View)parent;
            }
        }
        return result;
    }

    public void stopNestedScroll() {
        this.mNestedScrollingChildHelper.stopNestedScroll();
        if (this.mNestedScrollAcceptedParent != null) {
            this.mNestedScrollAcceptedParent = null;
        }
    }

    public boolean hasNestedScrollingParent() {
        return this.mNestedScrollingChildHelper.hasNestedScrollingParent();
    }

    public boolean dispatchNestedScroll(int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int[] offsetInWindow) {
        return this.mNestedScrollingChildHelper.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, offsetInWindow);
    }

    public boolean dispatchNestedPreScroll(int dx, int dy, int[] consumed, int[] offsetInWindow) {
        return this.mNestedScrollingChildHelper.dispatchNestedPreScroll(dx, dy, consumed, offsetInWindow);
    }

    public boolean dispatchNestedFling(float velocityX, float velocityY, boolean consumed) {
        return this.mNestedScrollingChildHelper.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public boolean dispatchNestedPreFling(float velocityX, float velocityY) {
        return this.mNestedScrollingChildHelper.dispatchNestedPreFling(velocityX, velocityY);
    }

    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        if (this.isNestedScrollingEnabled()) {
            return this.dispatchNestedPreFling(velocityX, velocityY);
        }
        return false;
    }

    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        if (this.isNestedScrollingEnabled()) {
            return this.dispatchNestedFling(velocityX, velocityY, consumed);
        }
        return false;
    }

    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        boolean result = this.isEnabled() && !this.mRefreshing && (nestedScrollAxes & 2) != 0;
        return result;
    }

    public void onNestedScrollAccepted(View child, View target, int axes) {
        this.mNestedScrollingParentHelper.onNestedScrollAccepted(child, target, axes);
        if (this.isNestedScrollingEnabled()) {
            this.startNestedScroll(axes & 2);
            this.mNestedScrollInProgress = true;
        }
    }

    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        ViewGroup group;
        int[] parentConsumed = this.mParentScrollConsumed;
        if (this.isNestedScrollingEnabled() && this.dispatchNestedPreScroll(dx - consumed[0], dy - consumed[1], parentConsumed, null)) {
            consumed[0] = consumed[0] + parentConsumed[0];
            consumed[1] = consumed[1] + parentConsumed[1];
            return;
        }
        if (!this.mPullRefreshEnable && !this.mPullLoadEnable) {
            return;
        }
        if (!this.canChildScrollUp() && this.isNestedScrollingEnabled() && this.mNestedScrollAcceptedParent != null && this.mNestedScrollAcceptedParent != this.mTargetView && (group = (ViewGroup)this.mNestedScrollAcceptedParent).getChildCount() > 0) {
            int count = group.getChildCount();
            for (int i = 0; i < count; ++i) {
                View view = group.getChildAt(i);
                if (view.getVisibility() == 8 || view.getMeasuredHeight() <= 0) continue;
                if (view.getTop() >= 0) break;
                return;
            }
        }
        int spinnerDy = (int)this.calculateDistanceY(target, dy);
        this.mRefreshing = false;
        if (!this.isConfirm) {
            if (spinnerDy < 0 && !this.canChildScrollUp()) {
                this.mCurrentAction = 0;
                this.isConfirm = true;
            } else if (spinnerDy > 0 && !this.canChildScrollDown() && !this.mRefreshing) {
                this.mCurrentAction = 1;
                this.isConfirm = true;
            }
        }
        if (this.moveSpinner(-spinnerDy)) {
            consumed[1] = !this.canChildScrollUp() && this.mPullRefreshEnable && this.mTargetView.getTranslationY() > 0.0f && dy > 0 ? consumed[1] + dy : (!this.canChildScrollDown() && this.mPullLoadEnable && this.mTargetView.getTranslationY() < 0.0f && dy < 0 ? consumed[1] + dy : consumed[1] + spinnerDy);
        }
    }

    public int getNestedScrollAxes() {
        return this.mNestedScrollingParentHelper.getNestedScrollAxes();
    }

    public void onStopNestedScroll(View child) {
        this.mNestedScrollingParentHelper.onStopNestedScroll(child);
        this.handlerAction();
        if (this.isNestedScrollingEnabled()) {
            this.mNestedScrollInProgress = true;
            this.stopNestedScroll();
        }
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        if (this.isNestedScrollingEnabled()) {
            this.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, this.mParentOffsetInWindow);
        }
    }

    private double calculateDistanceY(View target, int dy) {
        int viewHeight = target.getMeasuredHeight();
        double ratio = (double)((float)viewHeight - Math.abs(target.getY())) / 1.0 / (double)viewHeight * (double)0.4f;
        if (ratio <= 0.01) {
            ratio = 0.01;
        }
        return ratio * (double)dy;
    }

    private boolean moveSpinner(float distanceY) {
        if (this.mRefreshing) {
            return false;
        }
        if (!this.canChildScrollUp() && this.mPullRefreshEnable && this.mCurrentAction == 0) {
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.headerView.getLayoutParams();
            lp.height = (int)((float)lp.height + distanceY);
            if (lp.height < 0) {
                lp.height = 0;
            }
            if (lp.height == 0) {
                this.isConfirm = false;
                this.mCurrentAction = -1;
            }
            this.headerView.setLayoutParams((ViewGroup.LayoutParams)lp);
            this.onRefreshListener.onPullingDown(distanceY, lp.height, this.refreshViewFlowHeight);
            this.notifyOnRefreshOffsetChangedListener(lp.height);
            this.headerView.setProgressRotation((float)lp.height / this.refreshViewFlowHeight);
            this.moveTargetView(lp.height);
            return true;
        }
        if (!this.canChildScrollDown() && this.mPullLoadEnable && this.mCurrentAction == 1) {
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.footerView.getLayoutParams();
            lp.height = (int)((float)lp.height - distanceY);
            if (lp.height < 0) {
                lp.height = 0;
            }
            if (lp.height == 0) {
                this.isConfirm = false;
                this.mCurrentAction = -1;
            }
            this.footerView.setLayoutParams((ViewGroup.LayoutParams)lp);
            this.onLoadingListener.onPullingUp(distanceY, lp.height, this.loadingViewFlowHeight);
            this.footerView.setProgressRotation((float)lp.height / this.loadingViewFlowHeight);
            this.moveTargetView(-lp.height);
            return true;
        }
        return false;
    }

    private void moveTargetView(float h) {
        this.mTargetView.setTranslationY(h);
    }

    private void handlerAction() {
        FrameLayout.LayoutParams lp;
        if (this.isRefreshing()) {
            return;
        }
        this.isConfirm = false;
        if (this.mPullRefreshEnable && this.mCurrentAction == 0) {
            lp = (FrameLayout.LayoutParams)this.headerView.getLayoutParams();
            if ((float)lp.height >= this.refreshViewHeight) {
                this.startRefresh(lp.height);
            } else if (lp.height > 0) {
                this.resetHeaderView(lp.height);
            } else {
                this.resetRefreshState();
            }
        }
        if (this.mPullLoadEnable && this.mCurrentAction == 1) {
            lp = (FrameLayout.LayoutParams)this.footerView.getLayoutParams();
            if ((float)lp.height >= this.loadingViewHeight) {
                this.startLoadmore(lp.height);
            } else if (lp.height > 0) {
                this.resetFootView(lp.height);
            } else {
                this.resetLoadmoreState();
            }
        }
    }

    private void startRefresh(int headerViewHeight) {
        this.mRefreshing = true;
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{headerViewHeight, this.refreshViewHeight});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)WXSwipeLayout.this.headerView.getLayoutParams();
                lp.height = (int)((Float)animation.getAnimatedValue()).floatValue();
                WXSwipeLayout.this.notifyOnRefreshOffsetChangedListener(lp.height);
                WXSwipeLayout.this.headerView.setLayoutParams((ViewGroup.LayoutParams)lp);
                WXSwipeLayout.this.moveTargetView(lp.height);
            }
        });
        animator.addListener((Animator.AnimatorListener)new WXRefreshAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                WXSwipeLayout.this.headerView.startAnimation();
                if (WXSwipeLayout.this.onRefreshListener != null) {
                    WXSwipeLayout.this.onRefreshListener.onRefresh();
                }
            }
        });
        animator.setDuration(300L);
        animator.start();
    }

    private void resetHeaderView(int headerViewHeight) {
        this.headerView.stopAnimation();
        this.headerView.setStartEndTrim(0.0f, 0.75f);
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{headerViewHeight, 0.0f});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)WXSwipeLayout.this.headerView.getLayoutParams();
                lp.height = (int)((Float)animation.getAnimatedValue()).floatValue();
                WXSwipeLayout.this.notifyOnRefreshOffsetChangedListener(lp.height);
                WXSwipeLayout.this.headerView.setLayoutParams((ViewGroup.LayoutParams)lp);
                WXSwipeLayout.this.moveTargetView(lp.height);
            }
        });
        animator.addListener((Animator.AnimatorListener)new WXRefreshAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                WXSwipeLayout.this.resetRefreshState();
            }
        });
        animator.setDuration(300L);
        animator.start();
    }

    private void resetRefreshState() {
        this.mRefreshing = false;
        this.isConfirm = false;
        this.mCurrentAction = -1;
    }

    private void startLoadmore(int headerViewHeight) {
        this.mRefreshing = true;
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{headerViewHeight, this.loadingViewHeight});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)WXSwipeLayout.this.footerView.getLayoutParams();
                lp.height = (int)((Float)animation.getAnimatedValue()).floatValue();
                WXSwipeLayout.this.footerView.setLayoutParams((ViewGroup.LayoutParams)lp);
                WXSwipeLayout.this.moveTargetView(-lp.height);
            }
        });
        animator.addListener((Animator.AnimatorListener)new WXRefreshAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                WXSwipeLayout.this.footerView.startAnimation();
                if (WXSwipeLayout.this.onLoadingListener != null) {
                    WXSwipeLayout.this.onLoadingListener.onLoading();
                }
            }
        });
        animator.setDuration(300L);
        animator.start();
    }

    private void resetFootView(int headerViewHeight) {
        this.footerView.stopAnimation();
        this.footerView.setStartEndTrim(0.5f, 1.25f);
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{headerViewHeight, 0.0f});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)WXSwipeLayout.this.footerView.getLayoutParams();
                lp.height = (int)((Float)animation.getAnimatedValue()).floatValue();
                WXSwipeLayout.this.footerView.setLayoutParams((ViewGroup.LayoutParams)lp);
                WXSwipeLayout.this.moveTargetView(-lp.height);
            }
        });
        animator.addListener((Animator.AnimatorListener)new WXRefreshAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                WXSwipeLayout.this.resetLoadmoreState();
            }
        });
        animator.setDuration(300L);
        animator.start();
    }

    private void resetLoadmoreState() {
        this.mRefreshing = false;
        this.isConfirm = false;
        this.mCurrentAction = -1;
    }

    @SuppressLint(value={"ObsoleteSdkInt"})
    public boolean canChildScrollUp() {
        if (this.mTargetView == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 14) {
            if (this.mTargetView instanceof AbsListView) {
                AbsListView absListView = (AbsListView)this.mTargetView;
                return absListView.getChildCount() > 0 && (absListView.getFirstVisiblePosition() > 0 || absListView.getChildAt(0).getTop() < absListView.getPaddingTop());
            }
            return ViewCompat.canScrollVertically((View)this.mTargetView, (int)-1) || this.mTargetView.getScrollY() > 0;
        }
        return ViewCompat.canScrollVertically((View)this.mTargetView, (int)-1);
    }

    @SuppressLint(value={"ObsoleteSdkInt"})
    public boolean canChildScrollDown() {
        if (this.mTargetView == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 14) {
            if (this.mTargetView instanceof AbsListView) {
                AbsListView absListView = (AbsListView)this.mTargetView;
                if (absListView.getChildCount() > 0) {
                    int lastChildBottom = absListView.getChildAt(absListView.getChildCount() - 1).getBottom();
                    return absListView.getLastVisiblePosition() == ((ListAdapter)absListView.getAdapter()).getCount() - 1 && lastChildBottom <= absListView.getMeasuredHeight();
                }
                return false;
            }
            return ViewCompat.canScrollVertically((View)this.mTargetView, (int)1) || this.mTargetView.getScrollY() > 0;
        }
        return ViewCompat.canScrollVertically((View)this.mTargetView, (int)1);
    }

    public float dipToPx(Context context, float value) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        return TypedValue.applyDimension((int)1, (float)value, (DisplayMetrics)metrics);
    }

    public void setOnLoadingListener(WXOnLoadingListener onLoadingListener) {
        this.onLoadingListener = onLoadingListener;
    }

    public void setOnRefreshListener(WXOnRefreshListener onRefreshListener) {
        this.onRefreshListener = onRefreshListener;
    }

    public void addOnRefreshOffsetChangedListener(@Nullable OnRefreshOffsetChangedListener listener) {
        if (listener != null && !this.mRefreshOffsetChangedListeners.contains(listener)) {
            this.mRefreshOffsetChangedListeners.add(listener);
        }
    }

    public boolean removeOnRefreshOffsetChangedListener(@Nullable OnRefreshOffsetChangedListener listener) {
        if (listener != null) {
            return this.mRefreshOffsetChangedListeners.remove(listener);
        }
        return false;
    }

    private void notifyOnRefreshOffsetChangedListener(int verticalOffset) {
        int size = this.mRefreshOffsetChangedListeners.size();
        for (int i = 0; i < size && i < this.mRefreshOffsetChangedListeners.size(); ++i) {
            OnRefreshOffsetChangedListener listener = this.mRefreshOffsetChangedListeners.get(i);
            if (listener == null) continue;
            listener.onOffsetChanged(verticalOffset);
        }
    }

    public void finishPullRefresh() {
        if (this.mCurrentAction == 0) {
            this.resetHeaderView(this.headerView == null ? 0 : this.headerView.getMeasuredHeight());
        }
    }

    public void finishPullLoad() {
        if (this.mCurrentAction == 1) {
            this.resetFootView(this.footerView == null ? 0 : this.footerView.getMeasuredHeight());
        }
    }

    public WXRefreshView getHeaderView() {
        return this.headerView;
    }

    public WXRefreshView getFooterView() {
        return this.footerView;
    }

    public boolean isPullLoadEnable() {
        return this.mPullLoadEnable;
    }

    public void setPullLoadEnable(boolean mPullLoadEnable) {
        this.mPullLoadEnable = mPullLoadEnable;
    }

    public boolean isPullRefreshEnable() {
        return this.mPullRefreshEnable;
    }

    public void setPullRefreshEnable(boolean mPullRefreshEnable) {
        this.mPullRefreshEnable = mPullRefreshEnable;
    }

    public boolean isRefreshing() {
        return this.mRefreshing;
    }

    public void setRefreshHeight(int height) {
        this.refreshViewHeight = height;
        this.refreshViewFlowHeight = this.refreshViewHeight * 1.0f;
    }

    public void setLoadingHeight(int height) {
        this.loadingViewHeight = height;
        this.loadingViewFlowHeight = this.loadingViewHeight * 1.0f;
    }

    public void setRefreshBgColor(int color) {
        this.headerView.setBackgroundColor(color);
    }

    public void setLoadingBgColor(int color) {
        this.footerView.setBackgroundColor(color);
    }

    static class WXRefreshAnimatorListener
    implements Animator.AnimatorListener {
        WXRefreshAnimatorListener() {
        }

        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationRepeat(Animator animation) {
        }
    }

    public static interface WXOnLoadingListener {
        public void onLoading();

        public void onPullingUp(float var1, int var2, float var3);
    }

    public static interface WXOnRefreshListener {
        public void onRefresh();

        public void onPullingDown(float var1, int var2, float var3);
    }

    public static interface OnRefreshOffsetChangedListener {
        public void onOffsetChanged(int var1);
    }
}

