/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.module;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.VisibleForTesting;
import android.util.SparseArray;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.bridge.WXHashMap;
import com.taobao.weex.bridge.WXJSObject;
import com.taobao.weex.common.Destroyable;
import com.taobao.weex.common.WXModule;
import com.taobao.weex.utils.WXJsonUtils;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class WXTimerModule
extends WXModule
implements Destroyable,
Handler.Callback {
    private static final String TAG = "timer";
    private Handler handler = new Handler(WXBridgeManager.getInstance().getJSLooper(), (Handler.Callback)this);
    private SparseArray<Integer> antiIntAutoBoxing = new SparseArray();

    @SuppressLint(value={"UseSparseArrays"})
    public WXTimerModule() {
    }

    @JSMethod(uiThread=false)
    public void setTimeout(@IntRange(from=1L) int funcId, @FloatRange(from=0.0) float delay) {
        if (this.mWXSDKInstance != null) {
            this.postOrHoldMessage(11, funcId, (int)delay, WXUtils.parseInt(this.mWXSDKInstance.getInstanceId()));
            if (null != this.mWXSDKInstance.getWXPerformance()) {
                ++this.mWXSDKInstance.getWXPerformance().timerInvokeCount;
            }
            this.mWXSDKInstance.getApmForInstance().updateFSDiffStats("wxFSTimerCount", 1.0);
        }
    }

    @JSMethod(uiThread=false)
    public void setInterval(@IntRange(from=1L) int funcId, @FloatRange(from=0.0) float interval) {
        if (this.mWXSDKInstance != null) {
            this.postOrHoldMessage(12, funcId, (int)interval, WXUtils.parseInt(this.mWXSDKInstance.getInstanceId()));
            if (null != this.mWXSDKInstance.getWXPerformance()) {
                ++this.mWXSDKInstance.getWXPerformance().timerInvokeCount;
            }
            this.mWXSDKInstance.getApmForInstance().updateFSDiffStats("wxFSTimerCount", 1.0);
        }
    }

    @JSMethod(uiThread=false)
    public void clearTimeout(@IntRange(from=1L) int funcId) {
        if (funcId <= 0) {
            return;
        }
        this.removeOrHoldMessage(11, funcId);
    }

    @JSMethod(uiThread=false)
    public void clearInterval(@IntRange(from=1L) int funcId) {
        if (funcId <= 0) {
            return;
        }
        this.removeOrHoldMessage(12, funcId);
    }

    @Override
    public void destroy() {
        if (this.handler != null) {
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d(TAG, "Timer Module removeAllMessages: ");
            }
            this.handler.removeCallbacksAndMessages(null);
            this.antiIntAutoBoxing.clear();
        }
    }

    public boolean handleMessage(Message msg) {
        boolean ret = false;
        if (msg != null) {
            int what = msg.what;
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d(TAG, "Timer Module handleMessage : " + msg.what);
            }
            switch (what) {
                case 11: {
                    if (msg.obj == null) break;
                    this.checkIfTimerInBack(msg.arg1);
                    WXJSObject[] args = this.createTimerArgs(msg.arg1, (Integer)msg.obj, false);
                    WXBridgeManager.getInstance().invokeExecJS(String.valueOf(msg.arg1), null, "callJS", args, true);
                    ret = true;
                    break;
                }
                case 12: {
                    if (msg.obj == null) break;
                    this.checkIfTimerInBack(msg.arg1);
                    this.postMessage(12, (Integer)msg.obj, msg.arg2, msg.arg1);
                    WXJSObject[] args = this.createTimerArgs(msg.arg1, (Integer)msg.obj, true);
                    WXBridgeManager.getInstance().invokeExecJS(String.valueOf(msg.arg1), null, "callJS", args, true);
                    ret = true;
                    break;
                }
            }
        }
        return ret;
    }

    private void checkIfTimerInBack(int instanceId) {
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(String.valueOf(instanceId));
        if (null == instance) {
            return;
        }
        if (instance.isViewDisAppear()) {
            instance.getApmForInstance().updateDiffStats("wxTimerInBackCount", 1.0);
        }
    }

    @VisibleForTesting
    void setHandler(Handler handler) {
        this.handler = handler;
    }

    private WXJSObject[] createTimerArgs(int instanceId, int funcId, boolean keepAlive) {
        ArrayList<Serializable> argsList = new ArrayList<Serializable>();
        argsList.add(Integer.valueOf(funcId));
        argsList.add(new HashMap());
        argsList.add(Boolean.valueOf(keepAlive));
        WXHashMap<String, Object> task = new WXHashMap<String, Object>();
        task.put("method", "callback");
        task.put("args", argsList);
        Object[] tasks = new Object[]{task};
        return new WXJSObject[]{new WXJSObject(2, String.valueOf(instanceId)), new WXJSObject(3, WXJsonUtils.fromObjectToJSONString(tasks))};
    }

    private void postOrHoldMessage(int what, int funcId, int interval, int instanceId) {
        if (this.mWXSDKInstance.isPreRenderMode()) {
            this.postMessage(what, funcId, interval, instanceId);
        } else {
            this.postMessage(what, funcId, interval, instanceId);
        }
    }

    private void removeOrHoldMessage(int what, int funcId) {
        if (this.mWXSDKInstance.isPreRenderMode()) {
            this.handler.removeMessages(what, this.antiIntAutoBoxing.get(funcId, (Object)funcId));
        } else {
            this.handler.removeMessages(what, this.antiIntAutoBoxing.get(funcId, (Object)funcId));
        }
    }

    private void postMessage(int what, @IntRange(from=1L) int funcId, @IntRange(from=0L) int interval, int instanceId) {
        if (interval < 0 || funcId <= 0) {
            WXLogUtils.e(TAG, "interval < 0 or funcId <=0");
        } else {
            if (this.antiIntAutoBoxing.get(funcId) == null) {
                this.antiIntAutoBoxing.put(funcId, (Object)funcId);
            }
            Message message = this.handler.obtainMessage(what, instanceId, interval, this.antiIntAutoBoxing.get(funcId));
            this.handler.sendMessageDelayed(message, (long)interval);
        }
    }
}

