/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.module;

import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.common.WXModule;
import com.taobao.weex.utils.LogLevel;

public class ConsoleLogModule
extends WXModule {
    @JSMethod(uiThread=false)
    public void switchLogLevel(@Nullable String logLevel, @Nullable JSCallback callback) {
        LogLevel logLevelEnum = this.getLogLevel(logLevel);
        ArrayMap ret = new ArrayMap();
        if (logLevelEnum != null) {
            WXEnvironment.sLogLevel = logLevelEnum;
            WXBridgeManager.getInstance().setLogLevel(WXEnvironment.sLogLevel.getValue(), WXEnvironment.isPerf());
            ret.put("status", "success");
        } else {
            ret.put("status", "failure");
        }
        if (callback != null) {
            callback.invoke(ret);
        }
    }

    @JSMethod(uiThread=false)
    public void setPerfMode(@Nullable String on) {
        WXEnvironment.isPerf = "true".equals(on);
        WXBridgeManager.getInstance().setLogLevel(WXEnvironment.sLogLevel.getValue(), WXEnvironment.isPerf());
    }

    @Nullable
    private LogLevel getLogLevel(@Nullable String logLevel) {
        LogLevel logLevelEnum = null;
        if (!TextUtils.isEmpty((CharSequence)logLevel)) {
            switch (logLevel) {
                case "off": {
                    logLevelEnum = LogLevel.OFF;
                    break;
                }
                case "error": {
                    logLevelEnum = LogLevel.ERROR;
                    break;
                }
                case "warning": {
                    logLevelEnum = LogLevel.WARN;
                    break;
                }
                case "info": {
                    logLevelEnum = LogLevel.INFO;
                    break;
                }
                case "debug": {
                    logLevelEnum = LogLevel.DEBUG;
                }
            }
        }
        return logLevelEnum;
    }
}

