/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.annotation.NonNull;
import android.support.v4.content.LocalBroadcastManager;
import android.text.Layout;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.annotation.Component;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.layout.measurefunc.TextContentBoxMeasurement;
import com.taobao.weex.ui.ComponentCreator;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.flat.FlatComponent;
import com.taobao.weex.ui.flat.widget.TextWidget;
import com.taobao.weex.ui.view.WXTextView;
import com.taobao.weex.utils.FontDO;
import com.taobao.weex.utils.TypefaceUtil;
import com.taobao.weex.utils.WXLogUtils;
import java.lang.reflect.InvocationTargetException;

@Component(lazyload=false)
public class WXText
extends WXComponent<WXTextView>
implements FlatComponent<TextWidget> {
    private TextWidget mTextWidget;
    public static final int sDEFAULT_SIZE = 32;
    private BroadcastReceiver mTypefaceObserver;
    private String mFontFamily;

    @Override
    public boolean promoteToView(boolean checkAncestor) {
        if (null != this.getInstance().getFlatUIContext()) {
            return this.getInstance().getFlatUIContext().promoteToView(this, checkAncestor, WXText.class);
        }
        return false;
    }

    @Override
    @NonNull
    public TextWidget getOrCreateFlatWidget() {
        if (this.mTextWidget == null) {
            this.mTextWidget = new TextWidget(this.getInstance().getFlatUIContext());
        }
        return this.mTextWidget;
    }

    @Override
    public boolean isVirtualComponent() {
        return !this.promoteToView(true);
    }

    @Deprecated
    public WXText(WXSDKInstance instance, WXVContainer parent, String instanceId, boolean isLazy, BasicComponentData basicComponentData) {
        this(instance, parent, basicComponentData);
    }

    public WXText(WXSDKInstance instance, WXVContainer parent, BasicComponentData basicComponentData) {
        super(instance, parent, basicComponentData);
        this.setContentBoxMeasurement(new TextContentBoxMeasurement(this));
    }

    @Override
    protected WXTextView initComponentHostView(@NonNull Context context) {
        WXTextView textView = new WXTextView(context);
        textView.holdComponent(this);
        return textView;
    }

    @Override
    public void updateExtra(Object extra) {
        super.updateExtra(extra);
        if (extra instanceof Layout) {
            Layout layout2 = (Layout)extra;
            if (!this.promoteToView(true)) {
                this.getOrCreateFlatWidget().updateTextDrawable(layout2);
            } else if (this.getHostView() != null && !extra.equals(((WXTextView)this.getHostView()).getTextLayout())) {
                ((WXTextView)this.getHostView()).setTextLayout(layout2);
                ((WXTextView)this.getHostView()).invalidate();
            }
        }
    }

    @Override
    protected void setAriaLabel(String label) {
        WXTextView text = (WXTextView)this.getHostView();
        if (text != null) {
            text.setAriaLabel(label);
        }
    }

    @Override
    public void refreshData(WXComponent component) {
        super.refreshData(component);
        if (component instanceof WXText) {
            this.updateExtra(component.getExtra());
        }
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        switch (key) {
            case "lines": 
            case "fontSize": 
            case "fontWeight": 
            case "fontStyle": 
            case "color": 
            case "textDecoration": 
            case "textAlign": 
            case "textOverflow": 
            case "lineHeight": 
            case "value": {
                return true;
            }
            case "fontFamily": {
                if (param != null) {
                    this.registerTypefaceObserver(param.toString());
                }
                return true;
            }
        }
        return super.setProperty(key, param);
    }

    @Override
    protected Object convertEmptyProperty(String propName, Object originalValue) {
        switch (propName) {
            case "fontSize": {
                return 32;
            }
            case "color": {
                return "black";
            }
        }
        return super.convertEmptyProperty(propName, originalValue);
    }

    @Override
    protected void createViewImpl() {
        if (this.promoteToView(true)) {
            super.createViewImpl();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (WXEnvironment.getApplication() != null && this.mTypefaceObserver != null) {
            WXLogUtils.d("WXText", "Unregister the typeface observer");
            LocalBroadcastManager.getInstance((Context)WXEnvironment.getApplication()).unregisterReceiver(this.mTypefaceObserver);
            this.mTypefaceObserver = null;
        }
    }

    private void registerTypefaceObserver(String desiredFontFamily) {
        if (WXEnvironment.getApplication() == null) {
            WXLogUtils.w("WXText", "ApplicationContent is null on register typeface observer");
            return;
        }
        this.mFontFamily = desiredFontFamily;
        if (this.mTypefaceObserver != null) {
            return;
        }
        this.mTypefaceObserver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String fontFamily = intent.getStringExtra("fontFamily");
                if (!WXText.this.mFontFamily.equals(fontFamily)) {
                    return;
                }
                FontDO fontDO = TypefaceUtil.getFontDO(fontFamily);
                if (fontDO != null && fontDO.getTypeface() != null && WXText.this.getHostView() != null) {
                    WXTextView hostView = (WXTextView)WXText.this.getHostView();
                    Layout layout2 = hostView.getTextLayout();
                    if (layout2 != null) {
                        layout2.getPaint().setTypeface(fontDO.getTypeface());
                    } else {
                        WXLogUtils.d("WXText", "Layout not created");
                    }
                    WXBridgeManager.getInstance().markDirty(WXText.this.getInstanceId(), WXText.this.getRef(), true);
                    WXText.this.forceRelayout();
                }
            }
        };
        LocalBroadcastManager.getInstance((Context)WXEnvironment.getApplication()).registerReceiver(this.mTypefaceObserver, new IntentFilter("type_face_available"));
    }

    @Override
    protected void layoutDirectionDidChanged(boolean isRTL) {
        this.forceRelayout();
    }

    private void forceRelayout() {
        WXBridgeManager.getInstance().post(new Runnable(){

            @Override
            public void run() {
                if (WXText.this.contentBoxMeasurement instanceof TextContentBoxMeasurement) {
                    ((TextContentBoxMeasurement)WXText.this.contentBoxMeasurement).forceRelayout();
                }
            }
        });
    }

    public static class Creator
    implements ComponentCreator {
        @Override
        public WXComponent createInstance(WXSDKInstance instance, WXVContainer parent, BasicComponentData basicComponentData) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            return new WXText(instance, parent, basicComponentData);
        }
    }
}

