/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui;

import android.opengl.GLES10;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.text.TextUtils;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.dom.RenderContext;
import com.taobao.weex.ui.RenderContextImpl;
import com.taobao.weex.ui.WXRenderHandler;
import com.taobao.weex.ui.action.BasicGraphicAction;
import com.taobao.weex.ui.action.GraphicActionBatchAction;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.utils.WXExceptionUtils;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

public class WXRenderManager {
    private volatile ConcurrentHashMap<String, RenderContextImpl> mRenderContext;
    private WXRenderHandler mWXRenderHandler;
    private String mCurrentBatchInstanceId = null;
    private ArrayList<Map<String, Object>> mBatchActions = new ArrayList();
    private final int MAX_DROP_FRAME_NATIVE_BATCH = 2000;
    private static final String sKeyAction = "Action";
    private static int nativeBatchTimes = 0;
    private static int mOpenGLRenderLimitValue = 0;

    public WXRenderManager() {
        this.mRenderContext = new ConcurrentHashMap();
        this.mWXRenderHandler = new WXRenderHandler();
    }

    public RenderContext getRenderContext(String instanceId) {
        return this.mRenderContext.get(instanceId);
    }

    @Nullable
    public WXComponent getWXComponent(String instanceId, String ref) {
        if (instanceId == null || TextUtils.isEmpty((CharSequence)ref)) {
            return null;
        }
        RenderContext stmt = this.getRenderContext(instanceId);
        return stmt == null ? null : stmt.getComponent(ref);
    }

    public WXSDKInstance getWXSDKInstance(String instanceId) {
        RenderContextImpl statement = this.mRenderContext.get(instanceId);
        if (statement == null) {
            return null;
        }
        return statement.getWXSDKInstance();
    }

    public static int getOpenGLRenderLimitValue() {
        if (mOpenGLRenderLimitValue == 0) {
            int maxsize = 0;
            try {
                EGL10 egl = (EGL10)EGLContext.getEGL();
                EGLDisplay dpy = egl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
                int[] vers = new int[2];
                egl.eglInitialize(dpy, vers);
                int[] configAttr = new int[]{12351, 12430, 12329, 0, 12339, 1, 12344};
                EGLConfig[] configs = new EGLConfig[1];
                int[] numConfig = new int[1];
                egl.eglChooseConfig(dpy, configAttr, configs, 1, numConfig);
                if (numConfig[0] == 0) {
                    maxsize = -1;
                    egl.eglTerminate(dpy);
                } else {
                    EGLConfig config = configs[0];
                    int[] surfAttr = new int[]{12375, 64, 12374, 64, 12344};
                    EGLSurface surf = egl.eglCreatePbufferSurface(dpy, config, surfAttr);
                    int EGL_CONTEXT_CLIENT_VERSION = 12440;
                    int[] ctxAttrib = new int[]{12440, 1, 12344};
                    EGLContext ctx = egl.eglCreateContext(dpy, config, EGL10.EGL_NO_CONTEXT, ctxAttrib);
                    egl.eglMakeCurrent(dpy, surf, surf, ctx);
                    int[] maxSize = new int[1];
                    GLES10.glGetIntegerv((int)3379, (int[])maxSize, (int)0);
                    egl.eglMakeCurrent(dpy, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
                    egl.eglDestroySurface(dpy, surf);
                    egl.eglDestroyContext(dpy, ctx);
                    egl.eglTerminate(dpy);
                    maxsize = maxSize[0];
                }
            }
            catch (Exception e) {
                WXLogUtils.e(WXLogUtils.getStackTrace(e));
            }
            mOpenGLRenderLimitValue = maxsize;
        }
        return mOpenGLRenderLimitValue;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void postOnUiThread(Runnable runnable, long delayMillis) {
        this.mWXRenderHandler.postDelayed(WXThread.secure(runnable), delayMillis);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void postOnUiThread(Runnable runnable, String instanceId) {
        this.mWXRenderHandler.post(instanceId, WXThread.secure(runnable));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void postOnUiThread(Runnable runnable) {
        this.mWXRenderHandler.post(WXThread.secure(runnable));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void removeTask(Runnable runnable) {
        this.mWXRenderHandler.removeCallbacks(runnable);
    }

    public void removeRenderStatement(String instanceId) {
        if (!WXUtils.isUiThread()) {
            throw new WXRuntimeException("[WXRenderManager] removeRenderStatement can only be called in main thread");
        }
        RenderContextImpl statement = this.mRenderContext.remove(instanceId);
        if (statement != null) {
            statement.destroy();
        }
        if (instanceId == null) {
            this.mWXRenderHandler.removeCallbacksAndMessages(null);
        } else {
            this.mWXRenderHandler.removeMessages(instanceId.hashCode());
        }
    }

    private void postAllStashedGraphicAction(String instanceId, BasicGraphicAction action) {
        RenderContextImpl renderContext = this.mRenderContext.get(instanceId);
        ArrayList<Map<String, Object>> tmpList = null;
        if (renderContext != null) {
            tmpList = new ArrayList<Map<String, Object>>(this.mBatchActions);
        }
        this.mBatchActions.clear();
        this.mCurrentBatchInstanceId = null;
        nativeBatchTimes = 0;
        if (renderContext == null) {
            return;
        }
        ArrayList<BasicGraphicAction> actions = new ArrayList<BasicGraphicAction>(tmpList.size());
        for (int i = 0; i < tmpList.size(); ++i) {
            Map<String, Object> item = tmpList.get(i);
            Object mustBeAction = item.get(sKeyAction);
            if (!(mustBeAction instanceof BasicGraphicAction)) continue;
            BasicGraphicAction tmpAction = (BasicGraphicAction)mustBeAction;
            if (tmpAction.mActionType == 1 || tmpAction.mActionType == 2) continue;
            actions.add(tmpAction);
        }
        this.postGraphicAction(instanceId, new GraphicActionBatchAction(action.getWXSDKIntance(), action.getRef(), actions));
    }

    public void postGraphicAction(String instanceId, BasicGraphicAction action) {
        Map<String, Object> lastItem;
        Object mustBeAction;
        RenderContextImpl renderContext = this.mRenderContext.get(instanceId);
        if (renderContext == null) {
            return;
        }
        if (this.mCurrentBatchInstanceId != null && instanceId != null && !this.mCurrentBatchInstanceId.equals(instanceId) && this.mBatchActions.size() > 0 && (mustBeAction = (lastItem = this.mBatchActions.get(this.mBatchActions.size() - 1)).get(sKeyAction)) instanceof BasicGraphicAction) {
            BasicGraphicAction lastAction = (BasicGraphicAction)mustBeAction;
            this.postAllStashedGraphicAction(this.mCurrentBatchInstanceId, lastAction);
        }
        if (action.mActionType == 2) {
            this.postAllStashedGraphicAction(instanceId, action);
            return;
        }
        if (action.mActionType == 1 || this.mBatchActions.size() > 0) {
            if (++nativeBatchTimes > 2000) {
                this.postAllStashedGraphicAction(instanceId, action);
            } else {
                HashMap<String, BasicGraphicAction> item = new HashMap<String, BasicGraphicAction>(1);
                item.put(sKeyAction, action);
                this.mBatchActions.add(item);
                this.mCurrentBatchInstanceId = instanceId;
                return;
            }
        }
        this.mWXRenderHandler.post(instanceId, action);
    }

    public void registerInstance(WXSDKInstance instance) {
        if (instance.getInstanceId() == null) {
            WXExceptionUtils.commitCriticalExceptionRT(null, WXErrorCode.WX_RENDER_ERR_INSTANCE_ID_NULL, "registerInstance", WXErrorCode.WX_RENDER_ERR_INSTANCE_ID_NULL.getErrorMsg() + "instanceId is null", null);
        } else {
            this.mRenderContext.put(instance.getInstanceId(), new RenderContextImpl(instance));
        }
    }

    public List<WXSDKInstance> getAllInstances() {
        ArrayList<WXSDKInstance> instances = null;
        if (this.mRenderContext != null && !this.mRenderContext.isEmpty()) {
            instances = new ArrayList<WXSDKInstance>();
            for (Map.Entry<String, RenderContextImpl> entry : this.mRenderContext.entrySet()) {
                RenderContextImpl renderStatement = entry.getValue();
                if (renderStatement == null) continue;
                instances.add(renderStatement.getWXSDKInstance());
            }
        }
        return instances;
    }

    public void registerComponent(String instanceId, String ref, WXComponent comp) {
        RenderContextImpl statement = this.mRenderContext.get(instanceId);
        if (statement != null) {
            statement.registerComponent(ref, comp);
            if (null != statement.getInstance()) {
                statement.getInstance().getApmForInstance().updateMaxStats("wxMaxComponentCount", statement.getComponentCount());
            }
        }
    }

    public WXComponent unregisterComponent(String instanceId, String ref) {
        RenderContextImpl statement = this.mRenderContext.get(instanceId);
        if (statement != null) {
            if (null != statement.getInstance()) {
                statement.getInstance().getApmForInstance().updateMaxStats("wxMaxComponentCount", statement.getComponentCount());
            }
            return statement.unregisterComponent(ref);
        }
        return null;
    }
}

