/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom;

import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import android.support.annotation.UiThread;
import android.support.v4.util.ArrayMap;
import android.support.v4.util.SimpleArrayMap;
import android.text.TextUtils;
import com.taobao.weex.common.WXImageSharpen;
import com.taobao.weex.dom.WXImageQuality;
import com.taobao.weex.dom.binding.ELUtils;
import com.taobao.weex.dom.binding.WXStatement;
import com.taobao.weex.el.parse.Parser;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class WXAttr
implements Map<String, Object>,
Cloneable {
    private static final long serialVersionUID = -2619357510079360946L;
    @NonNull
    private Map<String, Object> attr;
    private Map<String, Object> writeAttr;
    private ArrayMap<String, Object> mBindingAttrs;
    private WXStatement mStatement;

    public WXAttr() {
        this.attr = new HashMap<String, Object>();
    }

    public WXAttr(@NonNull Map<String, Object> standardMap) {
        this.attr = standardMap;
    }

    public WXAttr(@NonNull Map<String, Object> standardMap, int extra) {
        this.attr = standardMap;
    }

    public static String getPrefix(Map<String, Object> attr) {
        if (attr == null) {
            return null;
        }
        Object src = attr.get("prefix");
        if (src == null) {
            return null;
        }
        return src.toString();
    }

    public static String getSuffix(Map<String, Object> attr) {
        if (attr == null) {
            return null;
        }
        Object src = attr.get("suffix");
        if (src == null) {
            return null;
        }
        return src.toString();
    }

    public static String getValue(Map<String, Object> attr) {
        if (attr == null) {
            return null;
        }
        Object src = attr.get("value");
        if (src == null && (src = attr.get("content")) == null) {
            return null;
        }
        return src.toString();
    }

    public WXImageQuality getImageQuality() {
        String value;
        Object obj = this.containsKey("quality") ? this.get("quality") : this.get("imageQuality");
        WXImageQuality imageQuality = WXImageQuality.AUTO;
        if (obj != null && !TextUtils.isEmpty((CharSequence)(value = obj.toString()))) {
            try {
                imageQuality = WXImageQuality.valueOf(value.toUpperCase(Locale.US));
            }
            catch (IllegalArgumentException e) {
                WXLogUtils.e("Image", "Invalid value image quality. Only low, normal, high, original are valid");
            }
        }
        return imageQuality;
    }

    public WXImageSharpen getImageSharpen() {
        Object obj = this.get("sharpen");
        if (obj == null) {
            obj = this.get("imageSharpen");
        }
        if (obj == null) {
            return WXImageSharpen.UNSHARPEN;
        }
        String imageSharpen = obj.toString();
        WXImageSharpen waImageSharpen = WXImageSharpen.UNSHARPEN;
        if (imageSharpen.equals("sharpen")) {
            waImageSharpen = WXImageSharpen.SHARPEN;
        }
        return waImageSharpen;
    }

    public String getImageSrc() {
        Object src = this.get("src");
        if (src == null) {
            return null;
        }
        return src.toString();
    }

    public boolean canRecycled() {
        Object obj = this.get("recycle");
        if (obj == null) {
            return true;
        }
        try {
            return Boolean.parseBoolean(String.valueOf(obj));
        }
        catch (Exception e) {
            WXLogUtils.e("[WXAttr] recycle:", e);
            return true;
        }
    }

    public boolean showIndicators() {
        Object obj = this.get("showIndicators");
        if (obj == null) {
            return true;
        }
        try {
            return Boolean.parseBoolean(String.valueOf(obj));
        }
        catch (Exception e) {
            WXLogUtils.e("[WXAttr] showIndicators:", e);
            return true;
        }
    }

    public boolean autoPlay() {
        Object obj = this.get("autoPlay");
        if (obj == null) {
            return false;
        }
        try {
            return Boolean.parseBoolean(String.valueOf(obj));
        }
        catch (Exception e) {
            WXLogUtils.e("[WXAttr] autoPlay:", e);
            return false;
        }
    }

    public String getScope() {
        Object src = this.get("scope");
        if (src == null) {
            return null;
        }
        return src.toString();
    }

    public String getLoadMoreRetry() {
        Object src = this.get("loadmoreretry");
        if (src == null) {
            return null;
        }
        return src.toString();
    }

    public String getLoadMoreOffset() {
        Object src = this.get("loadmoreoffset");
        if (src == null) {
            return null;
        }
        return src.toString();
    }

    public String optString(String key) {
        if (this.containsKey(key)) {
            Object value = this.get(key);
            if (value instanceof String) {
                return (String)value;
            }
            if (value != null) {
                return String.valueOf(value);
            }
        }
        return "";
    }

    public boolean getIsRecycleImage() {
        Object obj = this.get("recycleImage");
        if (obj == null) {
            return true;
        }
        try {
            return Boolean.parseBoolean(String.valueOf(obj));
        }
        catch (Exception e) {
            WXLogUtils.e("[WXAttr] recycleImage:", e);
            return false;
        }
    }

    public String getScrollDirection() {
        Object scrollDirection = this.get("scrollDirection");
        if (scrollDirection == null) {
            return "vertical";
        }
        return scrollDirection.toString();
    }

    public int getOrientation() {
        String direction = this.getScrollDirection();
        if (!TextUtils.isEmpty((CharSequence)direction) && direction.equals("horizontal")) {
            return 0;
        }
        Object value = this.get("orientation");
        if (value != null && "horizontal".equals(value.toString())) {
            return 0;
        }
        return 1;
    }

    public float getElevation(int viewPortW) {
        Object obj = this.get("elevation");
        float ret = Float.NaN;
        if (obj != null) {
            String number = obj.toString();
            ret = !TextUtils.isEmpty((CharSequence)number) ? WXViewUtils.getRealSubPxByWidth(WXUtils.getFloat(number), viewPortW) : 0.0f;
        }
        return ret;
    }

    public float getColumnWidth() {
        Object obj = this.get("columnWidth");
        if (obj == null) {
            return -1.0f;
        }
        String value = String.valueOf(obj);
        if ("auto".equals(value)) {
            return -1.0f;
        }
        try {
            float columnWidth = Float.parseFloat(value);
            return columnWidth > 0.0f ? columnWidth : 0.0f;
        }
        catch (Exception e) {
            WXLogUtils.e("[WXAttr] getColumnWidth:", e);
            return -1.0f;
        }
    }

    public int getColumnCount() {
        Object obj = this.get("columnCount");
        if (obj == null) {
            return -1;
        }
        String value = String.valueOf(obj);
        if ("auto".equals(value)) {
            return -1;
        }
        try {
            int columnCount = Integer.parseInt(value);
            return columnCount > 0 ? columnCount : -1;
        }
        catch (Exception e) {
            WXLogUtils.e("[WXAttr] getColumnCount:", e);
            return -1;
        }
    }

    public float getColumnGap() {
        Object obj = this.get("columnGap");
        if (obj == null) {
            return 32.0f;
        }
        String value = String.valueOf(obj);
        if ("normal".equals(value)) {
            return 32.0f;
        }
        try {
            float columnGap = Float.parseFloat(value);
            return columnGap >= 0.0f ? columnGap : -1.0f;
        }
        catch (Exception e) {
            WXLogUtils.e("[WXAttr] getColumnGap:", e);
            return 32.0f;
        }
    }

    public int getLayoutType() {
        Object obj = this.get("layout");
        if (obj == null) {
            return 1;
        }
        try {
            switch (String.valueOf(obj)) {
                case "multi-column": {
                    return 3;
                }
                case "grid": {
                    return 2;
                }
            }
            return 1;
        }
        catch (Exception e) {
            WXLogUtils.e("[WXAttr] getLayoutType:", e);
            return 1;
        }
    }

    @Override
    public boolean equals(Object o) {
        return this.attr.equals(o);
    }

    @Override
    public int hashCode() {
        return this.attr.hashCode();
    }

    @Override
    public void clear() {
        this.attr.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.attr.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.attr.containsValue(value);
    }

    @Override
    @NonNull
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.attr.entrySet();
    }

    @Override
    public Object get(Object key) {
        Object obj;
        Map<String, Object> temp = this.writeAttr;
        if (null != temp && null != (obj = temp.get(key))) {
            return obj;
        }
        return this.attr.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.attr.isEmpty();
    }

    @Override
    @NonNull
    public Set<String> keySet() {
        return this.attr.keySet();
    }

    @Override
    public Object put(String key, Object value) {
        if (this.addBindingAttrIfStatement(key, value)) {
            return null;
        }
        return this.attr.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ?> map) {
        if (this.writeAttr == null) {
            this.writeAttr = new ArrayMap();
        }
        this.writeAttr.putAll(map);
    }

    @Override
    public Object remove(Object key) {
        return this.attr.remove(key);
    }

    @Override
    public int size() {
        return this.attr.size();
    }

    @Override
    @NonNull
    public Collection<Object> values() {
        return this.attr.values();
    }

    public ArrayMap<String, Object> getBindingAttrs() {
        return this.mBindingAttrs;
    }

    public WXStatement getStatement() {
        return this.mStatement;
    }

    public void setBindingAttrs(ArrayMap<String, Object> mBindingAttrs) {
        this.mBindingAttrs = mBindingAttrs;
    }

    public void setStatement(WXStatement mStatement) {
        this.mStatement = mStatement;
    }

    public void parseStatements() {
        if (this.attr != null) {
            this.attr = this.filterStatementsFromAttrs(this.attr);
        }
    }

    private Map<String, Object> filterStatementsFromAttrs(Map attrs) {
        if (attrs == null || attrs.size() == 0) {
            return attrs;
        }
        Set entries = attrs.entrySet();
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if ("@componentProps".equals(entry.getKey())) {
                Object blockValue = ELUtils.bindingBlock(entry.getValue());
                entry.setValue(blockValue);
                continue;
            }
            if (!this.addBindingAttrIfStatement((String)entry.getKey(), entry.getValue())) continue;
            it.remove();
        }
        return attrs;
    }

    private boolean addBindingAttrIfStatement(String key, Object value) {
        for (String exclude : ELUtils.EXCLUDES_BINDING) {
            if (!key.equals(exclude)) continue;
            return false;
        }
        if (ELUtils.isBinding(value)) {
            if (this.mBindingAttrs == null) {
                this.mBindingAttrs = new ArrayMap();
            }
            value = ELUtils.bindingBlock(value);
            this.mBindingAttrs.put((Object)key, value);
            return true;
        }
        if ("[[match]]".equals(key)) {
            if (this.mStatement == null) {
                this.mStatement = new WXStatement();
            }
            if (value != null) {
                this.mStatement.put(key, Parser.parse(value.toString()));
            }
            return true;
        }
        if ("[[repeat]]".equals(key)) {
            if (this.mStatement == null) {
                this.mStatement = new WXStatement();
            }
            if ((value = ELUtils.vforBlock(value)) != null) {
                this.mStatement.put(key, value);
                return true;
            }
        }
        if ("[[once]]".equals(key)) {
            if (this.mStatement == null) {
                this.mStatement = new WXStatement();
            }
            this.mStatement.put(key, true);
        }
        return false;
    }

    public void skipFilterPutAll(Map<String, Object> attrs) {
        this.attr.putAll(attrs);
    }

    @UiThread
    public void mergeAttr() {
        if (null != this.writeAttr) {
            this.attr.putAll(this.writeAttr);
            this.writeAttr = null;
        }
    }

    public WXAttr clone() {
        WXAttr wxAttr = new WXAttr();
        wxAttr.skipFilterPutAll(this.attr);
        if (this.mBindingAttrs != null) {
            wxAttr.mBindingAttrs = new ArrayMap(this.mBindingAttrs);
        }
        if (this.mStatement != null) {
            wxAttr.mStatement = new WXStatement((SimpleArrayMap)this.mStatement);
        }
        return wxAttr;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public String toString() {
        return this.attr.toString();
    }
}

