/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.common;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.tools.LogDetail;
import java.lang.ref.WeakReference;

public class WXThread
extends HandlerThread {
    private Handler mHandler;

    public static Runnable secure(Runnable runnable) {
        return WXThread.secure(runnable, null, null);
    }

    public static Runnable secure(Runnable runnable, WXSDKInstance instance, String runnableName) {
        if (runnable == null || runnable instanceof SafeRunnable) {
            return runnable;
        }
        return new SafeRunnable(runnable, instance, runnableName);
    }

    public static Handler.Callback secure(Handler.Callback callback) {
        if (callback == null || callback instanceof SafeCallback) {
            return callback;
        }
        return new SafeCallback(callback);
    }

    public WXThread(String name) {
        super(name);
        this.start();
        this.mHandler = new Handler(this.getLooper());
    }

    public WXThread(String name, Handler.Callback callback) {
        super(name);
        this.start();
        this.mHandler = new Handler(this.getLooper(), WXThread.secure(callback));
    }

    public WXThread(String name, int priority, Handler.Callback callback) {
        super(name, priority);
        this.start();
        this.mHandler = new Handler(this.getLooper(), WXThread.secure(callback));
    }

    public WXThread(String name, int priority) {
        super(name, priority);
        this.start();
        this.mHandler = new Handler(this.getLooper());
    }

    public Handler getHandler() {
        return this.mHandler;
    }

    public boolean isWXThreadAlive() {
        return this.mHandler != null && this.getLooper() != null && this.isAlive();
    }

    public boolean quit() {
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
        }
        return super.quit();
    }

    static class SafeCallback
    implements Handler.Callback {
        static final String TAG = "SafeCallback";
        final Handler.Callback mCallback;

        SafeCallback(Handler.Callback cb) {
            this.mCallback = cb;
        }

        public boolean handleMessage(Message msg) {
            boolean result;
            block3: {
                result = false;
                try {
                    if (this.mCallback != null) {
                        result = this.mCallback.handleMessage(msg);
                    }
                }
                catch (Throwable e) {
                    if (!WXEnvironment.isApkDebugable()) break block3;
                    WXLogUtils.e(TAG, "SafeCallback handleMessage throw expection:" + e.getMessage());
                    throw e;
                }
            }
            return result;
        }
    }

    static class SafeRunnable
    implements Runnable {
        static final String TAG = "SafeRunnable";
        private LogDetail mTimelineLog = null;
        private WeakReference<WXSDKInstance> mInstance;
        final Runnable mTask;

        SafeRunnable(Runnable task) {
            this(task, null);
        }

        SafeRunnable(Runnable task, String taskName) {
            this(task, null, taskName);
        }

        SafeRunnable(Runnable runnable, WXSDKInstance instance, String taskName) {
            this.mTask = runnable;
            if (taskName != null) {
                this.mTimelineLog = new LogDetail();
                this.mTimelineLog.info.platform = "Android";
                this.mTimelineLog.name(taskName);
                this.mInstance = new WeakReference<WXSDKInstance>(instance);
            }
        }

        @Override
        public void run() {
            WXSDKInstance wxsdkInstance;
            try {
                if (this.mTask != null) {
                    if (this.mTimelineLog != null) {
                        this.mTimelineLog.taskStart();
                    }
                    this.mTask.run();
                    if (this.mTimelineLog != null) {
                        this.mTimelineLog.taskEnd();
                    }
                }
            }
            catch (Throwable e) {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.e(TAG, "SafeRunnable run throw expection:" + e.getMessage());
                    throw e;
                }
                WXLogUtils.w(TAG, e);
            }
            if (this.mTimelineLog != null && this.mInstance != null && (wxsdkInstance = (WXSDKInstance)this.mInstance.get()) != null) {
                wxsdkInstance.mTimeCalculator.addLog(this.mTimelineLog);
            }
        }
    }
}

