/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.common;

import android.support.annotation.RestrictTo;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

@Deprecated
public class WXPerformance {
    public static final String DEFAULT = "default";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final String CACHE_TYPE = "cacheType";
    public static final int VIEW_LIMIT_HEIGHT = WXViewUtils.getScreenHeight() / 3 * 2;
    public static final int VIEW_LIMIT_WIDTH = WXViewUtils.getScreenWidth() / 3 * 2;
    public static boolean TRACE_DATA = WXEnvironment.isApkDebugable();
    @Deprecated
    public String bizType = "weex";
    @Deprecated
    public String templateUrl;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public String cacheType = "none";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public long renderTimeOrigin;
    public long renderUnixTimeOrigin;
    public long fsRenderTime;
    public long callCreateFinishTime;
    public long interactionTime;
    public long interactionRealUnixTime;
    public int interactionViewAddCount;
    public int interactionViewAddLimitCount;
    public long newFsRenderTime;
    public int localInteractionViewAddCount;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public long callCreateInstanceTime;
    public long fsCallJsTotalTime;
    public int fsCallJsTotalNum;
    public long fsCallNativeTotalTime;
    public int fsCallNativeTotalNum;
    public int fsRequestNum;
    public int fsComponentCount;
    public int fsComponentCreateTime;
    public int cellExceedNum;
    public int timerInvokeCount;
    public int fsCallEventTotalNum;
    public long avgFPS;
    public double fluency = 100.0;
    public long backImproveMemory;
    public double localReadTime;
    public String pageName = "default";
    public double JSLibSize;
    public long JSLibInitTime;
    public double JSTemplateSize;
    public long templateLoadTime;
    @Deprecated
    public long communicateTime;
    public long screenRenderTime;
    public long callBridgeTime;
    public long firstScreenJSFExecuteTime;
    public long parseJsonTime;
    public long cssLayoutTime;
    public double totalTime;
    public long networkTime;
    public long pureNetworkTime;
    public long actualNetworkTime;
    public long packageSpendTime;
    public long syncTaskTime;
    public int maxDeepViewLayer;
    public int maxDeepVDomLayer;
    public double wrongImgSizeCount;
    public int useScroller = 0;
    public long componentCount;
    public long componentCreateTime;
    public String JSLibVersion = WXEnvironment.JS_LIB_SDK_VERSION;
    public String WXSDKVersion = WXEnvironment.WXSDK_VERSION;
    public String renderFailedDetail;
    public String errCode;
    @Deprecated
    public String errMsg;
    private StringBuilder mErrMsgBuilder;
    public String args = "";
    public String connectionType;
    public String requestType = "other";
    public String zCacheInfo;
    @Deprecated
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public String[] wxDims = new String[5];
    @Deprecated
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public long[] measureTimes = new long[5];
    public int mActionAddElementCount = 0;
    public int mActionAddElementSumTime = 0;
    private String mInstanceId;

    public WXPerformance(String instanceId) {
        this.mErrMsgBuilder = new StringBuilder();
        this.mInstanceId = instanceId;
    }

    public Map<String, Double> getMeasureMap() {
        double fsRenderTime = this.fsRenderTime != 0L ? (double)(this.fsRenderTime - this.renderTimeOrigin) : (this.totalTime != 0.0 ? this.totalTime : -1.0);
        HashMap<String, Double> quotas = new HashMap<String, Double>();
        quotas.put(Measure.JSLibSize.toString(), this.JSLibSize);
        quotas.put(Measure.JSLibInitTime.toString(), Double.valueOf(this.JSLibInitTime));
        quotas.put(Measure.SDKInitTime.toString(), Double.valueOf(WXEnvironment.sSDKInitTime));
        quotas.put(Measure.SDKInitInvokeTime.toString(), Double.valueOf(WXEnvironment.sSDKInitInvokeTime));
        quotas.put(Measure.SDKInitExecuteTime.toString(), Double.valueOf(WXEnvironment.sSDKInitExecuteTime));
        quotas.put(Measure.JSTemplateSize.toString(), this.JSTemplateSize);
        quotas.put(Measure.pureNetworkTime.toString(), Double.valueOf(this.pureNetworkTime));
        quotas.put(Measure.networkTime.toString(), Double.valueOf(this.networkTime));
        quotas.put(Measure.fsCreateInstanceTime.toString(), Double.valueOf(this.callCreateInstanceTime));
        quotas.put(Measure.fsCallJsTotalTime.toString(), Double.valueOf(this.fsCallJsTotalTime));
        quotas.put(Measure.fsCallJsTotalNum.toString(), Double.valueOf(this.fsCallJsTotalNum));
        quotas.put(Measure.fsCallNativeTotalTime.toString(), Double.valueOf(this.fsCallNativeTotalTime));
        quotas.put(Measure.fsCallNativeTotalNum.toString(), Double.valueOf(this.fsCallNativeTotalNum));
        quotas.put(Measure.fsComponentCount.toString(), Double.valueOf(this.fsComponentCount));
        quotas.put(Measure.fsComponentCreateTime.toString(), Double.valueOf(this.fsComponentCreateTime));
        quotas.put(Measure.fsRenderTime.toString(), fsRenderTime);
        quotas.put(Measure.fsRequestNum.toString(), Double.valueOf(this.fsRequestNum));
        quotas.put(Measure.communicateTotalTime.toString(), this.totalTime);
        quotas.put(Measure.maxDeepViewLayer.toString(), Double.valueOf(this.maxDeepViewLayer));
        quotas.put(Measure.maxDeepVDomLayer.toString(), Double.valueOf(this.maxDeepVDomLayer));
        quotas.put(Measure.componentCount.toString(), Double.valueOf(this.componentCount));
        quotas.put(Measure.componentCreateTime.toString(), Double.valueOf(this.componentCreateTime));
        quotas.put(Measure.cellExceedNum.toString(), Double.valueOf(this.cellExceedNum));
        quotas.put(Measure.timerCount.toString(), Double.valueOf(this.timerInvokeCount));
        quotas.put(Measure.avgFps.toString(), Double.valueOf(this.avgFPS));
        quotas.put(Measure.fluency.toString(), this.fluency);
        quotas.put(Measure.MaxImproveMemory.toString(), 0.0);
        quotas.put(Measure.BackImproveMemory.toString(), Double.valueOf(this.backImproveMemory));
        quotas.put(Measure.PushImproveMemory.toString(), 0.0);
        quotas.put(Measure.fsCallEventTotalNum.toString(), Double.valueOf(this.fsCallEventTotalNum));
        quotas.put(Measure.callCreateFinishTime.toString(), Double.valueOf(this.callCreateFinishTime));
        quotas.put(Measure.imgSizeCount.toString(), this.wrongImgSizeCount);
        quotas.put(Measure.interactionTime.toString(), Double.valueOf(this.interactionTime));
        quotas.put(Measure.interactionViewAddCount.toString(), Double.valueOf(this.interactionViewAddCount));
        quotas.put(Measure.interactionViewAddLimitCount.toString(), Double.valueOf(this.interactionViewAddLimitCount));
        quotas.put(Measure.newFsRenderTime.toString(), Double.valueOf(this.newFsRenderTime));
        quotas.put(Measure.callBridgeTime.toString(), Double.valueOf(this.callBridgeTime));
        quotas.put(Measure.cssLayoutTime.toString(), Double.valueOf(this.cssLayoutTime));
        quotas.put(Measure.parseJsonTime.toString(), Double.valueOf(this.parseJsonTime));
        quotas.put(Measure.screenRenderTime.toString(), Double.valueOf(this.screenRenderTime));
        quotas.put(Measure.communicateTime.toString(), Double.valueOf(this.communicateTime));
        quotas.put(Measure.localReadTime.toString(), this.localReadTime);
        quotas.put(Measure.templateLoadTime.toString(), Double.valueOf(this.templateLoadTime));
        quotas.put(Measure.firstScreenJSFExecuteTime.toString(), Double.valueOf(this.firstScreenJSFExecuteTime));
        quotas.put(Measure.actualNetworkTime.toString(), Double.valueOf(this.actualNetworkTime));
        quotas.put(Measure.syncTaskTime.toString(), Double.valueOf(this.syncTaskTime));
        quotas.put(Measure.packageSpendTime.toString(), Double.valueOf(this.packageSpendTime));
        quotas.put(Measure.measureTime1.toString(), Double.valueOf(this.measureTimes[0]));
        quotas.put(Measure.measureTime2.toString(), Double.valueOf(this.measureTimes[1]));
        quotas.put(Measure.measureTime3.toString(), Double.valueOf(this.measureTimes[2]));
        quotas.put(Measure.measureTime4.toString(), Double.valueOf(this.measureTimes[3]));
        quotas.put(Measure.measureTime5.toString(), Double.valueOf(this.measureTimes[4]));
        return quotas;
    }

    public Map<String, String> getDimensionMap() {
        HashMap<String, String> quotas = new HashMap<String, String>();
        quotas.put(Dimension.JSLibVersion.toString(), this.JSLibVersion);
        quotas.put(Dimension.WXSDKVersion.toString(), this.WXSDKVersion);
        quotas.put(Dimension.pageName.toString(), this.pageName);
        quotas.put(Dimension.requestType.toString(), this.requestType);
        quotas.put(Dimension.networkType.toString(), "unknown");
        quotas.put(Dimension.connectionType.toString(), this.connectionType);
        quotas.put(Dimension.zcacheInfo.toString(), this.zCacheInfo);
        quotas.put(Dimension.cacheType.toString(), this.cacheType);
        quotas.put(Dimension.useScroller.toString(), String.valueOf(this.useScroller));
        WXSDKInstance sdkInstance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        String keyActivity = "wxContainerName";
        quotas.put(keyActivity, null == sdkInstance ? "unKnow" : sdkInstance.getContainerInfo().get(keyActivity));
        String keyType = "wxInstanceType";
        quotas.put(keyType, sdkInstance == null ? "unKnow" : sdkInstance.getContainerInfo().get(keyType));
        String keyParentPae = "wxParentPage";
        quotas.put(keyParentPae, null == sdkInstance ? "unKnow" : sdkInstance.getContainerInfo().get(keyParentPae));
        quotas.put(Dimension.wxdim1.toString(), this.wxDims[0]);
        quotas.put(Dimension.wxdim2.toString(), this.wxDims[1]);
        quotas.put(Dimension.wxdim3.toString(), this.wxDims[2]);
        quotas.put(Dimension.wxdim4.toString(), this.wxDims[3]);
        quotas.put(Dimension.wxdim5.toString(), this.wxDims[4]);
        quotas.put(Dimension.bizType.toString(), this.bizType);
        quotas.put(Dimension.templateUrl.toString(), this.templateUrl);
        return quotas;
    }

    public static String[] getDimensions() {
        LinkedList<String> ret = new LinkedList<String>();
        for (Dimension dimension : Dimension.values()) {
            ret.add(dimension.toString());
        }
        return ret.toArray(new String[ret.size()]);
    }

    public static String[] getMeasures() {
        LinkedList<String> ret = new LinkedList<String>();
        for (Measure measure : Measure.values()) {
            ret.add(measure.toString());
        }
        return ret.toArray(new String[ret.size()]);
    }

    public String toString() {
        if (WXEnvironment.isApkDebugable()) {
            return "bizType:" + this.bizType + ",pageName:" + this.pageName + ",templateLoadTime" + this.templateLoadTime + ",localReadTime:" + this.localReadTime + ",JSLibInitTime:" + this.JSLibInitTime + ",JSLibSize:" + this.JSLibSize + ",templateUrl" + this.templateUrl + ",JSTemplateSize:" + this.JSTemplateSize + ",communicateTime:" + this.communicateTime + ",screenRenderTime:" + this.screenRenderTime + ",firstScreenJSFExecuteTime:" + this.firstScreenJSFExecuteTime + ",componentCount:" + this.componentCount + ",syncTaskTime:" + this.syncTaskTime + ",pureNetworkTime:" + this.pureNetworkTime + ",networkTime:" + this.networkTime + ",actualNetworkTime:" + this.actualNetworkTime + ",packageSpendTime:" + this.packageSpendTime + ",connectionType:" + this.connectionType + ",requestType:" + this.requestType + ",initInvokeTime:" + WXEnvironment.sSDKInitInvokeTime + ",initExecuteTime:" + WXEnvironment.sSDKInitExecuteTime + ",SDKInitTime:" + WXEnvironment.sSDKInitTime + ",totalTime:" + this.totalTime + ",JSLibVersion:" + this.JSLibVersion + ",WXSDKVersion:" + this.WXSDKVersion + ",errCode:" + this.errCode + ",renderFailedDetail:" + this.renderFailedDetail + ",arg:" + this.args + ",errMsg:" + this.getErrMsg();
        }
        return super.toString();
    }

    public String getPerfData() {
        return "networkTime:" + this.networkTime + " actualNetworkTime:" + this.actualNetworkTime + " connectionType:" + this.connectionType + " requestType:" + this.requestType + " firstScreenRenderTime:" + this.screenRenderTime + " firstScreenJSFExecuteTime:" + this.firstScreenJSFExecuteTime + " componentCount:" + this.componentCount + " JSTemplateSize:" + this.JSTemplateSize + " SDKInitTime:" + WXEnvironment.sSDKInitTime + " totalTime:" + this.totalTime + " JSLibVersion:" + this.JSLibVersion + " WXSDKVersion:" + this.WXSDKVersion + " pageName:" + this.pageName + " useScroller:" + this.useScroller;
    }

    public String getErrMsg() {
        return this.mErrMsgBuilder.toString();
    }

    public void appendErrMsg(CharSequence msg) {
        this.mErrMsgBuilder.append(msg);
    }

    public void beforeInstanceRender(String instanceId) {
        this.renderTimeOrigin = System.currentTimeMillis();
        this.renderUnixTimeOrigin = WXUtils.getFixUnixTime();
    }

    public void afterInstanceDestroy(String instanceId) {
    }

    public static enum Measure {
        JSLibSize(0.0, Double.MAX_VALUE),
        JSLibInitTime(0.0, 80000.0),
        SDKInitTime(0.0, 120000.0),
        SDKInitInvokeTime(0.0, 5000.0),
        SDKInitExecuteTime(0.0, 5000.0),
        JSTemplateSize(0.0, 5000.0),
        pureNetworkTime(0.0, 15000.0),
        networkTime(0.0, 15000.0),
        fsCreateInstanceTime(0.0, 3000.0),
        fsCallJsTotalTime(0.0, 5000.0),
        fsCallJsTotalNum(0.0, Double.MAX_VALUE),
        fsCallNativeTotalTime(0.0, 5000.0),
        fsCallNativeTotalNum(0.0, Double.MAX_VALUE),
        fsCallEventTotalNum(0.0, Double.MAX_VALUE),
        fsComponentCount(0.0, 100000.0),
        fsComponentCreateTime(0.0, Double.MAX_VALUE),
        fsRenderTime(0.0, 5000.0),
        fsRequestNum(0.0, 100.0),
        callCreateFinishTime(0.0, 10000.0),
        cellExceedNum(0.0, Double.MAX_VALUE),
        communicateTotalTime(0.0, 5000.0),
        maxDeepViewLayer(0.0, Double.MAX_VALUE),
        maxDeepVDomLayer(0.0, Double.MAX_VALUE),
        componentCount(0.0, 1000000.0),
        componentCreateTime(0.0, Double.MAX_VALUE),
        avgFps(0.0, 61.0),
        timerCount(0.0, Double.MAX_VALUE),
        MaxImproveMemory(0.0, Double.MAX_VALUE),
        BackImproveMemory(0.0, Double.MAX_VALUE),
        PushImproveMemory(0.0, Double.MAX_VALUE),
        measureTime1(0.0, Double.MAX_VALUE),
        measureTime2(0.0, Double.MAX_VALUE),
        measureTime3(0.0, Double.MAX_VALUE),
        measureTime4(0.0, Double.MAX_VALUE),
        measureTime5(0.0, Double.MAX_VALUE),
        callBridgeTime(0.0, Double.MAX_VALUE),
        cssLayoutTime(0.0, Double.MAX_VALUE),
        parseJsonTime(0.0, Double.MAX_VALUE),
        communicateTime(0.0, 5000.0),
        screenRenderTime(0.0, 5000.0),
        totalTime(0.0, 5000.0),
        localReadTime(0.0, 5000.0),
        templateLoadTime(0.0, 5000.0),
        packageSpendTime(0.0, 5000.0),
        syncTaskTime(0.0, 5000.0),
        actualNetworkTime(0.0, 5000.0),
        firstScreenJSFExecuteTime(0.0, 5000.0),
        fluency(0.0, 101.0),
        imgSizeCount(0.0, 2000.0),
        interactionTime(0.0, 10000.0),
        interactionViewAddCount(0.0, Double.MAX_VALUE),
        interactionViewAddLimitCount(0.0, Double.MAX_VALUE),
        newFsRenderTime(0.0, 10000.0);

        private double mMinRange;
        private double mMaxRange;

        private Measure(double min, double max) {
            this.mMinRange = min;
            this.mMaxRange = max;
        }

        public double getMinRange() {
            return this.mMinRange;
        }

        public double getMaxRange() {
            return this.mMaxRange;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static enum Dimension {
        JSLibVersion,
        WXSDKVersion,
        pageName,
        spm,
        scheme,
        cacheType,
        requestType,
        networkType,
        connectionType,
        zcacheInfo,
        wxContainerName,
        wxInstanceType,
        wxParentPage,
        wxdim1,
        wxdim2,
        wxdim3,
        wxdim4,
        wxdim5,
        bizType,
        templateUrl,
        useScroller;

    }
}

