/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex;

import android.content.Context;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.taobao.weex.IWXStatisticsListener;
import com.taobao.weex.InitConfig;
import com.taobao.weex.Script;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.adapter.ClassLoaderAdapter;
import com.taobao.weex.adapter.DefaultUriAdapter;
import com.taobao.weex.adapter.DefaultWXHttpAdapter;
import com.taobao.weex.adapter.ICrashInfoReporter;
import com.taobao.weex.adapter.IDrawableLoader;
import com.taobao.weex.adapter.ITracingAdapter;
import com.taobao.weex.adapter.IWXAccessibilityRoleAdapter;
import com.taobao.weex.adapter.IWXConfigAdapter;
import com.taobao.weex.adapter.IWXHttpAdapter;
import com.taobao.weex.adapter.IWXImgLoaderAdapter;
import com.taobao.weex.adapter.IWXJSExceptionAdapter;
import com.taobao.weex.adapter.IWXJsFileLoaderAdapter;
import com.taobao.weex.adapter.IWXJscProcessManager;
import com.taobao.weex.adapter.IWXSoLoaderAdapter;
import com.taobao.weex.adapter.IWXUserTrackAdapter;
import com.taobao.weex.adapter.URIAdapter;
import com.taobao.weex.appfram.navigator.IActivityNavBarSetter;
import com.taobao.weex.appfram.navigator.INavigator;
import com.taobao.weex.appfram.storage.DefaultWXStorage;
import com.taobao.weex.appfram.storage.IWXStorageAdapter;
import com.taobao.weex.appfram.websocket.IWebSocketAdapter;
import com.taobao.weex.appfram.websocket.IWebSocketAdapterFactory;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.bridge.WXModuleManager;
import com.taobao.weex.bridge.WXValidateProcessor;
import com.taobao.weex.common.WXRefreshData;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.common.WXWorkThreadManager;
import com.taobao.weex.font.FontAdapter;
import com.taobao.weex.performance.IApmGenerator;
import com.taobao.weex.performance.IWXAnalyzer;
import com.taobao.weex.ui.WXRenderManager;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class WXSDKManager {
    private static volatile WXSDKManager sManager;
    private static AtomicInteger sInstanceId;
    private final WXWorkThreadManager mWXWorkThreadManager;
    private WXBridgeManager mBridgeManager;
    WXRenderManager mWXRenderManager;
    private IWXUserTrackAdapter mIWXUserTrackAdapter;
    private IWXImgLoaderAdapter mIWXImgLoaderAdapter;
    private IWXSoLoaderAdapter mIWXSoLoaderAdapter;
    private IDrawableLoader mDrawableLoader;
    private IWXHttpAdapter mIWXHttpAdapter;
    private IActivityNavBarSetter mActivityNavBarSetter;
    private IWXAccessibilityRoleAdapter mRoleAdapter;
    private List<IWXAnalyzer> mWXAnalyzerList;
    private IApmGenerator mApmGenerater;
    private IWXJsFileLoaderAdapter mWXJsFileLoaderAdapter;
    private ICrashInfoReporter mCrashInfo;
    private IWXJSExceptionAdapter mIWXJSExceptionAdapter;
    private IWXConfigAdapter mConfigAdapter;
    private IWXStorageAdapter mIWXStorageAdapter;
    private IWXStatisticsListener mStatisticsListener;
    private URIAdapter mURIAdapter;
    private ClassLoaderAdapter mClassLoaderAdapter;
    private IWebSocketAdapterFactory mIWebSocketAdapterFactory;
    private ITracingAdapter mTracingAdapter;
    private WXValidateProcessor mWXValidateProcessor;
    private IWXJscProcessManager mWXJscProcessManager;
    private boolean mNeedInitV8 = true;
    private Map<String, WXSDKInstance> mAllInstanceMap;
    private List<InstanceLifeCycleCallbacks> mLifeCycleCallbacks;
    private static final int DEFAULT_VIEWPORT_WIDTH = 750;
    private INavigator mNavigator;
    private FontAdapter mFontAdapter;

    private WXSDKManager() {
        this(new WXRenderManager());
    }

    private WXSDKManager(WXRenderManager renderManager) {
        this.mWXRenderManager = renderManager;
        this.mBridgeManager = WXBridgeManager.getInstance();
        this.mWXWorkThreadManager = new WXWorkThreadManager();
        this.mWXAnalyzerList = new CopyOnWriteArrayList<IWXAnalyzer>();
        this.mAllInstanceMap = new HashMap<String, WXSDKInstance>();
    }

    static void initInstance(WXRenderManager renderManager) {
        sManager = new WXSDKManager(renderManager);
    }

    public void registerStatisticsListener(IWXStatisticsListener listener) {
        this.mStatisticsListener = listener;
    }

    public IWXStatisticsListener getWXStatisticsListener() {
        return this.mStatisticsListener;
    }

    public void onSDKEngineInitialize() {
        if (this.mStatisticsListener != null) {
            this.mStatisticsListener.onSDKEngineInitialize();
        }
    }

    public void setNeedInitV8(boolean need) {
        this.mNeedInitV8 = need;
    }

    public boolean needInitV8() {
        return this.mNeedInitV8;
    }

    public void takeJSHeapSnapshot(String path) {
        File file = new File(path);
        if (!file.exists() && !file.mkdir()) {
            return;
        }
        String name = String.valueOf(sInstanceId.get());
        String filename = path;
        if (!path.endsWith(File.separator)) {
            filename = filename + File.separator;
        }
        filename = filename + name;
        filename = filename + ".heapsnapshot";
        this.mBridgeManager.takeJSHeapSnapshot(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WXSDKManager getInstance() {
        if (sManager != null) return sManager;
        Class<WXSDKManager> clazz = WXSDKManager.class;
        synchronized (WXSDKManager.class) {
            if (sManager != null) return sManager;
            sManager = new WXSDKManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sManager;
        }
    }

    public static int getInstanceViewPortWidth(String instanceId) {
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
        if (instance == null) {
            return 750;
        }
        return instance.getInstanceViewPortWidth();
    }

    static void setInstance(WXSDKManager manager) {
        sManager = manager;
    }

    public IActivityNavBarSetter getActivityNavBarSetter() {
        return this.mActivityNavBarSetter;
    }

    public void setActivityNavBarSetter(IActivityNavBarSetter mActivityNavBarSetter) {
        this.mActivityNavBarSetter = mActivityNavBarSetter;
    }

    public void restartBridge() {
        this.mBridgeManager.restart();
    }

    public WXBridgeManager getWXBridgeManager() {
        return this.mBridgeManager;
    }

    public WXRenderManager getWXRenderManager() {
        return this.mWXRenderManager;
    }

    public IWXJscProcessManager getWXJscProcessManager() {
        return this.mWXJscProcessManager;
    }

    public WXWorkThreadManager getWXWorkThreadManager() {
        return this.mWXWorkThreadManager;
    }

    public void setWxConfigAdapter(IWXConfigAdapter mConfigAdapter) {
        this.mConfigAdapter = mConfigAdapter;
    }

    public IWXConfigAdapter getWxConfigAdapter() {
        return this.mConfigAdapter;
    }

    @Nullable
    public WXSDKInstance getSDKInstance(String instanceId) {
        return instanceId == null ? null : this.mWXRenderManager.getWXSDKInstance(instanceId);
    }

    public void postOnUiThread(Runnable runnable, long delayMillis) {
        this.mWXRenderManager.postOnUiThread(WXThread.secure(runnable), delayMillis);
    }

    public Map<String, WXSDKInstance> getAllInstanceMap() {
        return this.mAllInstanceMap;
    }

    public void destroy() {
        if (this.mWXWorkThreadManager != null) {
            this.mWXWorkThreadManager.destroy();
        }
        this.mAllInstanceMap.clear();
    }

    @Deprecated
    public void callback(String instanceId, String funcId, Map<String, Object> data) {
        this.mBridgeManager.callback(instanceId, funcId, data);
    }

    @Deprecated
    public void callback(String instanceId, String funcId, Map<String, Object> data, boolean keepAlive) {
        this.mBridgeManager.callback(instanceId, funcId, data, keepAlive);
    }

    public void initScriptsFramework(String framework) {
        this.mBridgeManager.initScriptsFramework(framework);
    }

    public void registerComponents(List<Map<String, Object>> components) {
        this.mBridgeManager.registerComponents(components);
    }

    public void registerModules(Map<String, Object> modules) {
        this.mBridgeManager.registerModules(modules);
    }

    @Deprecated
    public void fireEvent(String instanceId, String ref, String type) {
        this.fireEvent(instanceId, ref, type, new HashMap<String, Object>());
    }

    @Deprecated
    public void fireEvent(String instanceId, String ref, String type, Map<String, Object> params) {
        this.fireEvent(instanceId, ref, type, params, null);
    }

    @Deprecated
    public void fireEvent(String instanceId, String ref, String type, Map<String, Object> params, Map<String, Object> domChanges) {
        if (WXEnvironment.isApkDebugable() && Looper.getMainLooper().getThread().getId() != Thread.currentThread().getId()) {
            throw new WXRuntimeException("[WXSDKManager]  fireEvent error");
        }
        this.mBridgeManager.fireEventOnNode(instanceId, ref, type, params, domChanges);
    }

    void createInstance(WXSDKInstance instance, Script code, Map<String, Object> options, String jsonInitData) {
        this.mWXRenderManager.registerInstance(instance);
        this.mBridgeManager.createInstance(instance.getInstanceId(), code, options, jsonInitData);
        if (this.mLifeCycleCallbacks != null) {
            for (InstanceLifeCycleCallbacks callbacks : this.mLifeCycleCallbacks) {
                callbacks.onInstanceCreated(instance.getInstanceId());
            }
        }
    }

    void refreshInstance(String instanceId, WXRefreshData jsonData) {
        this.mBridgeManager.refreshInstance(instanceId, jsonData);
    }

    void destroyInstance(String instanceId) {
        this.setCrashInfo("wx_current_url", "");
        if (TextUtils.isEmpty((CharSequence)instanceId)) {
            return;
        }
        if (!WXUtils.isUiThread()) {
            throw new WXRuntimeException("[WXSDKManager] destroyInstance error");
        }
        if (this.mLifeCycleCallbacks != null) {
            for (InstanceLifeCycleCallbacks callbacks : this.mLifeCycleCallbacks) {
                callbacks.onInstanceDestroyed(instanceId);
            }
        }
        this.mWXRenderManager.removeRenderStatement(instanceId);
        this.mBridgeManager.destroyInstance(instanceId);
        WXModuleManager.destroyInstanceModules(instanceId);
    }

    String generateInstanceId() {
        return String.valueOf(sInstanceId.incrementAndGet());
    }

    public IWXUserTrackAdapter getIWXUserTrackAdapter() {
        return this.mIWXUserTrackAdapter;
    }

    public IWXImgLoaderAdapter getIWXImgLoaderAdapter() {
        return this.mIWXImgLoaderAdapter;
    }

    public IWXJsFileLoaderAdapter getIWXJsFileLoaderAdapter() {
        return this.mWXJsFileLoaderAdapter;
    }

    public IDrawableLoader getDrawableLoader() {
        return this.mDrawableLoader;
    }

    public IWXJSExceptionAdapter getIWXJSExceptionAdapter() {
        return this.mIWXJSExceptionAdapter;
    }

    public void setIWXJSExceptionAdapter(IWXJSExceptionAdapter IWXJSExceptionAdapter2) {
        this.mIWXJSExceptionAdapter = IWXJSExceptionAdapter2;
    }

    @NonNull
    public IWXHttpAdapter getIWXHttpAdapter() {
        if (this.mIWXHttpAdapter == null) {
            this.mIWXHttpAdapter = new DefaultWXHttpAdapter();
        }
        return this.mIWXHttpAdapter;
    }

    public IApmGenerator getApmGenerater() {
        return this.mApmGenerater;
    }

    @NonNull
    public URIAdapter getURIAdapter() {
        if (this.mURIAdapter == null) {
            this.mURIAdapter = new DefaultUriAdapter();
        }
        return this.mURIAdapter;
    }

    public ClassLoaderAdapter getClassLoaderAdapter() {
        if (this.mClassLoaderAdapter == null) {
            this.mClassLoaderAdapter = new ClassLoaderAdapter();
        }
        return this.mClassLoaderAdapter;
    }

    public IWXSoLoaderAdapter getIWXSoLoaderAdapter() {
        return this.mIWXSoLoaderAdapter;
    }

    public List<IWXAnalyzer> getWXAnalyzerList() {
        return this.mWXAnalyzerList;
    }

    public void addWXAnalyzer(IWXAnalyzer analyzer) {
        if (!this.mWXAnalyzerList.contains(analyzer)) {
            this.mWXAnalyzerList.add(analyzer);
        }
    }

    public void rmWXAnalyzer(IWXAnalyzer analyzer) {
        this.mWXAnalyzerList.remove(analyzer);
    }

    void setInitConfig(InitConfig config) {
        this.mIWXHttpAdapter = config.getHttpAdapter();
        this.mIWXImgLoaderAdapter = config.getImgAdapter();
        this.mDrawableLoader = config.getDrawableLoader();
        this.mIWXStorageAdapter = config.getStorageAdapter();
        this.mIWXUserTrackAdapter = config.getUtAdapter();
        this.mURIAdapter = config.getURIAdapter();
        this.mIWebSocketAdapterFactory = config.getWebSocketAdapterFactory();
        this.mIWXJSExceptionAdapter = config.getJSExceptionAdapter();
        this.mIWXSoLoaderAdapter = config.getIWXSoLoaderAdapter();
        this.mClassLoaderAdapter = config.getClassLoaderAdapter();
        this.mApmGenerater = config.getApmGenerater();
        this.mWXJsFileLoaderAdapter = config.getJsFileLoaderAdapter();
        this.mWXJscProcessManager = config.getJscProcessManager();
    }

    public IWXStorageAdapter getIWXStorageAdapter() {
        if (this.mIWXStorageAdapter == null) {
            if (WXEnvironment.sApplication != null) {
                this.mIWXStorageAdapter = new DefaultWXStorage((Context)WXEnvironment.sApplication);
            } else {
                WXLogUtils.e("WXStorageModule", "No Application context found,you should call WXSDKEngine#initialize() method in your application");
            }
        }
        return this.mIWXStorageAdapter;
    }

    public void notifyTrimMemory() {
        this.mBridgeManager.notifyTrimMemory();
    }

    public void notifySerializeCodeCache() {
        this.mBridgeManager.notifySerializeCodeCache();
    }

    @Nullable
    public IWebSocketAdapter getIWXWebSocketAdapter() {
        if (this.mIWebSocketAdapterFactory != null) {
            return this.mIWebSocketAdapterFactory.createWebSocketAdapter();
        }
        return null;
    }

    public void registerValidateProcessor(WXValidateProcessor processor) {
        this.mWXValidateProcessor = processor;
    }

    public WXValidateProcessor getValidateProcessor() {
        return this.mWXValidateProcessor;
    }

    public void setCrashInfoReporter(ICrashInfoReporter mCrashInfo) {
        this.mCrashInfo = mCrashInfo;
    }

    public void setCrashInfo(String key, String value) {
        if (this.mCrashInfo != null) {
            this.mCrashInfo.addCrashInfo(key, value);
        }
    }

    public void setTracingAdapter(ITracingAdapter adapter) {
        this.mTracingAdapter = adapter;
    }

    public ITracingAdapter getTracingAdapter() {
        return this.mTracingAdapter;
    }

    public void registerInstanceLifeCycleCallbacks(InstanceLifeCycleCallbacks callbacks) {
        if (this.mLifeCycleCallbacks == null) {
            this.mLifeCycleCallbacks = new ArrayList<InstanceLifeCycleCallbacks>();
        }
        this.mLifeCycleCallbacks.add(callbacks);
    }

    public void setAccessibilityRoleAdapter(IWXAccessibilityRoleAdapter adapter) {
        this.mRoleAdapter = adapter;
    }

    public IWXAccessibilityRoleAdapter getAccessibilityRoleAdapter() {
        return this.mRoleAdapter;
    }

    public INavigator getNavigator() {
        return this.mNavigator;
    }

    public void setNavigator(INavigator mNavigator) {
        this.mNavigator = mNavigator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FontAdapter getFontAdapter() {
        if (this.mFontAdapter == null) {
            WXSDKManager wXSDKManager = this;
            synchronized (wXSDKManager) {
                if (this.mFontAdapter == null) {
                    this.mFontAdapter = new FontAdapter();
                }
            }
        }
        return this.mFontAdapter;
    }

    static {
        sInstanceId = new AtomicInteger(0);
    }

    public static interface InstanceLifeCycleCallbacks {
        public void onInstanceDestroyed(String var1);

        public void onInstanceCreated(String var1);
    }
}

