/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex;

import android.net.Uri;
import android.text.TextUtils;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.adapter.IWXHttpAdapter;
import com.taobao.weex.adapter.IWXUserTrackAdapter;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.common.WXPerformance;
import com.taobao.weex.common.WXRenderStrategy;
import com.taobao.weex.common.WXResponse;
import com.taobao.weex.performance.WXInstanceApm;
import com.taobao.weex.tracing.WXTracing;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.tools.LogDetail;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WXHttpListener
implements IWXHttpAdapter.OnHttpListener {
    private String pageName;
    private Map<String, Object> options;
    private String jsonInitData;
    private WXRenderStrategy flag;
    private WXSDKInstance instance;
    private long startRequestTime;
    private int traceId;
    private WXPerformance mWXPerformance;
    private WXInstanceApm mApmForInstance;
    private IWXUserTrackAdapter mUserTrackAdapter;
    public boolean isPreDownLoadMode = false;
    private boolean isInstanceReady = false;
    private boolean isResponseHasWait = false;
    private WXResponse mResponse;
    private LogDetail mLogDetail;
    private String mBundleUrl;

    public WXHttpListener(WXSDKInstance instance) {
        if (instance != null) {
            this.mLogDetail = instance.mTimeCalculator.createLogDetail("downloadBundleJS");
        }
        this.instance = instance;
        this.traceId = WXTracing.nextId();
        this.mWXPerformance = instance.getWXPerformance();
        this.mApmForInstance = instance.getApmForInstance();
        this.mUserTrackAdapter = WXSDKManager.getInstance().getIWXUserTrackAdapter();
        if (WXTracing.isAvailable()) {
            WXTracing.TraceEvent event = WXTracing.newEvent("downloadBundleJS", instance.getInstanceId(), -1);
            event.iid = instance.getInstanceId();
            event.tname = "Network";
            event.ph = "B";
            event.traceId = this.traceId;
            event.submit();
        }
    }

    public WXHttpListener(WXSDKInstance instance, String bundleUrl) {
        this(instance);
        this.startRequestTime = System.currentTimeMillis();
        this.mBundleUrl = bundleUrl;
    }

    public WXHttpListener(WXSDKInstance instance, String pageName, Map<String, Object> options, String jsonInitData, WXRenderStrategy flag, long startRequestTime) {
        this(instance);
        this.pageName = pageName;
        this.options = options;
        this.jsonInitData = jsonInitData;
        this.flag = flag;
        this.startRequestTime = startRequestTime;
        this.mBundleUrl = instance.getBundleUrl();
    }

    public void setSDKInstance(WXSDKInstance instance) {
        this.instance = instance;
    }

    protected WXSDKInstance getInstance() {
        return this.instance;
    }

    @Override
    public void onHttpStart() {
        if (this.instance != null && this.instance.getWXStatisticsListener() != null) {
            this.instance.getWXStatisticsListener().onHttpStart();
            if (this.mLogDetail != null) {
                this.mLogDetail.taskStart();
            }
        }
    }

    @Override
    public void onHeadersReceived(int statusCode, Map<String, List<String>> headers) {
        if (this.instance != null && this.instance.getWXStatisticsListener() != null) {
            this.instance.getWXStatisticsListener().onHeadersReceived();
            this.instance.onHttpStart();
        }
        if (this.instance != null && this.instance.responseHeaders != null && headers != null) {
            this.instance.responseHeaders.putAll(headers);
        }
    }

    @Override
    public void onHttpUploadProgress(int uploadProgress) {
    }

    @Override
    public void onHttpResponseProgress(int loadedLength) {
        this.instance.getApmForInstance().extInfo.put("wxLoadedLength", loadedLength);
    }

    @Override
    public void onHttpFinish(WXResponse response) {
        if (this.mLogDetail != null) {
            this.mLogDetail.taskEnd();
        }
        if (this.instance != null && this.instance.getWXStatisticsListener() != null) {
            this.instance.getWXStatisticsListener().onHttpFinish();
        }
        if (WXTracing.isAvailable()) {
            WXTracing.TraceEvent event = WXTracing.newEvent("downloadBundleJS", this.instance.getInstanceId(), -1);
            event.traceId = this.traceId;
            event.tname = "Network";
            event.ph = "E";
            event.extParams = new HashMap<String, Object>();
            if (response != null && response.originalData != null) {
                event.extParams.put("BundleSize", response.originalData.length);
            }
            event.submit();
        }
        this.mWXPerformance.networkTime = System.currentTimeMillis() - this.startRequestTime;
        if (null != response && response.extendParams != null) {
            Object zCacheInfo;
            this.mApmForInstance.updateRecordInfo(response.extendParams);
            Object actualNetworkTime = response.extendParams.get("actualNetworkTime");
            this.mWXPerformance.actualNetworkTime = actualNetworkTime instanceof Long ? (Long)actualNetworkTime : 0L;
            Object pureNetworkTime = response.extendParams.get("pureNetworkTime");
            this.mWXPerformance.pureNetworkTime = pureNetworkTime instanceof Long ? (Long)pureNetworkTime : 0L;
            Object connectionType = response.extendParams.get("connectionType");
            this.mWXPerformance.connectionType = connectionType instanceof String ? (String)connectionType : "";
            Object packageSpendTime = response.extendParams.get("packageSpendTime");
            this.mWXPerformance.packageSpendTime = packageSpendTime instanceof Long ? (Long)packageSpendTime : 0L;
            Object syncTaskTime = response.extendParams.get("syncTaskTime");
            this.mWXPerformance.syncTaskTime = syncTaskTime instanceof Long ? (Long)syncTaskTime : 0L;
            Object requestType = response.extendParams.get("requestType");
            this.mWXPerformance.requestType = requestType instanceof String ? (String)requestType : "none";
            Object cacheType = response.extendParams.get(WXPerformance.Dimension.cacheType.toString());
            if (cacheType instanceof String) {
                this.mWXPerformance.cacheType = (String)cacheType;
            }
            String string = this.mWXPerformance.zCacheInfo = (zCacheInfo = response.extendParams.get("zCacheInfo")) instanceof String ? (String)zCacheInfo : "";
            if (this.isNet(this.mWXPerformance.requestType) && this.mUserTrackAdapter != null) {
                WXPerformance performance = new WXPerformance(this.instance.getInstanceId());
                if (!TextUtils.isEmpty((CharSequence)this.mBundleUrl)) {
                    try {
                        performance.args = Uri.parse((String)this.mBundleUrl).buildUpon().clearQuery().toString();
                    }
                    catch (Exception e) {
                        performance.args = this.pageName;
                    }
                }
                if (!"200".equals(response.statusCode)) {
                    performance.errCode = WXErrorCode.WX_ERR_JSBUNDLE_DOWNLOAD.getErrorCode();
                    performance.appendErrMsg(response.errorCode);
                    performance.appendErrMsg("|");
                    performance.appendErrMsg(response.errorMsg);
                } else if ("200".equals(response.statusCode) && (response.originalData == null || response.originalData.length <= 0)) {
                    performance.errCode = WXErrorCode.WX_ERR_JSBUNDLE_DOWNLOAD.getErrorCode();
                    performance.appendErrMsg(response.statusCode);
                    performance.appendErrMsg("|template is null!");
                } else {
                    performance.errCode = WXErrorCode.WX_SUCCESS.getErrorCode();
                }
                if (this.mUserTrackAdapter != null) {
                    this.mUserTrackAdapter.commit(this.instance.getContext(), null, "jsDownload", performance, null);
                }
            }
        }
        if (this.isPreDownLoadMode) {
            if (this.isInstanceReady) {
                WXLogUtils.d("test->", "DownLoad didHttpFinish on http");
                this.didHttpFinish(response);
            } else {
                WXLogUtils.d("test->", "DownLoad end before activity created");
                this.mResponse = response;
                this.isResponseHasWait = true;
            }
        } else {
            this.didHttpFinish(response);
        }
    }

    public void onInstanceReady() {
        if (!this.isPreDownLoadMode) {
            return;
        }
        this.isInstanceReady = true;
        if (this.isResponseHasWait) {
            WXLogUtils.d("test->", "preDownLoad didHttpFinish on ready");
            this.didHttpFinish(this.mResponse);
        }
    }

    private void didHttpFinish(WXResponse response) {
        String wxErrorCode = "0";
        if (response != null && response.originalData != null && TextUtils.equals((CharSequence)"200", (CharSequence)response.statusCode)) {
            this.mApmForInstance.onStage("wxEndDownLoadBundle");
            this.onSuccess(response);
        } else if (TextUtils.equals((CharSequence)WXErrorCode.WX_DEGRAD_ERR_BUNDLE_CONTENTTYPE_ERROR.getErrorCode(), (CharSequence)response.statusCode)) {
            WXLogUtils.e("user intercept: WX_DEGRAD_ERR_BUNDLE_CONTENTTYPE_ERROR");
            wxErrorCode = WXErrorCode.WX_DEGRAD_ERR_BUNDLE_CONTENTTYPE_ERROR.getErrorCode();
            this.instance.onRenderError(wxErrorCode, "|response.errorMsg==" + response.errorMsg + "|instance bundleUrl = \n" + this.instance.getBundleUrl() + "|instance requestUrl = \n" + Uri.decode((String)WXSDKInstance.requestUrl));
            this.onFail(response);
        } else if (response != null && response.originalData != null && TextUtils.equals((CharSequence)"-206", (CharSequence)response.statusCode)) {
            WXLogUtils.e("user intercept: WX_DEGRAD_ERR_NETWORK_CHECK_CONTENT_LENGTH_FAILED");
            wxErrorCode = WXErrorCode.WX_DEGRAD_ERR_NETWORK_CHECK_CONTENT_LENGTH_FAILED.getErrorCode();
            this.instance.onRenderError(wxErrorCode, WXErrorCode.WX_DEGRAD_ERR_NETWORK_CHECK_CONTENT_LENGTH_FAILED.getErrorCode() + "|response.errorMsg==" + response.errorMsg);
            this.onFail(response);
        } else {
            wxErrorCode = WXErrorCode.WX_DEGRAD_ERR_NETWORK_BUNDLE_DOWNLOAD_FAILED.getErrorCode();
            this.instance.onRenderError(wxErrorCode, response.errorMsg);
            this.onFail(response);
        }
        if (!"0".equals(wxErrorCode)) {
            this.mApmForInstance.addProperty("wxErrorCode", wxErrorCode);
        }
    }

    private boolean isNet(String requestType) {
        return "network".equals(requestType) || "2g".equals(requestType) || "3g".equals(requestType) || "4g".equals(requestType) || "wifi".equals(requestType) || "other".equals(requestType) || "unknown".equals(requestType);
    }

    public void onSuccess(WXResponse response) {
        if (this.flag == WXRenderStrategy.DATA_RENDER_BINARY) {
            this.instance.render(this.pageName, response.originalData, this.options, this.jsonInitData);
        } else {
            String template = new String(response.originalData);
            this.instance.render(this.pageName, template, this.options, this.jsonInitData, this.flag);
        }
    }

    public void onFail(WXResponse response) {
    }
}

