/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.provider.MediaStore;
import android.support.annotation.ColorInt;
import android.view.View;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.weex.WXSDKManager;

public class WXViewToImageUtil {
    public static int mBackgroundColor = 0;

    public static void generateImage(final View imageView, final int width, @ColorInt int backgroundColor, final OnImageSavedCallback mOnImageSavedCallback) {
        mBackgroundColor = backgroundColor;
        WXSDKManager.getInstance().getWXWorkThreadManager().post(new Thread(new Runnable(){

            @Override
            public void run() {
                Bitmap bitmap = WXViewToImageUtil.getBitmapFromImageView(imageView, width);
                if (bitmap == null) {
                    if (mOnImageSavedCallback != null) {
                        mOnImageSavedCallback.onSaveFailed("Image is empty");
                    }
                    return;
                }
                final String destPath = WXViewToImageUtil.saveBitmapToGallery(imageView.getContext(), bitmap, mOnImageSavedCallback);
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        if (mOnImageSavedCallback != null) {
                            mOnImageSavedCallback.onSaveSucceed(destPath);
                            imageView.getContext().sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", Uri.parse((String)destPath)));
                        }
                    }
                });
            }
        }));
    }

    public static String saveBitmapToGallery(Context context, Bitmap bitmap, OnImageSavedCallback mOnImageSavedCallback) {
        File appDir = new File(Environment.getExternalStorageDirectory(), "Weex");
        if (!appDir.exists()) {
            appDir.mkdir();
        }
        String fileName = System.currentTimeMillis() + ".jpg";
        File file = new File(appDir, fileName);
        try {
            FileOutputStream fos = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fos);
            fos.flush();
            fos.close();
        }
        catch (FileNotFoundException e) {
            if (mOnImageSavedCallback != null) {
                mOnImageSavedCallback.onSaveFailed("Image creation failed due to system reason");
            }
            e.printStackTrace();
        }
        catch (IOException e) {
            if (mOnImageSavedCallback != null) {
                mOnImageSavedCallback.onSaveFailed("Android IOException");
            }
            e.printStackTrace();
        }
        try {
            MediaStore.Images.Media.insertImage((ContentResolver)context.getContentResolver(), (String)file.getAbsolutePath(), (String)fileName, null);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        context.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", Uri.parse((String)("file://" + appDir.getAbsolutePath() + "/" + fileName))));
        return file.getAbsolutePath();
    }

    public static Bitmap getBitmapFromImageView(View view, int width) {
        if (view.getWidth() <= 0 || view.getHeight() <= 0) {
            view.measure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
            view.layout(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight());
        }
        view.setDrawingCacheEnabled(true);
        Bitmap bitmap = view.getDrawingCache();
        return bitmap;
    }

    public static interface OnImageSavedCallback {
        public void onSaveSucceed(String var1);

        public void onSaveFailed(String var1);
    }
}

