/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.utils;

import android.text.TextUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import org.apache.weex.utils.WXUtils;

public class WXReflectionUtils {
    public static Object parseArgument(Type paramClazz, Object value) {
        if (value != null) {
            if (value.getClass() == paramClazz) {
                return value;
            }
            if (paramClazz instanceof Class && ((Class)paramClazz).isAssignableFrom(value.getClass())) {
                return value;
            }
        }
        if (paramClazz == String.class) {
            return value instanceof String ? value : JSON.toJSONString((Object)value);
        }
        if (paramClazz == Integer.TYPE) {
            return value.getClass().isAssignableFrom(Integer.TYPE) ? value : Integer.valueOf(WXUtils.getInt(value));
        }
        if (paramClazz == Long.TYPE) {
            return value.getClass().isAssignableFrom(Long.TYPE) ? value : Long.valueOf(WXUtils.getLong(value));
        }
        if (paramClazz == Double.TYPE) {
            return value.getClass().isAssignableFrom(Double.TYPE) ? value : Double.valueOf(WXUtils.getDouble(value));
        }
        if (paramClazz == Float.TYPE) {
            return value.getClass().isAssignableFrom(Float.TYPE) ? value : Float.valueOf(WXUtils.getFloat(value));
        }
        if (paramClazz == JSONArray.class && value != null && value.getClass() == JSONArray.class) {
            return value;
        }
        if (paramClazz == JSONObject.class && value != null && value.getClass() == JSONObject.class) {
            return value;
        }
        return JSON.parseObject((String)(value instanceof String ? (String)value : JSON.toJSONString((Object)value)), (Type)paramClazz, (Feature[])new Feature[0]);
    }

    public static void setValue(Object obj, String fieldName, Object value) {
        if (obj == null || TextUtils.isEmpty((CharSequence)fieldName)) {
            return;
        }
        try {
            Field field = WXReflectionUtils.getDeclaredField(obj, fieldName);
            Object realValue = value;
            if (value instanceof BigDecimal || value instanceof Number || value instanceof String) {
                if (field.getType() == Float.class || field.getType() == Float.TYPE) {
                    realValue = Float.valueOf(Float.parseFloat(value.toString()));
                } else if (field.getType() == Double.class || field.getType() == Double.TYPE) {
                    realValue = Double.parseDouble(value.toString());
                } else if (field.getType() == Integer.class || field.getType() == Integer.TYPE) {
                    realValue = (int)Double.parseDouble(value.toString());
                } else if (field.getType() == Boolean.class || field.getType() == Boolean.TYPE) {
                    realValue = Boolean.valueOf(value.toString());
                }
            }
            if ((field.getType() == Boolean.TYPE || field.getType() == Boolean.class) && value != null) {
                realValue = Boolean.valueOf(value.toString());
            }
            WXReflectionUtils.setProperty(obj, field, realValue);
        }
        catch (Exception e) {
            return;
        }
    }

    public static Field getDeclaredField(Object object, String fieldName) {
        Field field = null;
        for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                field = clazz.getDeclaredField(fieldName);
                return field;
            }
            catch (Exception exception) {
                continue;
            }
        }
        return null;
    }

    public static void setProperty(Object bean, Field field, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null || field == null) {
            return;
        }
        try {
            field.setAccessible(true);
            field.set(bean, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

