/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.ui.view.border;

import android.graphics.RectF;
import android.support.annotation.NonNull;
import org.apache.weex.ui.view.border.BorderCorner;

class TopRightCorner
extends BorderCorner {
    TopRightCorner() {
    }

    void set(float cornerRadius, float preBorderWidth, float postBorderWidth, @NonNull RectF borderBox) {
        this.set(cornerRadius, preBorderWidth, postBorderWidth, borderBox, 315.0f);
    }

    @Override
    protected void prepareOval() {
        if (this.hasInnerCorner()) {
            this.setOvalLeft(this.getBorderBox().width() - (2.0f * this.getOuterCornerRadius() - this.getPostBorderWidth() / 2.0f));
            this.setOvalTop(this.getPreBorderWidth() / 2.0f);
            this.setOvalRight(this.getBorderBox().width() - this.getPostBorderWidth() / 2.0f);
            this.setOvalBottom(2.0f * this.getOuterCornerRadius() - this.getPreBorderWidth() / 2.0f);
        } else {
            this.setOvalLeft(this.getBorderBox().width() - 1.5f * this.getOuterCornerRadius());
            this.setOvalTop(this.getOuterCornerRadius() / 2.0f);
            this.setOvalRight(this.getBorderBox().width() - this.getOuterCornerRadius() / 2.0f);
            this.setOvalBottom(this.getOuterCornerRadius() * 1.5f);
        }
    }

    @Override
    protected void prepareRoundCorner() {
        if (this.hasOuterCorner()) {
            this.setRoundCornerStartX(this.getBorderBox().width() - this.getOuterCornerRadius());
            this.setRoundCornerStartY(this.getPreBorderWidth() / 2.0f);
            this.setRoundCornerEndX(this.getBorderBox().width() - this.getPostBorderWidth() / 2.0f);
            this.setRoundCornerEndY(this.getOuterCornerRadius());
        } else {
            float x = this.getBorderBox().width() - this.getPostBorderWidth() / 2.0f;
            float y = this.getPreBorderWidth() / 2.0f;
            this.setRoundCornerStartX(x);
            this.setRoundCornerStartY(y);
            this.setRoundCornerEndX(x);
            this.setRoundCornerEndY(y);
        }
    }
}

