/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.ui.view.border;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.Build;
import android.support.annotation.NonNull;
import org.apache.weex.base.FloatUtil;

abstract class BorderCorner {
    static final float SWEEP_ANGLE = 45.0f;
    private float mCornerRadius = 0.0f;
    private float mPreBorderWidth = 0.0f;
    private float mPostBorderWidth = 0.0f;
    private RectF mBorderBox;
    protected float mAngleBisector;
    private boolean hasInnerCorner = false;
    private boolean hasOuterCorner = false;
    private float mOvalLeft;
    private float mOvalTop;
    private float mOvalRight;
    private float mOvalBottom;
    private float mRoundCornerStartX;
    private float mRoundCornerStartY;
    private float mRoundCornerEndX;
    private float mRoundCornerEndY;

    BorderCorner() {
    }

    final void set(float cornerRadius, float preBorderWidth, float postBorderWidth, @NonNull RectF borderBox, float angleBisector) {
        boolean dirty;
        boolean bl = dirty = !FloatUtil.floatsEqual(this.mCornerRadius, cornerRadius) || !FloatUtil.floatsEqual(this.mPreBorderWidth, preBorderWidth) || !FloatUtil.floatsEqual(this.mPostBorderWidth, postBorderWidth) || !FloatUtil.floatsEqual(this.mAngleBisector, angleBisector) || null != this.mBorderBox && this.mBorderBox.equals((Object)borderBox);
        if (dirty) {
            this.mCornerRadius = cornerRadius;
            this.mPreBorderWidth = preBorderWidth;
            this.mPostBorderWidth = postBorderWidth;
            this.mBorderBox = borderBox;
            this.mAngleBisector = angleBisector;
            this.hasOuterCorner = this.mCornerRadius > 0.0f && !FloatUtil.floatsEqual(0.0f, this.mCornerRadius);
            boolean bl2 = this.hasInnerCorner = this.hasOuterCorner && this.getPreBorderWidth() >= 0.0f && this.getPostBorderWidth() >= 0.0f && this.getOuterCornerRadius() > this.getPreBorderWidth() && this.getOuterCornerRadius() > this.getPostBorderWidth();
            if (this.hasOuterCorner) {
                this.prepareOval();
            }
            this.prepareRoundCorner();
        }
    }

    protected abstract void prepareOval();

    protected abstract void prepareRoundCorner();

    public final void drawRoundedCorner(@NonNull Canvas canvas, @NonNull Paint paint, float startAngle) {
        if (this.hasOuterCorner()) {
            if (Build.VERSION.SDK_INT >= 21) {
                canvas.drawArc(this.mOvalLeft, this.mOvalTop, this.mOvalRight, this.mOvalBottom, startAngle, 45.0f, false, paint);
            } else {
                canvas.drawArc(new RectF(this.mOvalLeft, this.mOvalTop, this.mOvalRight, this.mOvalBottom), startAngle, 45.0f, false, paint);
            }
        } else {
            canvas.drawLine(this.getRoundCornerStartX(), this.getRoundCornerStartY(), this.getRoundCornerEndX(), this.getRoundCornerEndY(), paint);
        }
    }

    public final float getRoundCornerStartX() {
        return this.mRoundCornerStartX;
    }

    final void setRoundCornerStartX(float roundCornerStartX) {
        this.mRoundCornerStartX = roundCornerStartX;
    }

    public final float getRoundCornerStartY() {
        return this.mRoundCornerStartY;
    }

    final void setRoundCornerStartY(float roundCornerStartY) {
        this.mRoundCornerStartY = roundCornerStartY;
    }

    public final float getRoundCornerEndX() {
        return this.mRoundCornerEndX;
    }

    final void setRoundCornerEndX(float mRoundCornerEndX) {
        this.mRoundCornerEndX = mRoundCornerEndX;
    }

    public final float getRoundCornerEndY() {
        return this.mRoundCornerEndY;
    }

    final void setRoundCornerEndY(float mRoundCornerEndY) {
        this.mRoundCornerEndY = mRoundCornerEndY;
    }

    final void setOvalLeft(float mOvalLeft) {
        this.mOvalLeft = mOvalLeft;
    }

    final void setOvalTop(float mOvalTop) {
        this.mOvalTop = mOvalTop;
    }

    final void setOvalRight(float mOvalRight) {
        this.mOvalRight = mOvalRight;
    }

    final void setOvalBottom(float mOvalBottom) {
        this.mOvalBottom = mOvalBottom;
    }

    boolean hasInnerCorner() {
        return this.hasInnerCorner;
    }

    boolean hasOuterCorner() {
        return this.hasOuterCorner;
    }

    protected final float getPreBorderWidth() {
        return this.mPreBorderWidth;
    }

    protected final float getPostBorderWidth() {
        return this.mPostBorderWidth;
    }

    protected final float getOuterCornerRadius() {
        return this.mCornerRadius;
    }

    protected final float getAngleBisectorDegree() {
        return this.mAngleBisector;
    }

    protected final RectF getBorderBox() {
        return this.mBorderBox;
    }
}

