/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.ui.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.JavascriptInterface;
import android.webkit.JsPromptResult;
import android.webkit.SslErrorHandler;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.apache.weex.ui.view.IWebView;
import org.apache.weex.utils.WXLogUtils;

public class WXWebView
implements IWebView {
    private Context mContext;
    private String mOrigin;
    private WebView mWebView;
    private ProgressBar mProgressBar;
    private boolean mShowLoading = true;
    private Handler mMessageHandler;
    private static final int POST_MESSAGE = 1;
    private static final String BRIDGE_NAME = "__WEEX_WEB_VIEW_BRIDGE";
    private static final int SDK_VERSION = Build.VERSION.SDK_INT;
    private static final boolean DOWNGRADE_JS_INTERFACE = SDK_VERSION < 17;
    private IWebView.OnErrorListener mOnErrorListener;
    private IWebView.OnPageListener mOnPageListener;
    private IWebView.OnMessageListener mOnMessageListener;

    public WXWebView(Context context, String origin) {
        this.mContext = context;
        this.mOrigin = origin;
    }

    @Override
    public View getView() {
        FrameLayout root = new FrameLayout(this.mContext);
        root.setBackgroundColor(-1);
        this.mWebView = new WebView(this.mContext);
        FrameLayout.LayoutParams wvLayoutParams = new FrameLayout.LayoutParams(-1, -1);
        wvLayoutParams.gravity = 17;
        this.mWebView.setLayoutParams((ViewGroup.LayoutParams)wvLayoutParams);
        root.addView((View)this.mWebView);
        this.initWebView(this.mWebView);
        this.mProgressBar = new ProgressBar(this.mContext);
        this.showProgressBar(false);
        FrameLayout.LayoutParams pLayoutParams = new FrameLayout.LayoutParams(-2, -2);
        this.mProgressBar.setLayoutParams((ViewGroup.LayoutParams)pLayoutParams);
        pLayoutParams.gravity = 17;
        root.addView((View)this.mProgressBar);
        this.mMessageHandler = new MessageHandler(this);
        return root;
    }

    @Override
    public void destroy() {
        if (this.getWebView() != null) {
            this.getWebView().removeAllViews();
            this.getWebView().destroy();
            this.mWebView = null;
        }
    }

    @Override
    public void loadUrl(String url) {
        if (this.getWebView() == null) {
            return;
        }
        this.getWebView().loadUrl(url);
    }

    @Override
    public void loadDataWithBaseURL(String source) {
        if (this.getWebView() == null) {
            return;
        }
        this.getWebView().loadDataWithBaseURL(this.mOrigin, source, "text/html", "utf-8", null);
    }

    @Override
    public void reload() {
        if (this.getWebView() == null) {
            return;
        }
        this.getWebView().reload();
    }

    @Override
    public void goBack() {
        if (this.getWebView() == null) {
            return;
        }
        this.getWebView().goBack();
    }

    @Override
    public void goForward() {
        if (this.getWebView() == null) {
            return;
        }
        this.getWebView().goForward();
    }

    @Override
    public void postMessage(Object msg) {
        if (this.getWebView() == null) {
            return;
        }
        try {
            JSONObject initData = new JSONObject();
            initData.put("type", (Object)"message");
            initData.put("data", msg);
            initData.put("origin", (Object)this.mOrigin);
            this.evaluateJS("javascript:(function () {var initData = " + initData.toString() + ";try {var event = new MessageEvent('message', initData);window.dispatchEvent(event);} catch (e) {}})();");
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setShowLoading(boolean shown) {
        this.mShowLoading = shown;
    }

    @Override
    public void setOnErrorListener(IWebView.OnErrorListener listener) {
        this.mOnErrorListener = listener;
    }

    @Override
    public void setOnPageListener(IWebView.OnPageListener listener) {
        this.mOnPageListener = listener;
    }

    @Override
    public void setOnMessageListener(IWebView.OnMessageListener listener) {
        this.mOnMessageListener = listener;
    }

    private void showProgressBar(boolean shown) {
        if (this.mShowLoading) {
            this.mProgressBar.setVisibility(shown ? 0 : 8);
        }
    }

    private void showWebView(boolean shown) {
        this.mWebView.setVisibility(shown ? 0 : 4);
    }

    @Nullable
    private WebView getWebView() {
        return this.mWebView;
    }

    @SuppressLint(value={"SetJavaScriptEnabled", "AddJavascriptInterface"})
    private void initWebView(WebView wv) {
        WebSettings settings = wv.getSettings();
        settings.setJavaScriptEnabled(true);
        settings.setAppCacheEnabled(true);
        settings.setUseWideViewPort(true);
        settings.setDomStorageEnabled(true);
        settings.setSupportZoom(false);
        settings.setBuiltInZoomControls(false);
        settings.setAllowFileAccess(false);
        wv.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                view.loadUrl(url);
                WXLogUtils.v("tag", "onPageOverride " + url);
                return true;
            }

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
                WXLogUtils.v("tag", "onPageStarted " + url);
                if (WXWebView.this.mOnPageListener != null) {
                    WXWebView.this.mOnPageListener.onPageStart(url);
                }
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                WXLogUtils.v("tag", "onPageFinished " + url);
                if (WXWebView.this.mOnPageListener != null) {
                    WXWebView.this.mOnPageListener.onPageFinish(url, view.canGoBack(), view.canGoForward());
                }
                if (WXWebView.this.mOnMessageListener != null) {
                    WXWebView.this.evaluateJS("javascript:(window.postMessage = function(message, targetOrigin) {if (message == null || !targetOrigin) return;" + (DOWNGRADE_JS_INTERFACE ? "prompt('__WEEX_WEB_VIEW_BRIDGE://postMessage?message=' + JSON.stringify(message) + '&targetOrigin=' + targetOrigin)" : "__WEEX_WEB_VIEW_BRIDGE.postMessage(JSON.stringify(message), targetOrigin);") + "})");
                }
            }

            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                super.onReceivedError(view, request, error);
                if (WXWebView.this.mOnErrorListener != null) {
                    WXWebView.this.mOnErrorListener.onError("error", "page error");
                }
            }

            public void onReceivedHttpError(WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
                super.onReceivedHttpError(view, request, errorResponse);
                if (WXWebView.this.mOnErrorListener != null) {
                    WXWebView.this.mOnErrorListener.onError("error", "http error");
                }
            }

            public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
                super.onReceivedSslError(view, handler, error);
                if (WXWebView.this.mOnErrorListener != null) {
                    WXWebView.this.mOnErrorListener.onError("error", "ssl error");
                }
            }
        });
        wv.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int newProgress) {
                super.onProgressChanged(view, newProgress);
                WXWebView.this.showWebView(newProgress == 100);
                WXWebView.this.showProgressBar(newProgress != 100);
                WXLogUtils.v("tag", "onPageProgressChanged " + newProgress);
            }

            public void onReceivedTitle(WebView view, String title) {
                super.onReceivedTitle(view, title);
                if (WXWebView.this.mOnPageListener != null) {
                    WXWebView.this.mOnPageListener.onReceivedTitle(view.getTitle());
                }
            }

            public boolean onJsPrompt(WebView view, String url, String text, String defaultValue, JsPromptResult result) {
                Uri uri = Uri.parse((String)text);
                String scheme = uri.getScheme();
                if (TextUtils.equals((CharSequence)scheme, (CharSequence)WXWebView.BRIDGE_NAME)) {
                    if (TextUtils.equals((CharSequence)uri.getAuthority(), (CharSequence)"postMessage")) {
                        String message = uri.getQueryParameter("message");
                        String targetOrigin = uri.getQueryParameter("targetOrigin");
                        WXWebView.this.onMessage(message, targetOrigin);
                        result.confirm("success");
                    } else {
                        result.confirm("fail");
                    }
                    return true;
                }
                return super.onJsPrompt(view, url, text, defaultValue, result);
            }
        });
        if (!DOWNGRADE_JS_INTERFACE) {
            wv.addJavascriptInterface(new Object(){

                @JavascriptInterface
                public void postMessage(String message, String targetOrigin) {
                    WXWebView.this.onMessage(message, targetOrigin);
                }
            }, BRIDGE_NAME);
        }
    }

    private void onMessage(String message, String targetOrigin) {
        if (message != null && targetOrigin != null && this.mOnMessageListener != null) {
            try {
                HashMap<String, Object> initData = new HashMap<String, Object>();
                initData.put("data", JSON.parse((String)message));
                initData.put("origin", targetOrigin);
                initData.put("type", "message");
                Message threadMessage = new Message();
                threadMessage.what = 1;
                threadMessage.obj = initData;
                this.mMessageHandler.sendMessage(threadMessage);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void evaluateJS(String jsStr) {
        if (SDK_VERSION < 19) {
            this.mWebView.loadUrl(jsStr);
        } else {
            this.mWebView.evaluateJavascript(jsStr, null);
        }
    }

    private static class MessageHandler
    extends Handler {
        private final WeakReference<WXWebView> mWv;

        private MessageHandler(WXWebView wv) {
            this.mWv = new WeakReference<WXWebView>(wv);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 1: {
                    if (this.mWv.get() == null || ((WXWebView)this.mWv.get()).mOnMessageListener == null) break;
                    ((WXWebView)this.mWv.get()).mOnMessageListener.onMessage((Map)msg.obj);
                    break;
                }
            }
        }
    }
}

