/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.ui.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Rect;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.MediaController;
import android.widget.ProgressBar;
import android.widget.VideoView;
import org.apache.weex.ui.view.gesture.WXGesture;
import org.apache.weex.ui.view.gesture.WXGestureObservable;
import org.apache.weex.utils.WXResourceUtils;

public class WXVideoView
extends VideoView
implements WXGestureObservable {
    private WXGesture wxGesture;
    private VideoPlayListener mVideoPauseListener;

    public WXVideoView(Context context) {
        super(context);
    }

    @Override
    public void registerGestureListener(WXGesture wxGesture) {
        this.wxGesture = wxGesture;
    }

    @Override
    public WXGesture getGestureListener() {
        return this.wxGesture;
    }

    public void setOnVideoPauseListener(VideoPlayListener listener) {
        this.mVideoPauseListener = listener;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        boolean result = super.onTouchEvent(event);
        if (this.wxGesture != null) {
            result |= this.wxGesture.onTouch((View)this, event);
        }
        return result;
    }

    public void start() {
        super.start();
        if (this.mVideoPauseListener != null) {
            this.mVideoPauseListener.onStart();
        }
    }

    public void pause() {
        super.pause();
        if (this.mVideoPauseListener != null) {
            this.mVideoPauseListener.onPause();
        }
    }

    public static class Wrapper
    extends FrameLayout
    implements ViewTreeObserver.OnGlobalLayoutListener {
        private WXVideoView mVideoView;
        private ProgressBar mProgressBar;
        private MediaController mMediaController;
        private Uri mUri;
        private MediaPlayer.OnPreparedListener mOnPreparedListener;
        private MediaPlayer.OnErrorListener mOnErrorListener;
        private MediaPlayer.OnCompletionListener mOnCompletionListener;
        private VideoPlayListener mVideoPlayListener;
        private boolean mControls = true;

        public Wrapper(Context context) {
            super(context);
            this.init(context);
        }

        public Wrapper(Context context, AttributeSet attrs) {
            super(context, attrs);
            this.init(context);
        }

        public Wrapper(Context context, AttributeSet attrs, int defStyleAttr) {
            super(context, attrs, defStyleAttr);
            this.init(context);
        }

        private void init(Context context) {
            this.setBackgroundColor(WXResourceUtils.getColor("#ee000000"));
            this.mProgressBar = new ProgressBar(context);
            FrameLayout.LayoutParams pLayoutParams = new FrameLayout.LayoutParams(-2, -2);
            this.mProgressBar.setLayoutParams((ViewGroup.LayoutParams)pLayoutParams);
            pLayoutParams.gravity = 17;
            this.addView((View)this.mProgressBar);
            this.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }

        public ProgressBar getProgressBar() {
            return this.mProgressBar;
        }

        @Nullable
        public WXVideoView getVideoView() {
            return this.mVideoView;
        }

        @NonNull
        public WXVideoView createIfNotExist() {
            if (this.mVideoView == null) {
                this.createVideoView();
            }
            return this.mVideoView;
        }

        @Nullable
        public MediaController getMediaController() {
            return this.mMediaController;
        }

        public void setVideoURI(Uri uri) {
            this.mUri = uri;
            if (this.mVideoView != null) {
                this.mVideoView.setVideoURI(uri);
            }
        }

        public void start() {
            if (this.mVideoView != null) {
                this.mVideoView.start();
            }
        }

        public void pause() {
            if (this.mVideoView != null) {
                this.mVideoView.pause();
            }
        }

        public void stopPlayback() {
            if (this.mVideoView != null) {
                this.mVideoView.stopPlayback();
            }
        }

        public void resume() {
            if (this.mVideoView != null) {
                this.mVideoView.resume();
            }
        }

        public void setOnErrorListener(MediaPlayer.OnErrorListener l) {
            this.mOnErrorListener = l;
            if (this.mVideoView != null) {
                this.mVideoView.setOnErrorListener(l);
            }
        }

        public void setOnPreparedListener(MediaPlayer.OnPreparedListener l) {
            this.mOnPreparedListener = l;
            if (this.mVideoView != null) {
                this.mVideoView.setOnPreparedListener(l);
            }
        }

        public void setOnCompletionListener(MediaPlayer.OnCompletionListener l) {
            this.mOnCompletionListener = l;
            if (this.mVideoView != null) {
                this.mVideoView.setOnCompletionListener(l);
            }
        }

        public void setOnVideoPauseListener(VideoPlayListener listener) {
            this.mVideoPlayListener = listener;
            if (this.mVideoView != null) {
                this.mVideoView.setOnVideoPauseListener(listener);
            }
        }

        public void setControls(boolean controls) {
            this.mControls = controls;
            if (this.mVideoView != null && this.mMediaController != null) {
                if (!this.mControls) {
                    this.mMediaController.setVisibility(8);
                } else {
                    this.mMediaController.setVisibility(0);
                }
            }
        }

        private synchronized void createVideoView() {
            if (this.mVideoView != null) {
                return;
            }
            Context context = this.getContext();
            WXVideoView video = new WXVideoView(context);
            FrameLayout.LayoutParams videoLayoutParams = new FrameLayout.LayoutParams(-1, -1);
            videoLayoutParams.gravity = 17;
            video.setLayoutParams((ViewGroup.LayoutParams)videoLayoutParams);
            this.addView((View)video, 0);
            video.setOnErrorListener(this.mOnErrorListener);
            video.setOnPreparedListener(this.mOnPreparedListener);
            video.setOnCompletionListener(this.mOnCompletionListener);
            video.setOnVideoPauseListener(this.mVideoPlayListener);
            MediaController controller = new MediaController(context);
            controller.setAnchorView((View)this);
            video.setMediaController(controller);
            controller.setMediaPlayer((MediaController.MediaPlayerControl)video);
            if (!this.mControls) {
                controller.setVisibility(8);
            } else {
                controller.setVisibility(0);
            }
            this.mMediaController = controller;
            this.mVideoView = video;
            this.mVideoView.setZOrderOnTop(true);
            if (this.mUri != null) {
                this.setVideoURI(this.mUri);
            }
        }

        @SuppressLint(value={"NewApi"})
        private void removeSelfFromViewTreeObserver() {
            if (Build.VERSION.SDK_INT >= 16) {
                this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            } else {
                this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        }

        public boolean createVideoViewIfVisible() {
            Rect visibleRect = new Rect();
            if (this.mVideoView != null) {
                return true;
            }
            if (this.getGlobalVisibleRect(visibleRect) && !visibleRect.isEmpty()) {
                this.createVideoView();
                return true;
            }
            return false;
        }

        public void onGlobalLayout() {
            if (this.createVideoViewIfVisible()) {
                this.removeSelfFromViewTreeObserver();
            }
        }
    }

    public static interface VideoPlayListener {
        public void onPause();

        public void onStart();
    }
}

