/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.ui.view;

import android.content.Context;
import android.graphics.Canvas;
import android.support.annotation.Nullable;
import android.view.MotionEvent;
import android.view.View;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import org.apache.weex.WXSDKInstance;
import org.apache.weex.WXSDKManager;
import org.apache.weex.common.WXErrorCode;
import org.apache.weex.ui.component.WXComponent;
import org.apache.weex.ui.component.WXDiv;
import org.apache.weex.ui.view.BaseFrameLayout;
import org.apache.weex.ui.view.IRenderResult;
import org.apache.weex.ui.view.IRenderStatus;
import org.apache.weex.ui.view.gesture.WXGesture;
import org.apache.weex.ui.view.gesture.WXGestureObservable;
import org.apache.weex.utils.WXExceptionUtils;
import org.apache.weex.utils.WXLogUtils;

public class WXFrameLayout
extends BaseFrameLayout
implements WXGestureObservable,
IRenderStatus<WXDiv>,
IRenderResult<WXDiv> {
    private WeakReference<WXDiv> mWeakReference;
    private WXGesture wxGesture;

    public WXFrameLayout(Context context) {
        super(context);
    }

    @Override
    @Nullable
    public WXDiv getComponent() {
        return null != this.mWeakReference ? (WXDiv)this.mWeakReference.get() : null;
    }

    @Override
    public void holdComponent(WXDiv component) {
        this.mWeakReference = new WeakReference<WXDiv>(component);
    }

    @Override
    public void registerGestureListener(WXGesture wxGesture) {
        this.wxGesture = wxGesture;
    }

    @Override
    public WXGesture getGestureListener() {
        return this.wxGesture;
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        boolean result = super.dispatchTouchEvent(event);
        if (this.wxGesture != null) {
            result |= this.wxGesture.onTouch((View)this, event);
        }
        return result;
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        try {
            super.dispatchDrawInterval(canvas);
        }
        catch (Throwable e) {
            if (this.getComponent() != null) {
                WXSDKInstance instance;
                this.notifyLayerOverFlow();
                if (null != this.getComponent() && null != (instance = WXSDKManager.getInstance().getSDKInstance(this.getComponent().getInstanceId())) && null != instance.getApmForInstance() && !instance.getApmForInstance().hasReportLayerOverDraw) {
                    instance.getApmForInstance().hasReportLayerOverDraw = true;
                    this.reportLayerOverFlowError();
                }
            }
            WXLogUtils.e("Layer overflow limit error", WXLogUtils.getStackTrace(e));
        }
    }

    private int reportLayerOverFlowError() {
        int deep = this.calLayerDeep((View)this, 0);
        if (this.getComponent() != null) {
            WXExceptionUtils.commitCriticalExceptionRT(this.getComponent().getInstanceId(), WXErrorCode.WX_RENDER_ERR_LAYER_OVERFLOW, "draw android view", WXErrorCode.WX_RENDER_ERR_LAYER_OVERFLOW.getErrorMsg() + "Layer overflow limit error: " + deep + " layers!", null);
        }
        return deep;
    }

    private int calLayerDeep(View view, int deep) {
        ++deep;
        if (view.getParent() != null && view.getParent() instanceof View) {
            return this.calLayerDeep((View)view.getParent(), deep);
        }
        return deep;
    }

    public void notifyLayerOverFlow() {
        if (this.getComponent() == null) {
            return;
        }
        WXSDKInstance instance = this.getComponent().getInstance();
        if (instance == null) {
            return;
        }
        if (instance.getLayerOverFlowListeners() == null) {
            return;
        }
        for (String ref : instance.getLayerOverFlowListeners()) {
            WXComponent component = WXSDKManager.getInstance().getWXRenderManager().getWXComponent(instance.getInstanceId(), ref);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("ref", ref);
            params.put("instanceid", component.getInstanceId());
            component.fireEvent("layeroverflow", params);
        }
    }
}

