/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.ui.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.FrameLayout;
import java.util.List;
import org.apache.weex.ui.flat.widget.Widget;
import org.apache.weex.utils.WXLogUtils;
import org.apache.weex.utils.WXViewUtils;

public class BaseFrameLayout
extends FrameLayout {
    private List<Widget> mWidgets;

    public BaseFrameLayout(Context context) {
        super(context);
    }

    protected void dispatchDraw(Canvas canvas) {
        try {
            this.dispatchDrawInterval(canvas);
        }
        catch (Throwable e) {
            WXLogUtils.e(WXLogUtils.getStackTrace(e));
        }
    }

    protected void dispatchDrawInterval(Canvas canvas) {
        if (this.mWidgets != null) {
            canvas.save();
            canvas.translate((float)this.getPaddingLeft(), (float)this.getPaddingTop());
            for (Widget widget : this.mWidgets) {
                widget.draw(canvas);
            }
            canvas.restore();
        } else {
            WXViewUtils.clipCanvasWithinBorderBox((View)this, canvas);
            super.dispatchDraw(canvas);
        }
    }

    public void mountFlatGUI(List<Widget> widgets) {
        this.mWidgets = widgets;
        if (this.mWidgets != null) {
            this.setWillNotDraw(true);
        }
        this.invalidate();
    }

    public void unmountFlatGUI() {
        this.mWidgets = null;
        this.setWillNotDraw(false);
        this.invalidate();
    }

    protected boolean verifyDrawable(@NonNull Drawable who) {
        return this.mWidgets != null || super.verifyDrawable(who);
    }
}

