/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.ui.module;

import android.app.Application;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.os.LocaleList;
import android.text.TextUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.weex.WXEnvironment;
import org.apache.weex.annotation.JSMethod;
import org.apache.weex.bridge.JSCallback;
import org.apache.weex.common.WXModule;

public class WXLocaleModule
extends WXModule {
    @JSMethod(uiThread=false)
    public String getLanguageSync() {
        return this.getLanguageImpl();
    }

    @JSMethod(uiThread=false)
    public void getLanguage(JSCallback callback) {
        callback.invoke(this.getLanguageImpl());
    }

    private String getLanguageImpl() {
        Locale locale = Build.VERSION.SDK_INT >= 24 ? LocaleList.getDefault().get(0) : Locale.getDefault();
        String language = locale.getLanguage() + "-" + locale.getCountry();
        return language;
    }

    @JSMethod(uiThread=false)
    public List<String> getLanguages() {
        String[] tags = this.getLanguageTags().split(",");
        return Arrays.asList(tags);
    }

    @JSMethod(uiThread=false)
    public void getLanguages(JSCallback callback) {
        callback.invoke(this.getLanguageTags().split(","));
    }

    private String getLanguageTags() {
        Configuration configuration;
        Resources res;
        Application application = WXEnvironment.getApplication();
        if (application != null && (res = application.getResources()) != null && (configuration = res.getConfiguration()) != null) {
            if (Build.VERSION.SDK_INT >= 24) {
                LocaleList localeList = configuration.getLocales();
                return localeList.toLanguageTags();
            }
            Locale local = configuration.locale;
            if (local != null) {
                return this.toLanguageTag(local);
            }
        }
        return "";
    }

    private String toLanguageTag(Locale locale) {
        if (Build.VERSION.SDK_INT >= 21) {
            return locale.toLanguageTag();
        }
        StringBuilder sb = new StringBuilder();
        String language = locale.getLanguage();
        String region = locale.getCountry();
        sb.append(language);
        if (!TextUtils.isEmpty((CharSequence)region)) {
            sb.append("-").append(region);
        }
        return sb.toString();
    }
}

