/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.ui.config;

import android.text.TextUtils;
import android.util.Pair;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.weex.WXEnvironment;
import org.apache.weex.WXSDKInstance;
import org.apache.weex.WXSDKManager;
import org.apache.weex.bridge.Invoker;
import org.apache.weex.ui.IFComponentHolder;
import org.apache.weex.ui.SimpleComponentHolder;
import org.apache.weex.ui.action.BasicComponentData;
import org.apache.weex.ui.component.WXComponent;
import org.apache.weex.ui.component.WXVContainer;
import org.apache.weex.utils.WXLogUtils;

public class ConfigComponentHolder
implements IFComponentHolder {
    public static final String TAG = "WeexScanConfigRegister";
    private Map<String, Invoker> mPropertyInvokers;
    private Map<String, Invoker> mMethodInvokers;
    private ClassLoader mClassLoader;
    private String mType;
    private boolean mAppendTree;
    private String mClassName;
    private String[] methods;
    private Class mClass;

    public ConfigComponentHolder(String mType, boolean mAppendTree, String mClassName, String[] methods) {
        this.mType = mType;
        this.mAppendTree = mAppendTree;
        this.mClassName = mClassName;
        this.methods = methods;
    }

    @Override
    public void loadIfNonLazy() {
    }

    private synchronized boolean generate() {
        if (this.mClass == null) {
            return false;
        }
        Pair<Map<String, Invoker>, Map<String, Invoker>> methodPair = SimpleComponentHolder.getMethods(this.mClass);
        this.mPropertyInvokers = (Map)methodPair.first;
        this.mMethodInvokers = (Map)methodPair.second;
        return true;
    }

    @Override
    public synchronized WXComponent createInstance(WXSDKInstance instance, WXVContainer parent, BasicComponentData basicComponentData) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        if (this.mClass == null || this.mClassLoader != instance.getContext().getClassLoader()) {
            this.mClass = WXSDKManager.getInstance().getClassLoaderAdapter().getComponentClass(this.mType, this.mClassName, instance);
            this.mClassLoader = instance.getContext().getClassLoader();
        }
        SimpleComponentHolder.ClazzComponentCreator creator = new SimpleComponentHolder.ClazzComponentCreator(this.mClass);
        WXComponent component = creator.createInstance(instance, parent, basicComponentData);
        component.bindHolder(this);
        return component;
    }

    @Override
    public synchronized Invoker getPropertyInvoker(String name) {
        if (this.mPropertyInvokers == null && !this.generate()) {
            return null;
        }
        return this.mPropertyInvokers.get(name);
    }

    @Override
    public Invoker getMethodInvoker(String name) {
        if (this.mMethodInvokers == null && !this.generate()) {
            return null;
        }
        return this.mMethodInvokers.get(name);
    }

    @Override
    public String[] getMethods() {
        if (this.methods == null) {
            return new String[0];
        }
        return this.methods;
    }

    public static final ConfigComponentHolder fromConfig(JSONObject config) {
        if (config == null) {
            return null;
        }
        try {
            String type = config.getString("name");
            boolean appendTree = config.getBooleanValue("appendTree");
            String className = config.getString("className");
            JSONArray methods = null;
            if (config.containsKey((Object)"methods")) {
                methods = config.getJSONArray("methods");
            }
            if (TextUtils.isEmpty((CharSequence)type) || TextUtils.isEmpty((CharSequence)className)) {
                return null;
            }
            Object[] arrays = new String[]{};
            if (methods != null) {
                arrays = new String[methods.size()];
                methods.toArray(arrays);
            }
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d(TAG, "resolve component " + type + " className " + className + " methods " + methods);
            }
            return new ConfigComponentHolder(type, appendTree, className, (String[])arrays);
        }
        catch (Exception e) {
            WXLogUtils.e(TAG, e);
            return null;
        }
    }

    public boolean isAppendTree() {
        return this.mAppendTree;
    }

    public String getType() {
        return this.mType;
    }
}

