/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.ui.component.richtext.node;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.text.SpannableStringBuilder;
import java.util.LinkedList;
import java.util.Map;
import org.apache.weex.WXSDKEngine;
import org.apache.weex.WXSDKInstance;
import org.apache.weex.WXSDKManager;
import org.apache.weex.adapter.DrawableStrategy;
import org.apache.weex.ui.component.richtext.node.RichTextNode;
import org.apache.weex.ui.component.richtext.node.RichTextNodeCreator;
import org.apache.weex.ui.component.richtext.span.ImgSpan;
import org.apache.weex.ui.component.richtext.span.ItemClickSpan;
import org.apache.weex.utils.ImgURIUtil;
import org.apache.weex.utils.WXUtils;
import org.apache.weex.utils.WXViewUtils;

class ImgNode
extends RichTextNode {
    public static final String NODE_TYPE = "image";

    private ImgNode(Context context, String instanceId, String componentRef) {
        super(context, instanceId, componentRef);
    }

    private ImgNode(Context context, String instanceId, String componentRef, String ref, Map<String, Object> styles, Map<String, Object> attrs) {
        super(context, instanceId, componentRef, ref, styles, attrs);
    }

    @Override
    public String toString() {
        return "\ufeff";
    }

    @Override
    protected boolean isInternalNode() {
        return false;
    }

    @Override
    protected void updateSpans(SpannableStringBuilder spannableStringBuilder, int level) {
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        if (WXSDKEngine.getDrawableLoader() != null && this.style.containsKey("width") && this.style.containsKey("height") && this.attr.containsKey("src") && instance != null) {
            LinkedList<Object> spans = new LinkedList<Object>();
            spans.add(this.createImgSpan(instance));
            if (this.attr.containsKey("pseudoRef")) {
                spans.add((Object)new ItemClickSpan(this.mInstanceId, this.mComponentRef, this.attr.get("pseudoRef").toString()));
            }
            for (Object e : spans) {
                spannableStringBuilder.setSpan(e, 0, spannableStringBuilder.length(), ImgNode.createSpanFlag(level));
            }
        }
    }

    @NonNull
    private ImgSpan createImgSpan(WXSDKInstance instance) {
        int width = (int)WXViewUtils.getRealPxByWidth(WXUtils.getFloat(this.style.get("width")), instance.getInstanceViewPortWidth());
        int height = (int)WXViewUtils.getRealPxByWidth(WXUtils.getFloat(this.style.get("height")), instance.getInstanceViewPortWidth());
        ImgSpan imageSpan = new ImgSpan(width, height);
        String url = this.attr.get("src").toString();
        Uri rewrited = instance.rewriteUri(Uri.parse((String)url), NODE_TYPE);
        if ("local".equals(rewrited.getScheme())) {
            Drawable localDrawable = ImgURIUtil.getDrawableFromLoaclSrc(this.mContext, rewrited);
            imageSpan.setDrawable(localDrawable, false);
        } else {
            DrawableStrategy drawableStrategy = new DrawableStrategy();
            drawableStrategy.width = width;
            drawableStrategy.height = height;
            WXSDKEngine.getDrawableLoader().setDrawable(rewrited.toString(), imageSpan, drawableStrategy);
        }
        return imageSpan;
    }

    static class ImgNodeCreator
    implements RichTextNodeCreator<ImgNode> {
        ImgNodeCreator() {
        }

        @Override
        public ImgNode createRichTextNode(Context context, String instanceId, String componentRef) {
            return new ImgNode(context, instanceId, componentRef);
        }

        @Override
        public ImgNode createRichTextNode(Context context, String instanceId, String componentRef, String ref, Map<String, Object> styles, Map<String, Object> attrs) {
            return new ImgNode(context, instanceId, componentRef, ref, styles, attrs);
        }
    }
}

