/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.ui.component.richtext;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.Layout;
import android.text.Selection;
import android.text.Spannable;
import android.text.Spanned;
import android.text.style.ClickableSpan;
import android.view.MotionEvent;
import android.view.View;
import org.apache.weex.ui.component.richtext.span.ImgSpan;
import org.apache.weex.ui.view.WXTextView;

public class WXRichTextView
extends WXTextView {
    public WXRichTextView(Context context) {
        super(context);
    }

    @Override
    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        boolean superResult = super.onTouchEvent(event);
        boolean handled = false;
        if (this.isEnabled() && this.getTextLayout() != null && this.getText() instanceof Spannable) {
            Spannable spannable = (Spannable)this.getText();
            handled = this.updateSelection(event, spannable);
        }
        return handled || superResult;
    }

    protected boolean verifyDrawable(Drawable who) {
        super.verifyDrawable(who);
        return true;
    }

    @Override
    public void setTextLayout(Layout layout2) {
        Spanned spanned;
        ImgSpan[] imgSpan;
        super.setTextLayout(layout2);
        if (layout2.getText() instanceof Spanned && (imgSpan = (ImgSpan[])(spanned = (Spanned)layout2.getText()).getSpans(0, spanned.length(), ImgSpan.class)) != null) {
            for (ImgSpan span : imgSpan) {
                span.setView(this);
            }
        }
    }

    private boolean updateSelection(MotionEvent event, Spannable buffer) {
        int action = event.getActionMasked();
        if (action == 1 || action == 0) {
            int line;
            int x = (int)event.getX();
            int y = (int)event.getY();
            x -= this.getPaddingLeft();
            y -= this.getPaddingTop();
            Layout layout2 = this.getTextLayout();
            int off = layout2.getOffsetForHorizontal(line = layout2.getLineForVertical(y += this.getScrollY()), (float)(x += this.getScrollX()));
            ClickableSpan[] link = (ClickableSpan[])buffer.getSpans(off, off, ClickableSpan.class);
            if (link.length != 0) {
                if (action == 1) {
                    link[0].onClick((View)this);
                } else {
                    Selection.setSelection((Spannable)buffer, (int)buffer.getSpanStart((Object)link[0]), (int)buffer.getSpanEnd((Object)link[0]));
                }
                return true;
            }
            Selection.removeSelection((Spannable)buffer);
        }
        return false;
    }
}

