/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.ui.component.list.template;

import android.os.AsyncTask;
import android.os.Looper;
import android.os.MessageQueue;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.weex.WXEnvironment;
import org.apache.weex.ui.component.list.WXCell;
import org.apache.weex.ui.component.list.template.TemplateCache;
import org.apache.weex.ui.component.list.template.WXRecyclerTemplateList;

class AsyncCellLoadTask
extends AsyncTask<Void, Void, Void> {
    private String template;
    private WXCell source;
    private WXRecyclerTemplateList templateList;

    public AsyncCellLoadTask(String template, WXCell source, WXRecyclerTemplateList templateList) {
        this.template = template;
        this.source = source;
        this.templateList = templateList;
    }

    protected Void doInBackground(Void ... params) {
        TemplateCache cellCache = this.templateList.getTemplatesCache().get(this.template);
        if (cellCache == null || cellCache.cells == null) {
            return null;
        }
        while (cellCache.cells.size() < this.templateList.getTemplateCacheSize()) {
            long start = System.currentTimeMillis();
            WXCell component = (WXCell)this.templateList.copyComponentFromSourceCell(this.source);
            if (WXEnvironment.isOpenDebugLog()) {
                // empty if block
            }
            if (component == null) {
                return null;
            }
            if (this.isDestory()) {
                return null;
            }
            cellCache.cells.add(component);
        }
        return null;
    }

    protected void onPostExecute(Void aVoid) {
        if (this.isDestory()) {
            return;
        }
        final TemplateCache cellCache = this.templateList.getTemplatesCache().get(this.template);
        if (cellCache == null) {
            return;
        }
        if (cellCache.cells == null || cellCache.cells.size() == 0) {
            cellCache.isLoadIng = false;
            return;
        }
        Looper.myQueue().addIdleHandler(new MessageQueue.IdleHandler(){

            public boolean queueIdle() {
                if (AsyncCellLoadTask.this.isDestory()) {
                    return false;
                }
                ConcurrentLinkedQueue<WXCell> queue = cellCache.cells;
                Iterator<WXCell> iterator = queue.iterator();
                while (iterator.hasNext()) {
                    WXCell component = iterator.next();
                    if (!component.isLazy()) continue;
                    AsyncCellLoadTask.this.templateList;
                    WXRecyclerTemplateList.doCreateCellViewBindData(component, AsyncCellLoadTask.this.template, true);
                    return iterator.hasNext();
                }
                return false;
            }
        });
        cellCache.isLoadIng = false;
    }

    private boolean isDestory() {
        if (this.source.getInstance() == null || this.source.getInstance().isDestroy()) {
            return true;
        }
        return this.templateList.isDestoryed();
    }

    public void startTask() {
        this.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }
}

