/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.ui.component.list;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import org.apache.weex.WXSDKInstance;
import org.apache.weex.annotation.Component;
import org.apache.weex.dom.WXAttr;
import org.apache.weex.ui.ComponentCreator;
import org.apache.weex.ui.action.BasicComponentData;
import org.apache.weex.ui.component.WXComponent;
import org.apache.weex.ui.component.WXHeader;
import org.apache.weex.ui.component.WXVContainer;
import org.apache.weex.ui.flat.WidgetContainer;
import org.apache.weex.ui.view.WXFrameLayout;
import org.apache.weex.utils.WXLogUtils;
import org.apache.weex.utils.WXUtils;
import org.apache.weex.utils.WXViewUtils;

@Component(lazyload=false)
public class WXCell
extends WidgetContainer<WXFrameLayout> {
    private int mLastLocationY = 0;
    private ViewGroup mRealView;
    private View mTempStickyView;
    private View mHeadView;
    private int mScrollPosition = -1;
    private boolean mFlatUIEnabled = false;
    private Object renderData;
    private boolean isSourceUsed = false;
    private boolean isAppendTreeDone;
    private CellAppendTreeListener cellAppendTreeListener;

    @Deprecated
    public WXCell(WXSDKInstance instance, WXVContainer parent, String instanceId, boolean isLazy, BasicComponentData basicComponentData) {
        super(instance, parent, basicComponentData);
    }

    public WXCell(WXSDKInstance instance, WXVContainer parent, boolean isLazy, BasicComponentData basicComponentData) {
        super(instance, parent, basicComponentData);
        this.lazy(true);
        if (Build.VERSION.SDK_INT < 21) {
            try {
                WXAttr attr = this.getAttrs();
                if (attr.containsKey("flat")) {
                    this.mFlatUIEnabled = WXUtils.getBoolean(attr.get("flat"), false);
                }
            }
            catch (NullPointerException e) {
                WXLogUtils.e("Cell", WXLogUtils.getStackTrace(e));
            }
        }
        if (!this.canRecycled()) {
            instance.getApmForInstance().updateDiffStats("wxCellDataUnRecycleCount", 1.0);
        }
        if (TextUtils.isEmpty((CharSequence)this.getAttrs().getScope())) {
            instance.getApmForInstance().updateDiffStats("wxCellUnReUseCount", 1.0);
        }
    }

    @Override
    public boolean isLazy() {
        return super.isLazy() && !this.isFixed();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public boolean isFlatUIEnabled() {
        return this.mFlatUIEnabled;
    }

    @Override
    protected WXFrameLayout initComponentHostView(@NonNull Context context) {
        if (this.isSticky() || this instanceof WXHeader) {
            WXFrameLayout view = new WXFrameLayout(context);
            this.mRealView = new WXFrameLayout(context);
            view.addView((View)this.mRealView);
            if (this.isFlatUIEnabled()) {
                view.setLayerType(2, null);
            }
            return view;
        }
        WXFrameLayout view = new WXFrameLayout(context);
        this.mRealView = view;
        if (this.isFlatUIEnabled()) {
            view.setLayerType(2, null);
        }
        return view;
    }

    public int getLocationFromStart() {
        return this.mLastLocationY;
    }

    public void setLocationFromStart(int l) {
        this.mLastLocationY = l;
    }

    void setScrollPositon(int pos) {
        this.mScrollPosition = pos;
    }

    public int getScrollPositon() {
        return this.mScrollPosition;
    }

    @Override
    public ViewGroup getRealView() {
        return this.mRealView;
    }

    public void removeSticky() {
        if (((WXFrameLayout)this.getHostView()).getChildCount() > 0) {
            this.mHeadView = ((WXFrameLayout)this.getHostView()).getChildAt(0);
            int[] location = new int[2];
            int[] parentLocation = new int[2];
            ((WXFrameLayout)this.getHostView()).getLocationOnScreen(location);
            this.getParentScroller().getView().getLocationOnScreen(parentLocation);
            int headerViewOffsetX = location[0] - parentLocation[0];
            int headerViewOffsetY = this.getParent().getHostView().getTop();
            ((WXFrameLayout)this.getHostView()).removeView(this.mHeadView);
            this.mRealView = (ViewGroup)this.mHeadView;
            this.mTempStickyView = new FrameLayout(this.getContext());
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams((int)this.getLayoutWidth(), (int)this.getLayoutHeight());
            ((WXFrameLayout)this.getHostView()).addView(this.mTempStickyView, (ViewGroup.LayoutParams)lp);
            this.mHeadView.setTranslationX((float)headerViewOffsetX);
            this.mHeadView.setTranslationY((float)headerViewOffsetY);
        }
    }

    public void recoverySticky() {
        if (this.mHeadView != null) {
            if (this.mHeadView.getLayoutParams() != null) {
                ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.mHeadView.getLayoutParams();
                if (params.topMargin > 0) {
                    params.topMargin = 0;
                }
            }
            if (this.mHeadView.getVisibility() != 0) {
                this.mHeadView.setVisibility(0);
            }
            if (this.mHeadView.getParent() != null) {
                ((ViewGroup)this.mHeadView.getParent()).removeView(this.mHeadView);
            }
            ((WXFrameLayout)this.getHostView()).removeView(this.mTempStickyView);
            ((WXFrameLayout)this.getHostView()).addView(this.mHeadView);
            this.mHeadView.setTranslationX(0.0f);
            this.mHeadView.setTranslationY(0.0f);
        }
    }

    @Override
    protected void mountFlatGUI() {
        if (this.getHostView() != null) {
            if (this.widgets == null) {
                this.widgets = new LinkedList();
            }
            ((WXFrameLayout)this.getHostView()).mountFlatGUI(this.widgets);
        }
    }

    @Override
    public void unmountFlatGUI() {
        if (this.getHostView() != null) {
            ((WXFrameLayout)this.getHostView()).unmountFlatGUI();
        }
    }

    @Override
    public boolean intendToBeFlatContainer() {
        return this.getInstance().getFlatUIContext().isFlatUIEnabled(this) && WXCell.class.equals(this.getClass()) && !this.isSticky();
    }

    @Override
    public int getStickyOffset() {
        if (this.getAttrs().get("stickyOffset") == null) {
            return 0;
        }
        float offset = WXUtils.getFloat(this.getAttrs().get("stickyOffset"));
        return (int)WXViewUtils.getRealPxByWidth(offset, this.getViewPortWidth());
    }

    public Object getRenderData() {
        return this.renderData;
    }

    public void setRenderData(Object renderData) {
        this.renderData = renderData;
    }

    public boolean isSourceUsed() {
        return this.isSourceUsed;
    }

    public void setSourceUsed(boolean sourceUsed) {
        this.isSourceUsed = sourceUsed;
    }

    public boolean isAppendTreeDone() {
        return this.isAppendTreeDone;
    }

    @Override
    public void appendTreeCreateFinish() {
        super.appendTreeCreateFinish();
        this.isAppendTreeDone = true;
        if (this.cellAppendTreeListener != null) {
            this.cellAppendTreeListener.onAppendTreeDone();
        }
    }

    public void setCellAppendTreeListener(CellAppendTreeListener cellAppendTreeListener) {
        this.cellAppendTreeListener = cellAppendTreeListener;
        if (this.isAppendTreeDone) {
            cellAppendTreeListener.onAppendTreeDone();
        }
    }

    public static interface CellAppendTreeListener {
        public void onAppendTreeDone();
    }

    public static class Creator
    implements ComponentCreator {
        @Override
        public WXComponent createInstance(WXSDKInstance instance, WXVContainer parent, BasicComponentData basicComponentData) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            return new WXCell(instance, parent, true, basicComponentData);
        }
    }
}

