/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.ui.component.list;

import android.support.v7.widget.RecyclerView;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.weex.ui.view.listview.adapter.TransformItemDecoration;
import org.apache.weex.utils.WXLogUtils;

public class RecyclerTransform {
    public static final String TRANSFORM = "transform";
    private static final Pattern transformPattern = Pattern.compile("([a-z]+)\\(([0-9\\.]+),?([0-9\\.]+)?\\)");
    private static final String TAG = "RecyclerTransform";

    public static RecyclerView.ItemDecoration parseTransforms(int orientation, String raw) {
        if (raw == null) {
            return null;
        }
        float scaleX = 0.0f;
        float scaleY = 0.0f;
        int translateX = 0;
        int translateY = 0;
        float opacity = 0.0f;
        int rotate = 0;
        Matcher matcher = transformPattern.matcher(raw);
        while (matcher.find()) {
            String match = matcher.group();
            String name = matcher.group(1);
            try {
                switch (name) {
                    case "scale": {
                        scaleX = Float.parseFloat(matcher.group(2));
                        scaleY = Float.parseFloat(matcher.group(3));
                        break;
                    }
                    case "translate": {
                        translateX = Integer.parseInt(matcher.group(2));
                        translateY = Integer.parseInt(matcher.group(3));
                        break;
                    }
                    case "opacity": {
                        opacity = Float.parseFloat(matcher.group(2));
                        break;
                    }
                    case "rotate": {
                        rotate = Integer.parseInt(matcher.group(2));
                        break;
                    }
                    default: {
                        WXLogUtils.e(TAG, "Invaild transform expression:" + match);
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                WXLogUtils.e("", e);
                WXLogUtils.e(TAG, "Invaild transform expression:" + match);
            }
        }
        return new TransformItemDecoration(orientation == 1, opacity, translateX, translateY, rotate, scaleX, scaleY);
    }
}

