/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.ui.component.helper;

import android.app.Activity;
import android.graphics.Rect;
import android.os.Build;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import java.lang.ref.WeakReference;
import org.apache.weex.utils.WXLogUtils;
import org.apache.weex.utils.WXViewUtils;

public class SoftKeyboardDetector {
    private static final int KEYBOARD_VISIBLE_THRESHOLD_DIP = 100;

    public static Unregister registerKeyboardEventListener(Activity activity, final OnKeyboardEventListener listener) {
        int softInputMode;
        WindowManager.LayoutParams attributes;
        if (activity == null || listener == null) {
            WXLogUtils.e("Activity or listener is null!");
            return null;
        }
        if (activity.getWindow() != null && (attributes = activity.getWindow().getAttributes()) != null && ((softInputMode = attributes.softInputMode) == 48 || softInputMode == 32)) {
            WXLogUtils.e("SoftKeyboard detector can't work with softInputMode is SOFT_INPUT_ADJUST_NOTHING or SOFT_INPUT_ADJUST_PAN");
            return null;
        }
        final View activityRoot = SoftKeyboardDetector.getActivityRoot(activity);
        if (activityRoot == null) {
            WXLogUtils.e("Activity root is null!");
            return null;
        }
        ViewTreeObserver.OnGlobalLayoutListener layoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){
            private final Rect visibleFrame = new Rect();
            private final int threshold = WXViewUtils.dip2px(100.0f);
            private boolean wasKeyboardOpened = false;

            public void onGlobalLayout() {
                boolean isOpen;
                activityRoot.getWindowVisibleDisplayFrame(this.visibleFrame);
                int heightDiff = activityRoot.getRootView().getHeight() - this.visibleFrame.height();
                boolean bl = isOpen = heightDiff > this.threshold;
                if (isOpen == this.wasKeyboardOpened) {
                    return;
                }
                this.wasKeyboardOpened = isOpen;
                listener.onKeyboardEvent(isOpen);
            }
        };
        activityRoot.getViewTreeObserver().addOnGlobalLayoutListener(layoutListener);
        return new DefaultUnRegister(activity, layoutListener);
    }

    public static boolean isKeyboardVisible(Activity activity) {
        Rect windowFrame = new Rect();
        View root = SoftKeyboardDetector.getActivityRoot(activity);
        if (root != null) {
            root.getWindowVisibleDisplayFrame(windowFrame);
            int heightDiff = root.getRootView().getHeight() - windowFrame.height();
            return heightDiff > WXViewUtils.dip2px(100.0f);
        }
        return false;
    }

    @Nullable
    public static View getActivityRoot(Activity activity) {
        if (activity != null) {
            return activity.findViewById(0x1020002);
        }
        return null;
    }

    public static interface OnKeyboardEventListener {
        public void onKeyboardEvent(boolean var1);
    }

    public static interface Unregister {
        public void execute();
    }

    public static final class DefaultUnRegister
    implements Unregister {
        private WeakReference<Activity> activityRef;
        private WeakReference<ViewTreeObserver.OnGlobalLayoutListener> listenerRef;

        public DefaultUnRegister(Activity activity, ViewTreeObserver.OnGlobalLayoutListener listener) {
            this.activityRef = new WeakReference<Activity>(activity);
            this.listenerRef = new WeakReference<ViewTreeObserver.OnGlobalLayoutListener>(listener);
        }

        @Override
        public void execute() {
            View root;
            Activity activity = (Activity)this.activityRef.get();
            ViewTreeObserver.OnGlobalLayoutListener listener = (ViewTreeObserver.OnGlobalLayoutListener)this.listenerRef.get();
            if (activity != null && listener != null && (root = SoftKeyboardDetector.getActivityRoot(activity)) != null) {
                if (Build.VERSION.SDK_INT >= 16) {
                    root.getViewTreeObserver().removeOnGlobalLayoutListener(listener);
                } else {
                    root.getViewTreeObserver().removeGlobalOnLayoutListener(listener);
                }
            }
            this.activityRef.clear();
            this.listenerRef.clear();
        }
    }
}

