/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.ui.component.basic;

import android.support.annotation.NonNull;
import android.view.View;
import java.util.Map;
import java.util.Set;
import org.apache.weex.dom.CSSShorthand;
import org.apache.weex.dom.WXAttr;
import org.apache.weex.dom.WXEvent;
import org.apache.weex.dom.WXStyle;
import org.apache.weex.ui.action.BasicComponentData;
import org.apache.weex.ui.action.GraphicPosition;
import org.apache.weex.ui.action.GraphicSize;
import org.apache.weex.ui.component.WXComponent;

public abstract class WXBasicComponent<T extends View> {
    private Object mExtra;
    private String mComponentType;
    private String mRef;
    private GraphicPosition mLayoutPosition;
    private GraphicSize mLayoutSize;
    private boolean mIsLayoutRTL;
    private BasicComponentData mBasicComponentData;
    private int mViewPortWidth = 750;

    public WXBasicComponent(BasicComponentData basicComponentData) {
        this.mBasicComponentData = basicComponentData;
        this.mRef = basicComponentData.mRef;
        this.mComponentType = basicComponentData.mComponentType;
    }

    public BasicComponentData getBasicComponentData() {
        return this.mBasicComponentData;
    }

    protected void bindComponent(WXComponent component) {
        this.mComponentType = component.getComponentType();
        this.mRef = component.getRef();
    }

    @NonNull
    public final WXStyle getStyles() {
        return this.mBasicComponentData.getStyles();
    }

    @NonNull
    public final WXAttr getAttrs() {
        return this.mBasicComponentData.getAttrs();
    }

    @NonNull
    public final WXEvent getEvents() {
        return this.mBasicComponentData.getEvents();
    }

    @NonNull
    public final CSSShorthand getMargin() {
        return this.mBasicComponentData.getMargin();
    }

    @NonNull
    public final CSSShorthand getPadding() {
        return this.mBasicComponentData.getPadding();
    }

    @NonNull
    public CSSShorthand getBorder() {
        return this.mBasicComponentData.getBorder();
    }

    public final void setMargins(@NonNull CSSShorthand margins) {
        this.mBasicComponentData.setMargins(margins);
    }

    public final void setPaddings(@NonNull CSSShorthand paddings) {
        this.mBasicComponentData.setPaddings(paddings);
    }

    public final void setBorders(@NonNull CSSShorthand borders) {
        this.mBasicComponentData.setBorders(borders);
    }

    public final void addAttr(Map<String, Object> attrs) {
        if (attrs == null || attrs.isEmpty()) {
            return;
        }
        this.mBasicComponentData.addAttr(attrs);
    }

    public final void addStyle(Map<String, Object> styles) {
        if (styles == null || styles.isEmpty()) {
            return;
        }
        this.mBasicComponentData.addStyle(styles);
    }

    public final void addStyle(Map<String, Object> styles, boolean byPesudo) {
        if (styles == null || styles.isEmpty()) {
            return;
        }
        this.mBasicComponentData.addStyle(styles, byPesudo);
    }

    public final void updateStyle(Map<String, Object> styles, boolean byPesudo) {
        if (styles == null || styles.isEmpty()) {
            return;
        }
        this.mBasicComponentData.getStyles().updateStyle(styles, byPesudo);
    }

    public final void addEvent(Set<String> events) {
        if (events == null || events.isEmpty()) {
            return;
        }
        this.mBasicComponentData.addEvent(events);
    }

    public final void addShorthand(Map<String, String> shorthand) {
        if (!shorthand.isEmpty() && this.mBasicComponentData != null) {
            this.mBasicComponentData.addShorthand(shorthand);
        }
    }

    public int getViewPortWidth() {
        return this.mViewPortWidth;
    }

    public void setViewPortWidth(int mViewPortWidth) {
        this.mViewPortWidth = mViewPortWidth;
    }

    public Object getExtra() {
        return this.mExtra;
    }

    public void updateExtra(Object extra) {
        this.mExtra = extra;
    }

    public String getComponentType() {
        return this.mComponentType;
    }

    public String getRef() {
        return this.mRef;
    }

    public void setIsLayoutRTL(boolean isRTL) {
        this.mIsLayoutRTL = isRTL;
    }

    public boolean isLayoutRTL() {
        return this.mIsLayoutRTL;
    }

    public GraphicPosition getLayoutPosition() {
        if (this.mLayoutPosition == null) {
            this.mLayoutPosition = new GraphicPosition(0.0f, 0.0f, 0.0f, 0.0f);
        }
        return this.mLayoutPosition;
    }

    protected void setLayoutPosition(GraphicPosition mLayoutPosition) {
        this.mLayoutPosition = mLayoutPosition;
    }

    public GraphicSize getLayoutSize() {
        if (this.mLayoutSize == null) {
            this.mLayoutSize = new GraphicSize(0.0f, 0.0f);
        }
        return this.mLayoutSize;
    }

    protected void setLayoutSize(GraphicSize mLayoutSize) {
        this.mLayoutSize = mLayoutSize;
    }

    public float getCSSLayoutTop() {
        return this.mLayoutPosition == null ? 0.0f : this.mLayoutPosition.getTop();
    }

    public float getCSSLayoutBottom() {
        return this.mLayoutPosition == null ? 0.0f : this.mLayoutPosition.getBottom();
    }

    public float getCSSLayoutLeft() {
        return this.mLayoutPosition == null ? 0.0f : this.mLayoutPosition.getLeft();
    }

    public float getCSSLayoutRight() {
        return this.mLayoutPosition == null ? 0.0f : this.mLayoutPosition.getRight();
    }

    public float getLayoutWidth() {
        return this.mLayoutSize == null ? 0.0f : this.mLayoutSize.getWidth();
    }

    public float getLayoutHeight() {
        return this.mLayoutSize == null ? 0.0f : this.mLayoutSize.getHeight();
    }
}

