/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.ui.component;

import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.widget.FrameLayout;
import java.util.HashMap;
import org.apache.weex.WXEnvironment;
import org.apache.weex.WXSDKInstance;
import org.apache.weex.WXSDKManager;
import org.apache.weex.annotation.Component;
import org.apache.weex.ui.action.BasicComponentData;
import org.apache.weex.ui.component.WXComponent;
import org.apache.weex.ui.component.WXComponentProp;
import org.apache.weex.ui.component.WXVContainer;
import org.apache.weex.ui.view.WXVideoView;
import org.apache.weex.utils.WXLogUtils;
import org.apache.weex.utils.WXUtils;

@Component(lazyload=false)
public class WXVideo
extends WXComponent<FrameLayout> {
    private boolean mAutoPlay;
    private WXVideoView.Wrapper mWrapper;
    boolean mPrepared;
    private boolean mError;
    private boolean mStopped;

    @Deprecated
    public WXVideo(WXSDKInstance instance, WXVContainer parent, String instanceId, boolean isLazy, BasicComponentData basicComponentData) {
        this(instance, parent, isLazy, basicComponentData);
    }

    public WXVideo(WXSDKInstance instance, WXVContainer parent, boolean isLazy, BasicComponentData basicComponentData) {
        super(instance, parent, isLazy, basicComponentData);
    }

    @Override
    protected FrameLayout initComponentHostView(@NonNull Context context) {
        final WXVideoView.Wrapper video = new WXVideoView.Wrapper(context);
        video.setOnErrorListener(new MediaPlayer.OnErrorListener(){

            public boolean onError(MediaPlayer mp, int what, int extra) {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d("Video", "onError:" + what);
                }
                video.getProgressBar().setVisibility(8);
                WXVideo.this.mPrepared = false;
                WXVideo.this.mError = true;
                if (WXVideo.this.getEvents().contains("fail")) {
                    WXVideo.this.notify("fail", "stop");
                }
                return true;
            }
        });
        video.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mediaPlayer) {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d("Video", "onPrepared");
                }
                video.getProgressBar().setVisibility(8);
                WXVideo.this.mPrepared = true;
                if (WXVideo.this.mAutoPlay) {
                    video.start();
                }
                WXVideoView videoView = video.getVideoView();
                videoView.seekTo(5);
                if (video.getMediaController() != null) {
                    if (!WXVideo.this.mStopped) {
                        video.getMediaController().show(3);
                    } else {
                        video.getMediaController().hide();
                    }
                }
                WXVideo.this.mStopped = false;
            }
        });
        video.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mediaPlayer) {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d("Video", "onCompletion");
                }
                if (WXVideo.this.getEvents().contains("finish")) {
                    WXVideo.this.notify("finish", "stop");
                }
            }
        });
        video.setOnVideoPauseListener(new WXVideoView.VideoPlayListener(){

            @Override
            public void onPause() {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d("Video", "onPause");
                }
                if (WXVideo.this.getEvents().contains("pause")) {
                    WXVideo.this.notify("pause", "pause");
                }
            }

            @Override
            public void onStart() {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d("Video", "onStart");
                }
                if (WXVideo.this.getEvents().contains("start")) {
                    WXVideo.this.notify("start", "play");
                }
            }
        });
        this.mWrapper = video;
        return video;
    }

    private void notify(String event, String newStatus) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("playStatus", newStatus);
        params.put("timeStamp", System.currentTimeMillis());
        HashMap<String, Object> domChanges = new HashMap<String, Object>();
        HashMap<String, String> attrsChanges = new HashMap<String, String>();
        attrsChanges.put("playStatus", newStatus);
        domChanges.put("attrs", attrsChanges);
        WXSDKManager.getInstance().fireEvent(this.getInstanceId(), this.getRef(), event, params, domChanges);
    }

    @Override
    public void bindData(WXComponent component) {
        super.bindData(component);
        this.addEvent("appear");
    }

    @Override
    public void notifyAppearStateChange(String wxEventType, String direction) {
        super.notifyAppearStateChange(wxEventType, direction);
        this.mWrapper.createVideoViewIfVisible();
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        switch (key) {
            case "src": {
                String src = WXUtils.getString(param, null);
                if (src != null) {
                    this.setSrc(src);
                }
                return true;
            }
            case "autoPlay": 
            case "autoplay": {
                Boolean result = WXUtils.getBoolean(param, null);
                if (result != null) {
                    this.setAutoPlay(result);
                }
                return true;
            }
            case "zOrderTop": {
                Boolean zOrderTop = WXUtils.getBoolean(param, null);
                if (zOrderTop != null) {
                    this.mWrapper.getVideoView().setZOrderOnTop(zOrderTop);
                }
                return true;
            }
            case "playStatus": {
                String status = WXUtils.getString(param, null);
                if (status != null) {
                    this.setPlaystatus(status);
                }
                return true;
            }
        }
        return super.setProperty(key, param);
    }

    @WXComponentProp(name="src")
    public void setSrc(String src) {
        if (TextUtils.isEmpty((CharSequence)src) || this.getHostView() == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)src)) {
            WXSDKInstance instance = this.getInstance();
            this.mWrapper.setVideoURI(instance.rewriteUri(Uri.parse((String)src), "video"));
            this.mWrapper.getProgressBar().setVisibility(0);
        }
    }

    @WXComponentProp(name="autoPlay")
    public void setAutoPlay(boolean autoPlay) {
        this.mAutoPlay = autoPlay;
        if (autoPlay) {
            this.mWrapper.createIfNotExist();
            this.mWrapper.start();
        }
    }

    @WXComponentProp(name="controls")
    public void setControls(String controls) {
        if (TextUtils.equals((CharSequence)"controls", (CharSequence)controls)) {
            this.mWrapper.setControls(true);
        } else if (TextUtils.equals((CharSequence)"nocontrols", (CharSequence)controls)) {
            this.mWrapper.setControls(false);
        }
    }

    @WXComponentProp(name="playStatus")
    public void setPlaystatus(String playstatus) {
        if (this.mPrepared && !this.mError && !this.mStopped) {
            if (playstatus.equals("play")) {
                this.mWrapper.start();
            } else if (playstatus.equals("pause")) {
                this.mWrapper.pause();
            } else if (playstatus.equals("stop")) {
                this.mWrapper.stopPlayback();
                this.mStopped = true;
            }
        } else if ((this.mError || this.mStopped) && playstatus.equals("play")) {
            this.mError = false;
            this.mWrapper.resume();
            this.mWrapper.getProgressBar().setVisibility(0);
        }
    }
}

