/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.ui.component;

import android.content.Context;
import android.support.annotation.NonNull;
import org.apache.weex.WXSDKInstance;
import org.apache.weex.annotation.Component;
import org.apache.weex.ui.action.BasicComponentData;
import org.apache.weex.ui.component.WXComponent;
import org.apache.weex.ui.component.WXComponentProp;
import org.apache.weex.ui.component.WXVContainer;
import org.apache.weex.ui.view.refresh.circlebar.CircleProgressBar;
import org.apache.weex.utils.WXResourceUtils;
import org.apache.weex.utils.WXUtils;

@Component(lazyload=false)
public class WXLoadingIndicator
extends WXComponent<CircleProgressBar> {
    public WXLoadingIndicator(WXSDKInstance instance, WXVContainer parent, boolean isLazy, BasicComponentData basicComponentData) {
        super(instance, parent, isLazy, basicComponentData);
    }

    @Override
    protected CircleProgressBar initComponentHostView(@NonNull Context context) {
        return new CircleProgressBar(context);
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        switch (key) {
            case "color": {
                String color = WXUtils.getString(param, null);
                if (color != null) {
                    this.setColor(color);
                }
                return true;
            }
            case "animating": {
                Boolean result = WXUtils.getBoolean(param, null);
                if (result != null) {
                    this.setAnimating(result);
                }
                return true;
            }
        }
        return super.setProperty(key, param);
    }

    @WXComponentProp(name="color")
    public void setColor(String color) {
        if (color != null && !color.equals("")) {
            int parseColor = WXResourceUtils.getColor(color, -65536);
            ((CircleProgressBar)((Object)this.getHostView())).setColorSchemeColors(parseColor);
        }
    }

    @WXComponentProp(name="animating")
    public void setAnimating(boolean animating) {
        if (animating) {
            ((CircleProgressBar)((Object)this.getHostView())).start();
        } else {
            ((CircleProgressBar)((Object)this.getHostView())).stop();
        }
    }
}

