/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.ui.component;

import android.text.TextUtils;
import org.apache.weex.WXEnvironment;
import org.apache.weex.WXSDKInstance;
import org.apache.weex.common.WXErrorCode;
import org.apache.weex.ui.IFComponentHolder;
import org.apache.weex.ui.WXComponentRegistry;
import org.apache.weex.ui.action.BasicComponentData;
import org.apache.weex.ui.component.WXComponent;
import org.apache.weex.ui.component.WXVContainer;
import org.apache.weex.utils.WXExceptionUtils;
import org.apache.weex.utils.WXLogUtils;

public class WXComponentFactory {
    public static WXComponent newInstance(WXSDKInstance instance, WXVContainer parent, BasicComponentData basicComponentData) {
        if (instance == null || TextUtils.isEmpty((CharSequence)basicComponentData.mComponentType)) {
            return null;
        }
        IFComponentHolder holder = WXComponentRegistry.getComponent(basicComponentData.mComponentType);
        if (holder == null) {
            if (WXEnvironment.isApkDebugable()) {
                String tag = "WXComponentFactory error type:[" + basicComponentData.mComponentType + "] class not found";
                WXLogUtils.e(tag);
            }
            if ((holder = WXComponentRegistry.getComponent("container")) == null) {
                WXExceptionUtils.commitCriticalExceptionRT(instance.getInstanceId(), WXErrorCode.WX_RENDER_ERR_COMPONENT_NOT_REGISTER, "createComponent", basicComponentData.mComponentType + " not registered", null);
                return null;
            }
        }
        try {
            return holder.createInstance(instance, parent, basicComponentData);
        }
        catch (Throwable e) {
            WXLogUtils.e("WXComponentFactory Exception type:[" + basicComponentData.mComponentType + "] ", e);
            return null;
        }
    }
}

