/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.ui.action;

import android.support.annotation.NonNull;
import android.widget.ScrollView;
import java.util.Map;
import java.util.Set;
import org.apache.weex.WXSDKInstance;
import org.apache.weex.common.WXRenderStrategy;
import org.apache.weex.dom.transition.WXTransition;
import org.apache.weex.ui.action.BasicComponentData;
import org.apache.weex.ui.action.GraphicActionAbstractAddElement;
import org.apache.weex.ui.component.WXComponent;
import org.apache.weex.ui.component.WXScroller;
import org.apache.weex.utils.WXLogUtils;

public class GraphicActionCreateBody
extends GraphicActionAbstractAddElement {
    private WXComponent component;

    public GraphicActionCreateBody(@NonNull WXSDKInstance instance, String ref, String componentType, Map<String, String> style, Map<String, String> attributes, Set<String> events, float[] margins, float[] paddings, float[] borders) {
        super(instance, ref);
        this.mComponentType = componentType;
        this.mStyle = style;
        this.mAttributes = attributes;
        this.mEvents = events;
        this.mMargins = margins;
        this.mPaddings = paddings;
        this.mBorders = borders;
        if (instance.getContext() == null) {
            return;
        }
        BasicComponentData basicComponentData = new BasicComponentData(this.getRef(), this.mComponentType, null);
        this.component = this.createComponent(instance, null, basicComponentData);
        if (this.component == null) {
            return;
        }
        this.component.setTransition(WXTransition.fromMap(this.component.getStyles(), this.component));
    }

    @Override
    public void executeAction() {
        super.executeAction();
        try {
            WXScroller scroller;
            this.component.createView();
            this.component.applyLayoutAndEvent(this.component);
            this.component.bindData(this.component);
            WXSDKInstance instance = this.getWXSDKIntance();
            if (this.component instanceof WXScroller && (scroller = (WXScroller)this.component).getInnerView() instanceof ScrollView) {
                instance.setRootScrollView((ScrollView)scroller.getInnerView());
            }
            instance.onRootCreated(this.component);
            if (instance.getRenderStrategy() != WXRenderStrategy.APPEND_ONCE) {
                instance.onCreateFinish();
            }
        }
        catch (Exception e) {
            WXLogUtils.e("create body failed.", e);
        }
    }
}

