/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.ui;

import android.util.Pair;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.weex.WXEnvironment;
import org.apache.weex.WXSDKInstance;
import org.apache.weex.annotation.Component;
import org.apache.weex.annotation.JSMethod;
import org.apache.weex.bridge.Invoker;
import org.apache.weex.bridge.MethodInvoker;
import org.apache.weex.common.WXErrorCode;
import org.apache.weex.common.WXRuntimeException;
import org.apache.weex.ui.ComponentCreator;
import org.apache.weex.ui.IFComponentHolder;
import org.apache.weex.ui.action.BasicComponentData;
import org.apache.weex.ui.component.WXComponent;
import org.apache.weex.ui.component.WXComponentProp;
import org.apache.weex.ui.component.WXVContainer;
import org.apache.weex.utils.WXExceptionUtils;
import org.apache.weex.utils.WXLogUtils;

public class SimpleComponentHolder
implements IFComponentHolder {
    public static final String TAG = "SimpleComponentHolder";
    private final Class<? extends WXComponent> mClz;
    private Map<String, Invoker> mPropertyInvokers;
    private Map<String, Invoker> mMethodInvokers;
    private ComponentCreator mCreator;

    public SimpleComponentHolder(Class<? extends WXComponent> clz) {
        this(clz, new ClazzComponentCreator(clz));
    }

    public SimpleComponentHolder(Class<? extends WXComponent> clz, ComponentCreator customCreator) {
        this.mClz = clz;
        this.mCreator = customCreator;
    }

    @Override
    public void loadIfNonLazy() {
        Annotation[] annotations;
        for (Annotation annotation : annotations = this.mClz.getDeclaredAnnotations()) {
            if (!(annotation instanceof Component)) continue;
            if (!((Component)annotation).lazyload() && this.mMethodInvokers == null) {
                this.generate();
            }
            return;
        }
    }

    private synchronized void generate() {
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d(TAG, "Generate Component:" + this.mClz.getSimpleName());
        }
        Pair<Map<String, Invoker>, Map<String, Invoker>> methodPair = SimpleComponentHolder.getMethods(this.mClz);
        this.mPropertyInvokers = (Map)methodPair.first;
        this.mMethodInvokers = (Map)methodPair.second;
    }

    public static Pair<Map<String, Invoker>, Map<String, Invoker>> getMethods(Class clz) {
        HashMap<String, MethodInvoker> methods = new HashMap<String, MethodInvoker>();
        HashMap<String, MethodInvoker> mInvokers = new HashMap<String, MethodInvoker>();
        try {
            block5: for (Method method : clz.getMethods()) {
                try {
                    for (Annotation anno : method.getDeclaredAnnotations()) {
                        if (anno == null) continue;
                        if (anno instanceof WXComponentProp) {
                            String name = ((WXComponentProp)anno).name();
                            methods.put(name, new MethodInvoker(method, true));
                            continue block5;
                        }
                        if (!(anno instanceof JSMethod)) continue;
                        JSMethod methodAnno = (JSMethod)anno;
                        String name = methodAnno.alias();
                        if ("_".equals(name)) {
                            name = method.getName();
                        }
                        mInvokers.put(name, new MethodInvoker(method, methodAnno.uiThread()));
                        continue block5;
                    }
                }
                catch (ArrayIndexOutOfBoundsException | IncompatibleClassChangeError throwable) {
                    // empty catch block
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            WXLogUtils.e(TAG, e);
        }
        return new Pair(methods, mInvokers);
    }

    @Override
    public synchronized WXComponent createInstance(WXSDKInstance instance, WXVContainer parent, BasicComponentData basicComponentData) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        WXComponent component = this.mCreator.createInstance(instance, parent, basicComponentData);
        component.bindHolder(this);
        return component;
    }

    @Override
    public synchronized Invoker getPropertyInvoker(String name) {
        if (this.mPropertyInvokers == null) {
            this.generate();
        }
        return this.mPropertyInvokers.get(name);
    }

    @Override
    public Invoker getMethodInvoker(String name) {
        if (this.mMethodInvokers == null) {
            this.generate();
        }
        return this.mMethodInvokers.get(name);
    }

    @Override
    public synchronized String[] getMethods() {
        if (this.mMethodInvokers == null) {
            this.generate();
        }
        Set<String> keys = this.mMethodInvokers.keySet();
        try {
            return keys.toArray(new String[keys.size()]);
        }
        catch (Throwable throwable) {
            if (this.mClz != null) {
                String name = this.mClz.getName();
                String errorMsg = name + ": gen methods failed";
                WXExceptionUtils.commitCriticalExceptionRT(null, WXErrorCode.WX_KEY_EXCEPTION_INVOKE_REGISTER_COMPONENT, "registerComponents", errorMsg, null);
            }
            return new String[1];
        }
    }

    public static class ClazzComponentCreator
    implements ComponentCreator {
        private Constructor<? extends WXComponent> mConstructor;
        private final Class<? extends WXComponent> mCompClz;

        public ClazzComponentCreator(Class<? extends WXComponent> c) {
            this.mCompClz = c;
        }

        private void loadConstructor() {
            Constructor<? extends WXComponent> constructor;
            Class<? extends WXComponent> c = this.mCompClz;
            try {
                constructor = c.getConstructor(WXSDKInstance.class, WXVContainer.class, BasicComponentData.class);
            }
            catch (NoSuchMethodException e) {
                WXLogUtils.d("ClazzComponentCreator", "Use deprecated component constructor");
                try {
                    constructor = c.getConstructor(WXSDKInstance.class, WXVContainer.class, Boolean.TYPE, BasicComponentData.class);
                }
                catch (NoSuchMethodException e1) {
                    try {
                        constructor = c.getConstructor(WXSDKInstance.class, WXVContainer.class, String.class, Boolean.TYPE, BasicComponentData.class);
                    }
                    catch (NoSuchMethodException e2) {
                        throw new WXRuntimeException("Can't find constructor of component.");
                    }
                }
            }
            this.mConstructor = constructor;
        }

        @Override
        public WXComponent createInstance(WXSDKInstance instance, WXVContainer parent, BasicComponentData basicComponentData) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            int parameters;
            if (this.mConstructor == null) {
                this.loadConstructor();
            }
            WXComponent component = (parameters = this.mConstructor.getParameterTypes().length) == 3 ? this.mConstructor.newInstance(instance, parent, basicComponentData) : (parameters == 4 ? this.mConstructor.newInstance(instance, parent, false, basicComponentData) : this.mConstructor.newInstance(instance, parent, instance.getInstanceId(), parent.isLazy()));
            return component;
        }
    }
}

