/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.tracing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.weex.tracing.WXTracing;
import org.apache.weex.utils.WXLogUtils;

public class Stopwatch {
    private static final ThreadLocal<Stopwatch> sThreadLocal = new ThreadLocal();
    private long startNanos;
    private List<ProcessEvent> splits = new ArrayList<ProcessEvent>();
    private long startMillis;

    private static void prepare() {
        if (sThreadLocal.get() == null) {
            sThreadLocal.set(new Stopwatch());
        }
    }

    public static void tick() {
        if (WXTracing.isAvailable()) {
            try {
                Stopwatch.prepare();
                if (Stopwatch.sThreadLocal.get().startNanos != 0L) {
                    WXLogUtils.w("Stopwatch", "Stopwatch is not reset");
                }
                Stopwatch.sThreadLocal.get().startNanos = System.nanoTime();
                Stopwatch.sThreadLocal.get().startMillis = System.currentTimeMillis();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static void split(String fname) {
        if (WXTracing.isAvailable()) {
            try {
                ProcessEvent event = new ProcessEvent();
                long start = Stopwatch.sThreadLocal.get().startMillis;
                double millis = Stopwatch.tackAndTick();
                event.fname = fname;
                event.duration = millis;
                event.startMillis = start;
                Stopwatch.sThreadLocal.get().splits.add(event);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static List<ProcessEvent> getProcessEvents() {
        if (WXTracing.isAvailable()) {
            Stopwatch.tack();
            List<ProcessEvent> existedEvents = Stopwatch.sThreadLocal.get().splits;
            Stopwatch.sThreadLocal.get().splits = new ArrayList<ProcessEvent>();
            return existedEvents;
        }
        return Collections.emptyList();
    }

    public static double tack() {
        if (WXTracing.isAvailable()) {
            try {
                long startNanos = Stopwatch.sThreadLocal.get().startNanos;
                if (startNanos == 0L) {
                    WXLogUtils.w("Stopwatch", "Should call Stopwatch.tick() before Stopwatch.tack() called");
                }
                long nanos = System.nanoTime() - startNanos;
                Stopwatch.sThreadLocal.get().startNanos = 0L;
                return Stopwatch.nanosToMillis(nanos);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return -1.0;
    }

    public static long lastTickStamp() {
        if (WXTracing.isAvailable()) {
            try {
                return Stopwatch.sThreadLocal.get().startMillis;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return -1L;
    }

    public static double tackAndTick() {
        double ms = Stopwatch.tack();
        Stopwatch.tick();
        return ms;
    }

    public static double nanosToMillis(long nanos) {
        return (double)nanos / 1000000.0;
    }

    public static double millisUntilNow(long startNanos) {
        return Stopwatch.nanosToMillis(System.nanoTime() - startNanos);
    }

    public static class ProcessEvent {
        public String fname;
        public double duration;
        public long startMillis;
    }
}

