/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.performance;

import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import org.apache.weex.WXSDKInstance;
import org.apache.weex.WXSDKManager;
import org.apache.weex.adapter.IWXConfigAdapter;
import org.apache.weex.utils.WXViewUtils;
import org.json.JSONObject;

public class WhiteScreenUtils {
    public static boolean doWhiteScreenCheck() {
        IWXConfigAdapter configAdapter = WXSDKManager.getInstance().getWxConfigAdapter();
        if (null == configAdapter) {
            return false;
        }
        double randomValue = Math.random() * 100.0;
        double max = 100.0;
        try {
            String configValue = configAdapter.getConfig("wxapm", "new_ws_sampling", "100");
            max = Double.valueOf(configValue);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return randomValue < max;
    }

    public static boolean isWhiteScreen(WXSDKInstance instance) {
        if (null == instance) {
            return false;
        }
        View v = instance.getContainerView();
        if (!(v instanceof ViewGroup)) {
            return false;
        }
        if (!WXViewUtils.isViewVisible(v) || !WhiteScreenUtils.checkParentVisible(v.getParent())) {
            return false;
        }
        if (WhiteScreenUtils.isInWhiteList(instance)) {
            return false;
        }
        return !WhiteScreenUtils.hasLeafViewOrSizeIgnore(v, 3);
    }

    private static boolean isInWhiteList(WXSDKInstance instance) {
        IWXConfigAdapter configAdapter = WXSDKManager.getInstance().getWxConfigAdapter();
        if (null == configAdapter) {
            return false;
        }
        String whiteList = configAdapter.getConfig("wxapm", "ws_white_list", null);
        if (TextUtils.isEmpty((CharSequence)whiteList)) {
            return false;
        }
        try {
            String[] urlList;
            for (String whiteUrl : urlList = whiteList.split(";")) {
                if (instance.getBundleUrl() == null || !instance.getBundleUrl().contains(whiteUrl)) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static boolean checkParentVisible(ViewParent parent) {
        boolean visible;
        if (!(parent instanceof View)) {
            return true;
        }
        View vp = (View)parent;
        boolean bl = visible = vp.getVisibility() == 0 && vp.getAlpha() > 0.0f;
        if (!visible) {
            return false;
        }
        return WhiteScreenUtils.checkParentVisible(vp.getParent());
    }

    private static boolean hasLeafViewOrSizeIgnore(View v, int checkDeep) {
        if (!(v instanceof ViewGroup)) {
            return true;
        }
        if (checkDeep > 0) {
            if (v.getHeight() < 10 || v.getWidth() < 10) {
                return true;
            }
            --checkDeep;
        }
        ViewGroup group = (ViewGroup)v;
        for (int i = 0; i < group.getChildCount(); ++i) {
            View child = group.getChildAt(i);
            boolean res = WhiteScreenUtils.hasLeafViewOrSizeIgnore(child, checkDeep);
            if (!res) continue;
            return true;
        }
        return false;
    }

    public static String takeViewTreeSnapShot(WXSDKInstance instance) {
        if (null == instance) {
            return "nullInstance";
        }
        View v = instance.getContainerView();
        JSONObject root = WhiteScreenUtils.geViewDetailTreeMsg(v);
        if (null != root) {
            return root.toString();
        }
        return "";
    }

    private static JSONObject geViewDetailTreeMsg(View view) {
        if (null == view) {
            return null;
        }
        JSONObject node = new JSONObject();
        try {
            node.put("width", view.getWidth());
            node.put("height", view.getHeight());
            int[] location = new int[]{-1, -1};
            view.getLocationOnScreen(location);
            node.put("x", location[0]);
            node.put("y", location[1]);
            if (view instanceof ViewGroup) {
                node.put("type", (Object)view.getClass().getSimpleName());
                ViewGroup group = (ViewGroup)view;
                for (int i = 0; i < group.getChildCount(); ++i) {
                    node.put("child_" + i, (Object)WhiteScreenUtils.geViewDetailTreeMsg(group.getChildAt(i)));
                }
            } else {
                node.put("type", (Object)view.getClass().getSimpleName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return node;
    }
}

