/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.performance;

import android.support.annotation.NonNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.weex.WXSDKManager;
import org.apache.weex.adapter.IWXConfigAdapter;
import org.apache.weex.bridge.WXBridgeManager;
import org.apache.weex.utils.WXUtils;

public class WXStateRecord {
    private RecordList<Info> mExceptionHistory;
    private RecordList<Info> mActionHistory;
    private RecordList<Info> mJsfmInitHistory;
    private RecordList<Info> mJscCrashHistory;
    private RecordList<Info> mJscReloadHistory;
    private RecordList<Info> mJsThradWatchHistory;
    private RecordList<Info> mIPCExceptionHistory;
    private long jsThreadTime = -1L;
    private Runnable jsThreadWatchTask = new Runnable(){

        @Override
        public void run() {
            if (WXStateRecord.this.jsThreadTime == -1L) {
                WXStateRecord.this.jsThreadTime = WXUtils.getFixUnixTime();
            }
            long diff = WXUtils.getFixUnixTime() - WXStateRecord.this.jsThreadTime;
            WXStateRecord.this.recordJsThreadWatch("diff:" + diff);
            WXStateRecord.this.jsThreadTime = WXUtils.getFixUnixTime();
            WXBridgeManager.getInstance().postDelay(WXStateRecord.this.jsThreadWatchTask, 500L);
        }
    };

    public static WXStateRecord getInstance() {
        return SingleTonHolder.S_INSTANCE;
    }

    private WXStateRecord() {
        this.mExceptionHistory = new RecordList(10);
        this.mActionHistory = new RecordList(20);
        this.mJsfmInitHistory = new RecordList(10);
        this.mJscCrashHistory = new RecordList(10);
        this.mJscReloadHistory = new RecordList(10);
        this.mJsThradWatchHistory = new RecordList(20);
        this.mIPCExceptionHistory = new RecordList(20);
    }

    public void recordException(String instanceId, String exception) {
        String shortException = exception.length() > 200 ? exception.substring(0, 200) : exception;
        this.recordCommon(this.mExceptionHistory, new Info(WXUtils.getFixUnixTime(), instanceId, shortException));
    }

    public void recordAction(String instanceId, String action) {
        this.recordCommon(this.mActionHistory, new Info(WXUtils.getFixUnixTime(), instanceId, action));
    }

    public void recordIPCException(String instanceId, String exception) {
        String shortException = exception.length() > 200 ? exception.substring(0, 200) : exception;
        this.recordCommon(this.mIPCExceptionHistory, new Info(WXUtils.getFixUnixTime(), instanceId, shortException));
    }

    public void onJSFMInit() {
        this.recoreJsfmInitHistory("setJsfmVersion");
    }

    public void recoreJsfmInitHistory(String msg) {
        this.recordCommon(this.mJsfmInitHistory, new Info(WXUtils.getFixUnixTime(), "JSFM", msg));
    }

    public void recordJsThreadWatch(String msg) {
        this.recordCommon(this.mJsThradWatchHistory, new Info(WXUtils.getFixUnixTime(), "jsWatch", msg));
    }

    public void onJSEngineReload(String instanceId) {
        this.recordCommon(this.mJscReloadHistory, new Info(WXUtils.getFixUnixTime(), instanceId, "onJSEngineReload"));
    }

    public void onJSCCrash(String instanceId) {
        this.recordCommon(this.mJscCrashHistory, new Info(WXUtils.getFixUnixTime(), instanceId, "onJSCCrash"));
    }

    private void recordCommon(RecordList<Info> list, Info info) {
        if (null == list || null == info) {
            return;
        }
        try {
            list.add(info);
            if (!list.isEmpty() && list.size() > ((RecordList)list).maxSize) {
                list.poll();
            }
        }
        catch (Throwable e) {
            e.getStackTrace();
        }
    }

    public Map<String, String> getStateInfo() {
        HashMap<String, String> stateInfo = new HashMap<String, String>(5);
        stateInfo.put("reInitCount", String.valueOf(WXBridgeManager.reInitCount));
        int size = this.mExceptionHistory.size() + this.mActionHistory.size() + this.mJsfmInitHistory.size() + this.mJscCrashHistory.size() + this.mJscReloadHistory.size() + this.mJsThradWatchHistory.size();
        ArrayList<Info> reportTimeLineInfo = new ArrayList<Info>(size);
        reportTimeLineInfo.addAll(this.mExceptionHistory);
        reportTimeLineInfo.addAll(this.mActionHistory);
        reportTimeLineInfo.addAll(this.mJsfmInitHistory);
        reportTimeLineInfo.addAll(this.mJscCrashHistory);
        reportTimeLineInfo.addAll(this.mJscReloadHistory);
        reportTimeLineInfo.addAll(this.mJsThradWatchHistory);
        reportTimeLineInfo.addAll(this.mIPCExceptionHistory);
        Collections.sort(reportTimeLineInfo);
        stateInfo.put("stateInfoList", ((Object)reportTimeLineInfo).toString());
        IWXConfigAdapter adapter = WXSDKManager.getInstance().getWxConfigAdapter();
        if (null != adapter && "true".equalsIgnoreCase(adapter.getConfig("wxapm", "dumpIpcPageInfo", "true"))) {
            stateInfo.put("pageQueueInfo", WXBridgeManager.getInstance().dumpIpcPageInfo());
        }
        return stateInfo;
    }

    public void startJSThreadWatchDog() {
        WXBridgeManager.getInstance().post(this.jsThreadWatchTask);
    }

    private static class Info
    implements Comparable<Info> {
        private long time;
        private String instanceId;
        private String msg;

        public Info(long time, String instance, String msg) {
            this.time = time;
            this.instanceId = instance;
            this.msg = msg;
        }

        public String toString() {
            return '[' + this.instanceId + ',' + this.time + ',' + this.msg + "]->";
        }

        @Override
        public int compareTo(@NonNull Info next) {
            if (this.time == next.time) {
                return 0;
            }
            return this.time > next.time ? 1 : -1;
        }
    }

    private static class RecordList<E>
    extends ConcurrentLinkedQueue<E> {
        private int maxSize;

        public RecordList(int maxSize) {
            this.maxSize = maxSize;
        }
    }

    private static class SingleTonHolder {
        private static final WXStateRecord S_INSTANCE = new WXStateRecord();

        private SingleTonHolder() {
        }
    }
}

