/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.http;

import java.util.HashMap;
import java.util.Map;

class Options {
    private String method;
    private String url;
    private Map<String, String> headers;
    private String body;
    private Type type = Type.text;
    private int timeout = 3000;

    private Options(String method, String url, Map<String, String> headers, String body, Type type, int timeout) {
        this.method = method;
        this.url = url;
        this.headers = headers;
        this.body = body;
        this.type = type;
        if (timeout == 0) {
            timeout = 3000;
        }
        this.timeout = timeout;
    }

    public String getMethod() {
        return this.method;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getBody() {
        return this.body;
    }

    public Type getType() {
        return this.type;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public static class Builder {
        private String method;
        private String url;
        private Map<String, String> headers = new HashMap<String, String>();
        private String body;
        private Type type;
        private int timeout;

        public Builder setMethod(String method) {
            this.method = method;
            return this;
        }

        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder putHeader(String key, String value) {
            this.headers.put(key, value);
            return this;
        }

        public Builder setBody(String body) {
            this.body = body;
            return this;
        }

        public Builder setType(String type) {
            this.type = Type.json.name().equals(type) ? Type.json : (Type.jsonp.name().equals(type) ? Type.jsonp : Type.text);
            return this;
        }

        public Builder setType(Type type) {
            this.type = type;
            return this;
        }

        public Builder setTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public Options createOptions() {
            return new Options(this.method, this.url, this.headers, this.body, this.type, this.timeout);
        }
    }

    public static enum Type {
        json,
        text,
        jsonp;

    }
}

