/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.el.parse;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.apache.weex.el.parse.ArrayStack;
import org.apache.weex.el.parse.Token;

public class Operators {
    public static final char BRACKET_END = ')';
    public static final String BRACKET_END_STR = ")";
    public static final char BRACKET_START = '(';
    public static final String BRACKET_START_STR = "(";
    public static final char QUOTE = '\"';
    public static final char SINGLE_QUOTE = '\'';
    public static final char DOT = '.';
    public static final String DOT_STR = ".";
    public static final char ARRAY_START = '[';
    public static final String ARRAY_START_STR = "[";
    public static final char ARRAY_SEPRATOR = ',';
    public static final String ARRAY_SEPRATOR_STR = ",";
    public static final char ARRAY_END = ']';
    public static final String ARRAY_END_STR = "]";
    public static final String SPACE_STR = " ";
    public static final char SPACE = ' ';
    public static final char BLOCK_START = '{';
    public static final String BLOCK_START_STR = "{";
    public static final char BLOCK_END = '}';
    public static final String BLOCK_END_STR = "}";
    public static final char DOLLAR = '$';
    public static final String DOLLAR_STR = "$";
    public static final char CONDITION_IF = '?';
    public static final String CONDITION_IF_STRING = "?";
    public static final char CONDITION_IF_MIDDLE = ':';
    public static final String PLUS = "+";
    public static final String SUB = "-";
    public static final String MUL = "*";
    public static final String DIV = "/";
    public static final String MOD = "%";
    public static final String AND = "&&";
    public static final String OR = "||";
    public static final String EQUAL = "===";
    public static final String EQUAL2 = "==";
    public static final String NOT_EQUAL = "!==";
    public static final String NOT_EQUAL2 = "!=";
    public static final String AND_NOT = "!";
    public static final String G = ">";
    public static final String GE = ">=";
    public static final String LE = "<=";
    public static final String L = "<";
    public static Map<String, Integer> OPERATORS_PRIORITY = new HashMap<String, Integer>();
    public static final Map<String, Object> KEYWORDS;

    public static Object dot(Token left, Token right, Object context) {
        if (left == null || right == null) {
            return null;
        }
        Object leftValue = left.execute(context);
        if (leftValue == null) {
            return null;
        }
        Object value = null;
        if (right.getType() != 0) {
            Object identifter = right.execute(context);
            if (identifter instanceof Double) {
                identifter = ((Double)identifter).intValue();
            }
            String key = identifter == null ? "" : identifter.toString().trim();
            value = Operators.el(leftValue, key);
        } else {
            value = right.execute(leftValue);
        }
        if (value != null) {
            return value;
        }
        return Operators.specialKey(leftValue, right.getToken());
    }

    public static Object el(Object context, String key) {
        Map map;
        Object value;
        int index;
        Object stack;
        if (context == null) {
            return null;
        }
        if (context instanceof ArrayStack) {
            stack = (ArrayStack)context;
            for (index = ((ArrayStack)stack).size() - 1; index >= 0; --index) {
                value = ((ArrayStack)stack).get(index);
                if (!(value instanceof Map) || !(map = (Map)value).containsKey(key)) continue;
                return map.get(key);
            }
        }
        if (context instanceof Stack) {
            stack = (Stack)context;
            for (index = ((Vector)stack).size() - 1; index >= 0; --index) {
                value = ((Vector)stack).get(index);
                if (!(value instanceof Map) || !(map = (Map)value).containsKey(key)) continue;
                return map.get(key);
            }
        }
        if (context instanceof Map) {
            return ((Map)context).get(key);
        }
        if (context instanceof List) {
            List list = (List)context;
            try {
                return list.get(Integer.parseInt(key));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (context.getClass().isArray()) {
            try {
                return Array.get(context, Integer.parseInt(key));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Object specialKey(Object leftValue, String key) {
        if ("length".equals(key)) {
            if (leftValue instanceof CharSequence) {
                return ((CharSequence)leftValue).length();
            }
            if (leftValue instanceof Map) {
                return ((Map)leftValue).size();
            }
            if (leftValue instanceof Map) {
                return ((Map)leftValue).size();
            }
            if (leftValue instanceof List) {
                return ((List)leftValue).size();
            }
            if (leftValue.getClass().isArray()) {
                return Array.getLength(leftValue);
            }
        }
        return null;
    }

    public static Object plus(Token left, Token right, Object context) {
        Object leftValue = null;
        Object rightValue = null;
        if (left != null) {
            leftValue = left.execute(context);
        }
        if (right != null) {
            rightValue = right.execute(context);
        }
        if (leftValue instanceof CharSequence || rightValue instanceof CharSequence) {
            if (leftValue == null) {
                return rightValue;
            }
            return leftValue.toString() + (rightValue == null ? "" : rightValue.toString());
        }
        if (leftValue instanceof Number || rightValue instanceof Number) {
            return Operators.getNumber(leftValue) + Operators.getNumber(rightValue);
        }
        if (leftValue == null && rightValue == null) {
            return null;
        }
        if (leftValue == null) {
            return rightValue.toString();
        }
        return leftValue.toString() + (rightValue == null ? "" : rightValue.toString());
    }

    public static Object sub(Token left, Token right, Object context) {
        Object leftValue = null;
        Object rightValue = null;
        if (left != null) {
            leftValue = left.execute(context);
        }
        if (right != null) {
            rightValue = right.execute(context);
        }
        return Operators.getNumber(leftValue) - Operators.getNumber(rightValue);
    }

    public static Object div(Token left, Token right, Object context) {
        Object leftValue = null;
        Object rightValue = null;
        if (left != null) {
            leftValue = left.execute(context);
        }
        if (right != null) {
            rightValue = right.execute(context);
        }
        return Operators.getNumber(leftValue) / Operators.getNumber(rightValue);
    }

    public static Object mul(Token left, Token right, Object context) {
        Object leftValue = null;
        Object rightValue = null;
        if (left != null) {
            leftValue = left.execute(context);
        }
        if (right != null) {
            rightValue = right.execute(context);
        }
        return Operators.getNumber(leftValue) * Operators.getNumber(rightValue);
    }

    public static Object mod(Token left, Token right, Object context) {
        Object leftValue = null;
        Object rightValue = null;
        if (left != null) {
            leftValue = left.execute(context);
        }
        if (right != null) {
            rightValue = right.execute(context);
        }
        return Operators.getNumber(leftValue) % Operators.getNumber(rightValue);
    }

    public static Object condition(Token selfs, Token first, Token second, Object context) {
        boolean value = false;
        if (selfs != null) {
            value = Operators.isTrue(selfs.execute(context));
        }
        if (value) {
            if (first != null) {
                return first.execute(context);
            }
        } else if (second != null) {
            return second.execute(context);
        }
        return null;
    }

    public static boolean tokenTrue(Token selfs, Object context) {
        if (selfs == null) {
            return false;
        }
        Object value = selfs.execute(context);
        return Operators.isTrue(value);
    }

    public static double tokenNumber(Token self, Object context) {
        if (self == null) {
            return 0.0;
        }
        Object value = self.execute(context);
        return Operators.getNumber(value);
    }

    public static boolean isEquals(Token left, Token right, Object context) {
        if (left == null && right == null) {
            return true;
        }
        Object leftValue = null;
        if (left != null) {
            leftValue = left.execute(context);
        }
        Object rightValue = null;
        if (right != null) {
            rightValue = right.execute(context);
        }
        if (leftValue == null) {
            if (rightValue == null) {
                return true;
            }
            return rightValue instanceof CharSequence && Operators.isEmpty(rightValue.toString());
        }
        if (rightValue == null) {
            return Operators.isEmpty(leftValue.toString());
        }
        if (leftValue instanceof Number) {
            if (rightValue instanceof Number) {
                return ((Number)leftValue).doubleValue() == ((Number)rightValue).doubleValue();
            }
            return ((Number)leftValue).doubleValue() == Operators.getNumber(rightValue);
        }
        if (rightValue instanceof Number) {
            return Operators.getNumber(leftValue) == ((Number)rightValue).doubleValue();
        }
        if (leftValue instanceof CharSequence || rightValue instanceof CharSequence) {
            return leftValue.toString().trim().equals(rightValue.toString().trim());
        }
        return leftValue.equals(rightValue);
    }

    public static boolean isTrue(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue() != 0.0;
        }
        String bool2 = value.toString().trim();
        if ("false".equals(bool2) || "undefined".equals(bool2) || "null".equals(bool2)) {
            return false;
        }
        return !Operators.isEmpty(bool2);
    }

    public static boolean isEmpty(String value) {
        if (value == null) {
            return true;
        }
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    public static double getNumber(Object value) {
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        try {
            return Double.parseDouble(value.toString());
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public static boolean isOpEnd(String op) {
        return Operators.isOpEnd(op.charAt(0));
    }

    public static boolean isOpEnd(char op) {
        return op == ')' || op == ']' || op == ' ' || op == ',';
    }

    public static boolean isDot(String opStr) {
        char op = opStr.charAt(0);
        return op == '.' || op == '[';
    }

    static {
        OPERATORS_PRIORITY.put(BLOCK_END_STR, 0);
        OPERATORS_PRIORITY.put(BRACKET_END_STR, 0);
        OPERATORS_PRIORITY.put(SPACE_STR, 0);
        OPERATORS_PRIORITY.put(ARRAY_SEPRATOR_STR, 0);
        OPERATORS_PRIORITY.put(ARRAY_END_STR, 0);
        OPERATORS_PRIORITY.put(OR, 1);
        OPERATORS_PRIORITY.put(AND, 1);
        OPERATORS_PRIORITY.put(EQUAL, 2);
        OPERATORS_PRIORITY.put(EQUAL2, 2);
        OPERATORS_PRIORITY.put(NOT_EQUAL, 2);
        OPERATORS_PRIORITY.put(NOT_EQUAL2, 2);
        OPERATORS_PRIORITY.put(G, 7);
        OPERATORS_PRIORITY.put(GE, 7);
        OPERATORS_PRIORITY.put(L, 7);
        OPERATORS_PRIORITY.put(LE, 8);
        OPERATORS_PRIORITY.put(PLUS, 9);
        OPERATORS_PRIORITY.put(SUB, 9);
        OPERATORS_PRIORITY.put(MUL, 10);
        OPERATORS_PRIORITY.put(DIV, 10);
        OPERATORS_PRIORITY.put(MOD, 10);
        OPERATORS_PRIORITY.put(AND_NOT, 11);
        OPERATORS_PRIORITY.put(DOT_STR, 15);
        OPERATORS_PRIORITY.put(ARRAY_START_STR, 16);
        OPERATORS_PRIORITY.put(BRACKET_START_STR, 17);
        OPERATORS_PRIORITY.put(BLOCK_START_STR, 17);
        KEYWORDS = new HashMap<String, Object>();
        KEYWORDS.put("null", null);
        KEYWORDS.put("true", Boolean.TRUE);
        KEYWORDS.put("false", Boolean.FALSE);
        KEYWORDS.put("undefined", null);
    }
}

