/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.dom.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ArgbEvaluator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.graphics.drawable.ColorDrawable;
import android.os.Handler;
import android.support.v4.util.ArrayMap;
import android.support.v4.view.animation.PathInterpolatorCompat;
import android.text.TextUtils;
import android.util.Property;
import android.view.View;
import android.view.animation.Interpolator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.weex.WXEnvironment;
import org.apache.weex.WXSDKManager;
import org.apache.weex.bridge.WXBridgeManager;
import org.apache.weex.dom.CSSShorthand;
import org.apache.weex.ui.animation.BackgroundColorProperty;
import org.apache.weex.ui.animation.TransformParser;
import org.apache.weex.ui.component.WXComponent;
import org.apache.weex.utils.SingleFunctionParser;
import org.apache.weex.utils.WXLogUtils;
import org.apache.weex.utils.WXResourceUtils;
import org.apache.weex.utils.WXUtils;
import org.apache.weex.utils.WXViewUtils;

public class WXTransition {
    public static final String TRANSITION_PROPERTY = "transitionProperty";
    public static final String TRANSITION_DURATION = "transitionDuration";
    public static final String TRANSITION_DELAY = "transitionDelay";
    public static final String TRANSITION_TIMING_FUNCTION = "transitionTimingFunction";
    public static final Pattern PROPERTY_SPLIT_PATTERN = Pattern.compile("\\||,");
    private static final Set<String> LAYOUT_PROPERTIES = new HashSet<String>();
    private static final Set<String> TRANSFORM_PROPERTIES;
    private List<String> properties;
    private Interpolator interpolator;
    private long duration;
    private long delay;
    private WXComponent mWXComponent;
    private Handler handler;
    private ValueAnimator layoutValueAnimator;
    private Map<String, Object> layoutPendingUpdates;
    private ObjectAnimator transformAnimator;
    private Map<String, Object> transformPendingUpdates;
    private Runnable transitionEndEvent;
    private Map<String, Object> targetStyles;
    private Runnable animationRunnable;
    private Runnable transformAnimationRunnable;
    private volatile AtomicInteger lockToken = new AtomicInteger(0);

    public WXTransition() {
        this.properties = new ArrayList<String>(4);
        this.handler = new Handler();
        this.layoutPendingUpdates = new ArrayMap();
        this.transformPendingUpdates = new ArrayMap();
        this.targetStyles = new ArrayMap();
    }

    public static WXTransition fromMap(Map<String, Object> style, WXComponent component) {
        if (style.get(TRANSITION_PROPERTY) == null) {
            return null;
        }
        String propertyString = WXUtils.getString(style.get(TRANSITION_PROPERTY), null);
        if (propertyString == null) {
            return null;
        }
        WXTransition transition = new WXTransition();
        WXTransition.updateTransitionProperties(transition, propertyString);
        if (transition.properties.isEmpty()) {
            return null;
        }
        transition.duration = WXTransition.parseTimeMillis(style, TRANSITION_DURATION, 0L);
        transition.delay = WXTransition.parseTimeMillis(style, TRANSITION_DELAY, 0L);
        transition.interpolator = WXTransition.createTimeInterpolator(WXUtils.getString(style.get(TRANSITION_TIMING_FUNCTION), null));
        transition.mWXComponent = component;
        return transition;
    }

    public boolean hasTransitionProperty(Map<String, Object> styles) {
        for (String property : this.properties) {
            if (!styles.containsKey(property)) continue;
            return true;
        }
        return false;
    }

    public void updateTranstionParams(Map<String, Object> updates) {
        if (updates.containsKey(TRANSITION_DELAY)) {
            this.mWXComponent.getStyles().put(TRANSITION_DELAY, updates.remove(TRANSITION_DELAY));
            this.delay = WXTransition.parseTimeMillis(this.mWXComponent.getStyles(), TRANSITION_DELAY, 0L);
        }
        if (updates.containsKey(TRANSITION_TIMING_FUNCTION) && updates.get(TRANSITION_TIMING_FUNCTION) != null) {
            this.mWXComponent.getStyles().put(TRANSITION_TIMING_FUNCTION, updates.remove(TRANSITION_TIMING_FUNCTION));
            this.interpolator = WXTransition.createTimeInterpolator(this.mWXComponent.getStyles().get(TRANSITION_TIMING_FUNCTION).toString());
        }
        if (updates.containsKey(TRANSITION_DURATION)) {
            this.mWXComponent.getStyles().put(TRANSITION_DURATION, updates.remove(TRANSITION_DURATION));
            this.duration = WXTransition.parseTimeMillis(this.mWXComponent.getStyles(), TRANSITION_DURATION, 0L);
        }
        if (updates.containsKey(TRANSITION_PROPERTY)) {
            this.mWXComponent.getStyles().put(TRANSITION_PROPERTY, updates.remove(TRANSITION_PROPERTY));
            WXTransition.updateTransitionProperties(this, WXUtils.getString(this.mWXComponent.getStyles().get(TRANSITION_PROPERTY), null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTransition(Map<String, Object> updates) {
        AtomicInteger atomicInteger = this.lockToken;
        synchronized (atomicInteger) {
            View taregtView = this.getTargetView();
            if (taregtView == null) {
                return;
            }
            final int token = this.lockToken.incrementAndGet();
            for (String property : this.properties) {
                if (!updates.containsKey(property)) continue;
                Object targetValue = updates.remove(property);
                if (LAYOUT_PROPERTIES.contains(property)) {
                    this.layoutPendingUpdates.put(property, targetValue);
                    continue;
                }
                if (!TRANSFORM_PROPERTIES.contains(property)) continue;
                this.transformPendingUpdates.put(property, targetValue);
            }
            int delay = WXUtils.getNumberInt(this.mWXComponent.getAttrs().get("actionDelay"), 16);
            if ((long)delay > this.duration) {
                delay = (int)this.duration;
            }
            if (this.animationRunnable != null) {
                this.handler.removeCallbacks(this.animationRunnable);
            }
            this.animationRunnable = new Runnable(){

                @Override
                public void run() {
                    if (token == WXTransition.this.lockToken.get()) {
                        WXTransition.this.doTransitionAnimation(token);
                    }
                    WXTransition.this.animationRunnable = null;
                }
            };
            if (delay > 0) {
                this.handler.postDelayed(this.animationRunnable, (long)delay);
            } else {
                this.animationRunnable.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTransitionAnimation(final int token) {
        View taregtView = this.getTargetView();
        if (taregtView == null) {
            return;
        }
        if (this.targetStyles.size() > 0) {
            for (String property : this.properties) {
                if (!LAYOUT_PROPERTIES.contains(property) && !TRANSFORM_PROPERTIES.contains(property) || this.layoutPendingUpdates.containsKey(property) || this.transformPendingUpdates.containsKey(property)) continue;
                Map<String, Object> map = this.targetStyles;
                synchronized (map) {
                    if (this.targetStyles.containsKey(property)) {
                        Object targetValue = this.targetStyles.remove(property);
                        this.mWXComponent.getStyles().put(property, targetValue);
                    }
                }
            }
        }
        if (this.transitionEndEvent != null) {
            taregtView.removeCallbacks(this.transitionEndEvent);
        }
        if (this.transitionEndEvent == null && (float)this.duration > Float.MIN_NORMAL) {
            this.transitionEndEvent = new Runnable(){

                @Override
                public void run() {
                    WXTransition.this.transitionEndEvent = null;
                    if ((float)WXTransition.this.duration < Float.MIN_NORMAL) {
                        return;
                    }
                    if (WXTransition.this.mWXComponent != null && WXTransition.this.mWXComponent.getEvents().contains("transitionEnd")) {
                        WXTransition.this.mWXComponent.fireEvent("transitionEnd");
                    }
                }
            };
        }
        if (this.transformAnimationRunnable != null) {
            taregtView.removeCallbacks(this.transformAnimationRunnable);
        }
        this.transformAnimationRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AtomicInteger atomicInteger = WXTransition.this.lockToken;
                synchronized (atomicInteger) {
                    if (token == WXTransition.this.lockToken.get()) {
                        WXTransition.this.doPendingTransformAnimation(token);
                    }
                }
            }
        };
        taregtView.post(this.transformAnimationRunnable);
        this.doPendingLayoutAnimation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPendingTransformAnimation(int token) {
        if (this.transformAnimator != null) {
            this.transformAnimator.cancel();
            this.transformAnimator = null;
        }
        if (this.transformPendingUpdates.size() == 0) {
            return;
        }
        View taregtView = this.getTargetView();
        if (taregtView == null) {
            return;
        }
        ArrayList<PropertyValuesHolder> holders = new ArrayList<PropertyValuesHolder>(8);
        String transform = WXUtils.getString(this.transformPendingUpdates.remove("transform"), null);
        if (!TextUtils.isEmpty((CharSequence)transform)) {
            PropertyValuesHolder[] transformHolders;
            Map<Property<View, Float>, Float> properties = TransformParser.parseTransForm(this.mWXComponent.getInstanceId(), transform, (int)this.mWXComponent.getLayoutWidth(), (int)this.mWXComponent.getLayoutHeight(), this.mWXComponent.getViewPortWidth());
            for (PropertyValuesHolder holder : transformHolders = TransformParser.toHolders(properties)) {
                holders.add(holder);
            }
            Map<String, Object> map = this.targetStyles;
            synchronized (map) {
                this.targetStyles.put("transform", transform);
            }
        }
        for (String property : this.properties) {
            if (!TRANSFORM_PROPERTIES.contains(property) || !this.transformPendingUpdates.containsKey(property)) continue;
            Object object = this.transformPendingUpdates.remove(property);
            Object object2 = this.targetStyles;
            synchronized (object2) {
                this.targetStyles.put(property, object);
            }
            switch (property) {
                case "opacity": {
                    holders.add(PropertyValuesHolder.ofFloat((Property)View.ALPHA, (float[])new float[]{taregtView.getAlpha(), WXUtils.getFloat(object, Float.valueOf(1.0f)).floatValue()}));
                    taregtView.setLayerType(1, null);
                    break;
                }
                case "backgroundColor": {
                    int fromColor = WXResourceUtils.getColor(WXUtils.getString(this.mWXComponent.getStyles().getBackgroundColor(), null), 0);
                    int toColor = WXResourceUtils.getColor(WXUtils.getString(object, null), 0);
                    if (WXViewUtils.getBorderDrawable(taregtView) != null) {
                        fromColor = WXViewUtils.getBorderDrawable(taregtView).getColor();
                    } else if (taregtView.getBackground() instanceof ColorDrawable) {
                        fromColor = ((ColorDrawable)taregtView.getBackground()).getColor();
                    }
                    holders.add(PropertyValuesHolder.ofObject((Property)new BackgroundColorProperty(), (TypeEvaluator)new ArgbEvaluator(), (Object[])new Integer[]{fromColor, toColor}));
                    break;
                }
            }
        }
        if (token == this.lockToken.get()) {
            this.transformPendingUpdates.clear();
        }
        this.transformAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)taregtView, (PropertyValuesHolder[])holders.toArray(new PropertyValuesHolder[holders.size()]));
        this.transformAnimator.setDuration(this.duration);
        if (this.delay > 0L) {
            this.transformAnimator.setStartDelay(this.delay);
        }
        if (this.interpolator != null) {
            this.transformAnimator.setInterpolator((TimeInterpolator)this.interpolator);
        }
        this.transformAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){
            boolean hasCancel = false;

            public void onAnimationCancel(Animator animation) {
                super.onAnimationCancel(animation);
                this.hasCancel = true;
            }

            public void onAnimationEnd(Animator animation) {
                if (this.hasCancel) {
                    return;
                }
                super.onAnimationEnd(animation);
                WXTransition.this.onTransitionAnimationEnd();
            }
        });
        this.transformAnimator.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPendingLayoutAnimation() {
        if (this.layoutValueAnimator != null) {
            this.layoutValueAnimator.cancel();
            this.layoutValueAnimator = null;
        }
        if (this.layoutPendingUpdates.size() == 0) {
            return;
        }
        PropertyValuesHolder[] holders = new PropertyValuesHolder[this.layoutPendingUpdates.size()];
        int index = 0;
        for (String property : this.properties) {
            if (!LAYOUT_PROPERTIES.contains(property) || !this.layoutPendingUpdates.containsKey(property)) continue;
            Object targetValue = this.layoutPendingUpdates.remove(property);
            Map<String, Object> map = this.targetStyles;
            synchronized (map) {
                this.targetStyles.put(property, targetValue);
            }
            holders[index] = this.createLayoutPropertyValueHolder(property, targetValue);
            ++index;
        }
        this.layoutPendingUpdates.clear();
        this.doLayoutPropertyValuesHolderAnimation(holders);
    }

    private PropertyValuesHolder createLayoutPropertyValueHolder(String property, Object value) {
        PropertyValuesHolder holder = null;
        switch (property) {
            case "width": {
                holder = PropertyValuesHolder.ofFloat((String)"width", (float[])new float[]{this.mWXComponent.getLayoutWidth(), WXViewUtils.getRealPxByWidth(WXUtils.getFloat(value, Float.valueOf(0.0f)).floatValue(), this.mWXComponent.getViewPortWidth())});
                break;
            }
            case "height": {
                holder = PropertyValuesHolder.ofFloat((String)"height", (float[])new float[]{this.mWXComponent.getLayoutHeight(), WXViewUtils.getRealPxByWidth(WXUtils.getFloat(value, Float.valueOf(0.0f)).floatValue(), this.mWXComponent.getViewPortWidth())});
                break;
            }
            case "marginTop": {
                holder = PropertyValuesHolder.ofFloat((String)"marginTop", (float[])new float[]{this.mWXComponent.getMargin().get(CSSShorthand.EDGE.TOP), WXViewUtils.getRealPxByWidth(WXUtils.getFloatByViewport(value, this.mWXComponent.getViewPortWidth()), this.mWXComponent.getViewPortWidth())});
                break;
            }
            case "marginLeft": {
                holder = PropertyValuesHolder.ofFloat((String)"marginLeft", (float[])new float[]{this.mWXComponent.getMargin().get(CSSShorthand.EDGE.LEFT), WXViewUtils.getRealPxByWidth(WXUtils.getFloatByViewport(value, this.mWXComponent.getViewPortWidth()), this.mWXComponent.getViewPortWidth())});
                break;
            }
            case "marginRight": {
                holder = PropertyValuesHolder.ofFloat((String)"marginRight", (float[])new float[]{this.mWXComponent.getMargin().get(CSSShorthand.EDGE.RIGHT), WXViewUtils.getRealPxByWidth(WXUtils.getFloatByViewport(value, this.mWXComponent.getViewPortWidth()), this.mWXComponent.getViewPortWidth())});
                break;
            }
            case "marginBottom": {
                holder = PropertyValuesHolder.ofFloat((String)"marginBottom", (float[])new float[]{this.mWXComponent.getMargin().get(CSSShorthand.EDGE.BOTTOM), WXViewUtils.getRealPxByWidth(WXUtils.getFloatByViewport(value, this.mWXComponent.getViewPortWidth()), this.mWXComponent.getViewPortWidth())});
                break;
            }
            case "left": {
                holder = PropertyValuesHolder.ofFloat((String)"left", (float[])new float[]{this.mWXComponent.getLayoutPosition().getLeft(), WXViewUtils.getRealPxByWidth(WXUtils.getFloatByViewport(value, this.mWXComponent.getViewPortWidth()), this.mWXComponent.getViewPortWidth())});
                break;
            }
            case "right": {
                holder = PropertyValuesHolder.ofFloat((String)"right", (float[])new float[]{this.mWXComponent.getLayoutPosition().getRight(), WXViewUtils.getRealPxByWidth(WXUtils.getFloatByViewport(value, this.mWXComponent.getViewPortWidth()), this.mWXComponent.getViewPortWidth())});
                break;
            }
            case "bottom": {
                holder = PropertyValuesHolder.ofFloat((String)"bottom", (float[])new float[]{this.mWXComponent.getLayoutPosition().getBottom(), WXViewUtils.getRealPxByWidth(WXUtils.getFloatByViewport(value, this.mWXComponent.getViewPortWidth()), this.mWXComponent.getViewPortWidth())});
                break;
            }
            case "top": {
                holder = PropertyValuesHolder.ofFloat((String)"top", (float[])new float[]{this.mWXComponent.getLayoutPosition().getTop(), WXViewUtils.getRealPxByWidth(WXUtils.getFloatByViewport(value, this.mWXComponent.getViewPortWidth()), this.mWXComponent.getViewPortWidth())});
                break;
            }
            case "paddingTop": {
                holder = PropertyValuesHolder.ofFloat((String)"paddingTop", (float[])new float[]{this.mWXComponent.getPadding().get(CSSShorthand.EDGE.TOP), WXViewUtils.getRealPxByWidth(WXUtils.getFloatByViewport(value, this.mWXComponent.getViewPortWidth()), this.mWXComponent.getViewPortWidth())});
                break;
            }
            case "paddingBottom": {
                holder = PropertyValuesHolder.ofFloat((String)"paddingBottom", (float[])new float[]{this.mWXComponent.getPadding().get(CSSShorthand.EDGE.BOTTOM), WXViewUtils.getRealPxByWidth(WXUtils.getFloatByViewport(value, this.mWXComponent.getViewPortWidth()), this.mWXComponent.getViewPortWidth())});
                break;
            }
            case "paddingLeft": {
                holder = PropertyValuesHolder.ofFloat((String)"paddingLeft", (float[])new float[]{this.mWXComponent.getPadding().get(CSSShorthand.EDGE.LEFT), WXViewUtils.getRealPxByWidth(WXUtils.getFloatByViewport(value, this.mWXComponent.getViewPortWidth()), this.mWXComponent.getViewPortWidth())});
                break;
            }
            case "paddingRight": {
                holder = PropertyValuesHolder.ofFloat((String)"paddingRight", (float[])new float[]{this.mWXComponent.getPadding().get(CSSShorthand.EDGE.RIGHT), WXViewUtils.getRealPxByWidth(WXUtils.getFloatByViewport(value, this.mWXComponent.getViewPortWidth()), this.mWXComponent.getViewPortWidth())});
                break;
            }
        }
        if (holder == null) {
            holder = PropertyValuesHolder.ofFloat((String)property, (float[])new float[]{1.0f, 1.0f});
        }
        return holder;
    }

    private void doLayoutPropertyValuesHolderAnimation(PropertyValuesHolder[] holders) {
        this.layoutValueAnimator = ValueAnimator.ofPropertyValuesHolder((PropertyValuesHolder[])holders);
        this.layoutValueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                PropertyValuesHolder[] holders;
                for (PropertyValuesHolder holder : holders = animation.getValues()) {
                    String property = holder.getPropertyName();
                    WXTransition.asynchronouslyUpdateLayout(WXTransition.this.mWXComponent, property, ((Float)animation.getAnimatedValue(property)).floatValue());
                }
            }
        });
        this.layoutValueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){
            boolean hasCancel = false;

            public void onAnimationCancel(Animator animation) {
                super.onAnimationCancel(animation);
                this.hasCancel = true;
            }

            public void onAnimationEnd(Animator animation) {
                if (this.hasCancel) {
                    return;
                }
                super.onAnimationEnd(animation);
                WXTransition.this.onTransitionAnimationEnd();
            }
        });
        if (this.interpolator != null) {
            this.layoutValueAnimator.setInterpolator((TimeInterpolator)this.interpolator);
        }
        this.layoutValueAnimator.setStartDelay(this.delay);
        this.layoutValueAnimator.setDuration(this.duration);
        this.layoutValueAnimator.start();
    }

    public static void asynchronouslyUpdateLayout(WXComponent component, final String propertyName, final float propertyValue) {
        if (component == null) {
            return;
        }
        final String ref = component.getRef();
        final String instanceId = component.getInstanceId();
        if (TextUtils.isEmpty((CharSequence)ref) || TextUtils.isEmpty((CharSequence)instanceId)) {
            return;
        }
        WXSDKManager.getInstance().getWXBridgeManager().post(new Runnable(){

            @Override
            public void run() {
                switch (propertyName) {
                    case "width": {
                        WXBridgeManager.getInstance().setStyleWidth(instanceId, ref, propertyValue);
                        break;
                    }
                    case "height": {
                        WXBridgeManager.getInstance().setStyleHeight(instanceId, ref, propertyValue);
                        break;
                    }
                    case "marginTop": {
                        WXBridgeManager.getInstance().setMargin(instanceId, ref, CSSShorthand.EDGE.TOP, propertyValue);
                        break;
                    }
                    case "marginLeft": {
                        WXBridgeManager.getInstance().setMargin(instanceId, ref, CSSShorthand.EDGE.LEFT, propertyValue);
                        break;
                    }
                    case "marginRight": {
                        WXBridgeManager.getInstance().setMargin(instanceId, ref, CSSShorthand.EDGE.RIGHT, propertyValue);
                        break;
                    }
                    case "marginBottom": {
                        WXBridgeManager.getInstance().setMargin(instanceId, ref, CSSShorthand.EDGE.BOTTOM, propertyValue);
                        break;
                    }
                    case "left": {
                        WXBridgeManager.getInstance().setPosition(instanceId, ref, CSSShorthand.EDGE.LEFT, propertyValue);
                        break;
                    }
                    case "right": {
                        WXBridgeManager.getInstance().setPosition(instanceId, ref, CSSShorthand.EDGE.RIGHT, propertyValue);
                        break;
                    }
                    case "bottom": {
                        WXBridgeManager.getInstance().setPosition(instanceId, ref, CSSShorthand.EDGE.BOTTOM, propertyValue);
                        break;
                    }
                    case "top": {
                        WXBridgeManager.getInstance().setPosition(instanceId, ref, CSSShorthand.EDGE.TOP, propertyValue);
                        break;
                    }
                    case "paddingTop": {
                        WXBridgeManager.getInstance().setPadding(instanceId, ref, CSSShorthand.EDGE.TOP, propertyValue);
                        break;
                    }
                    case "paddingBottom": {
                        WXBridgeManager.getInstance().setPadding(instanceId, ref, CSSShorthand.EDGE.BOTTOM, propertyValue);
                        break;
                    }
                    case "paddingLeft": {
                        WXBridgeManager.getInstance().setPadding(instanceId, ref, CSSShorthand.EDGE.LEFT, propertyValue);
                        break;
                    }
                    case "paddingRight": {
                        WXBridgeManager.getInstance().setPadding(instanceId, ref, CSSShorthand.EDGE.RIGHT, propertyValue);
                        break;
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void onTransitionAnimationEnd() {
        if (this.duration > 0L && this.transitionEndEvent != null) {
            View view = this.getTargetView();
            if (view != null && this.transitionEndEvent != null) {
                view.post(this.transitionEndEvent);
            }
            this.transitionEndEvent = null;
        }
        Map<String, Object> map = this.targetStyles;
        synchronized (map) {
            if (this.targetStyles.size() > 0) {
                for (String property : this.properties) {
                    if (!this.targetStyles.containsKey(property)) continue;
                    Object targetValue = this.targetStyles.remove(property);
                    this.mWXComponent.getStyles().put(property, targetValue);
                }
                this.targetStyles.clear();
            }
        }
    }

    private View getTargetView() {
        return null != this.mWXComponent ? (View)this.mWXComponent.getHostView() : null;
    }

    private static long parseTimeMillis(Map<String, Object> style, String key, long defaultValue) {
        String duration = WXUtils.getString(style.get(key), null);
        if (duration != null) {
            duration = duration.replaceAll("ms", "");
        }
        if (duration != null) {
            if (WXEnvironment.isApkDebugable() && duration.contains("px")) {
                WXLogUtils.w("Transition Duration Unit Only Support ms, " + duration + " is not ms Unit");
            }
            duration = duration.replaceAll("px", "");
        }
        if (TextUtils.isEmpty((CharSequence)duration)) {
            return defaultValue;
        }
        try {
            return (long)Float.parseFloat(duration);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static Interpolator createTimeInterpolator(String interpolator) {
        block18: {
            if (!TextUtils.isEmpty((CharSequence)interpolator)) {
                switch (interpolator) {
                    case "ease-in": {
                        return PathInterpolatorCompat.create((float)0.42f, (float)0.0f, (float)1.0f, (float)1.0f);
                    }
                    case "ease-out": {
                        return PathInterpolatorCompat.create((float)0.0f, (float)0.0f, (float)0.58f, (float)1.0f);
                    }
                    case "ease-in-out": {
                        return PathInterpolatorCompat.create((float)0.42f, (float)0.0f, (float)0.58f, (float)1.0f);
                    }
                    case "ease": {
                        return PathInterpolatorCompat.create((float)0.25f, (float)0.1f, (float)0.25f, (float)1.0f);
                    }
                    case "linear": {
                        return PathInterpolatorCompat.create((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
                    }
                }
                try {
                    SingleFunctionParser<Float> parser = new SingleFunctionParser<Float>(interpolator, new SingleFunctionParser.FlatMapper<Float>(){

                        @Override
                        public Float map(String raw) {
                            return Float.valueOf(Float.parseFloat(raw));
                        }
                    });
                    List<Float> params = parser.parse("cubic-bezier");
                    if (params != null && params.size() == 4) {
                        return PathInterpolatorCompat.create((float)params.get(0).floatValue(), (float)params.get(1).floatValue(), (float)params.get(2).floatValue(), (float)params.get(3).floatValue());
                    }
                }
                catch (RuntimeException e) {
                    if (!WXEnvironment.isApkDebugable()) break block18;
                    WXLogUtils.e("WXTransition", e);
                }
            }
        }
        return PathInterpolatorCompat.create((float)0.25f, (float)0.1f, (float)0.25f, (float)1.0f);
    }

    private static void updateTransitionProperties(WXTransition transition, String transtionProperty) {
        String[] propertiesArray;
        if (transtionProperty == null) {
            return;
        }
        transition.properties.clear();
        for (String property : propertiesArray = PROPERTY_SPLIT_PATTERN.split(transtionProperty)) {
            String trim = property.trim();
            if (TextUtils.isEmpty((CharSequence)trim)) continue;
            if (!LAYOUT_PROPERTIES.contains(trim) && !TRANSFORM_PROPERTIES.contains(trim)) {
                if (!WXEnvironment.isApkDebugable()) continue;
                WXLogUtils.e("WXTransition Property Not Supported" + trim + " in " + transtionProperty);
                continue;
            }
            transition.properties.add(trim);
        }
    }

    public List<String> getProperties() {
        return this.properties;
    }

    static {
        LAYOUT_PROPERTIES.add("width");
        LAYOUT_PROPERTIES.add("height");
        LAYOUT_PROPERTIES.add("marginTop");
        LAYOUT_PROPERTIES.add("marginBottom");
        LAYOUT_PROPERTIES.add("marginLeft");
        LAYOUT_PROPERTIES.add("marginRight");
        LAYOUT_PROPERTIES.add("left");
        LAYOUT_PROPERTIES.add("right");
        LAYOUT_PROPERTIES.add("top");
        LAYOUT_PROPERTIES.add("bottom");
        LAYOUT_PROPERTIES.add("paddingLeft");
        LAYOUT_PROPERTIES.add("paddingRight");
        LAYOUT_PROPERTIES.add("paddingTop");
        LAYOUT_PROPERTIES.add("paddingBottom");
        TRANSFORM_PROPERTIES = new HashSet<String>();
        TRANSFORM_PROPERTIES.add("opacity");
        TRANSFORM_PROPERTIES.add("backgroundColor");
        TRANSFORM_PROPERTIES.add("transform");
    }
}

