/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.dom;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.v4.util.ArrayMap;
import android.text.Layout;
import android.text.TextUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.weex.dom.binding.ELUtils;
import org.apache.weex.ui.component.WXTextDecoration;
import org.apache.weex.utils.WXUtils;
import org.apache.weex.utils.WXViewUtils;

public class WXStyle
implements Map<String, Object>,
Cloneable {
    private static final long serialVersionUID = 611132641365274134L;
    public static final int UNSET = -1;
    @NonNull
    private Map<String, Object> mStyles;
    @Nullable
    private Map<String, Map<String, Object>> mPesudoStyleMap;
    @Nullable
    private Map<String, Object> mPesudoResetStyleMap;
    private ArrayMap<String, Object> mBindingStyle;

    public WXStyle() {
        this.mStyles = new ArrayMap();
    }

    public WXStyle(Map<String, Object> styles) {
        this.mStyles = styles;
        this.processPesudoClasses(this.mStyles);
    }

    public WXStyle(Map<String, Object> mStyles, boolean byPesudo) {
        this();
        this.putAll(mStyles, byPesudo);
    }

    @Nullable
    public String getBlur() {
        if (this.get("filter") == null) {
            return null;
        }
        return this.get("filter").toString().trim();
    }

    public static WXTextDecoration getTextDecoration(Map<String, Object> style) {
        WXTextDecoration ret;
        Object obj;
        if (style == null || (obj = style.get("textDecoration")) == null) {
            ret = WXTextDecoration.NONE;
        } else {
            String textDecoration;
            switch (textDecoration = obj.toString()) {
                case "underline": {
                    ret = WXTextDecoration.UNDERLINE;
                    break;
                }
                case "line-through": {
                    ret = WXTextDecoration.LINETHROUGH;
                    break;
                }
                case "none": {
                    ret = WXTextDecoration.NONE;
                    break;
                }
                default: {
                    ret = WXTextDecoration.INVALID;
                }
            }
        }
        return ret;
    }

    public static String getTextColor(Map<String, Object> style) {
        if (style == null) {
            return "";
        }
        Object temp = style.get("color");
        return temp == null ? "" : temp.toString();
    }

    public static int getFontWeight(Map<String, Object> style) {
        Object temp;
        int typeface = 0;
        if (style != null && (temp = style.get("fontWeight")) != null) {
            String fontWeight;
            switch (fontWeight = temp.toString()) {
                case "600": 
                case "700": 
                case "800": 
                case "900": 
                case "bold": {
                    typeface = 1;
                }
            }
        }
        return typeface;
    }

    public static int getFontStyle(Map<String, Object> style) {
        int typeface = 0;
        if (style == null) {
            return typeface;
        }
        Object temp = style.get("fontStyle");
        if (temp == null) {
            return typeface;
        }
        String fontWeight = temp.toString();
        if (fontWeight.equals("italic")) {
            typeface = 2;
        }
        return typeface;
    }

    public static int getFontSize(Map<String, Object> style, int viewPortW) {
        if (style == null) {
            return (int)WXViewUtils.getRealPxByWidth(32.0f, viewPortW);
        }
        int fontSize = WXUtils.getInt(style.get("fontSize"));
        if (fontSize <= 0) {
            fontSize = 32;
        }
        return (int)WXViewUtils.getRealPxByWidth(fontSize, viewPortW);
    }

    public static String getFontFamily(Map<String, Object> style) {
        Object temp;
        String fontFamily = null;
        if (style != null && (temp = style.get("fontFamily")) != null) {
            fontFamily = temp.toString();
        }
        return fontFamily;
    }

    public static Layout.Alignment getTextAlignment(Map<String, Object> style) {
        return WXStyle.getTextAlignment(style, false);
    }

    public static Layout.Alignment getTextAlignment(Map<String, Object> style, boolean isRTL) {
        Layout.Alignment alignment = isRTL ? Layout.Alignment.ALIGN_OPPOSITE : Layout.Alignment.ALIGN_NORMAL;
        String textAlign = (String)style.get("textAlign");
        if (TextUtils.equals((CharSequence)"left", (CharSequence)textAlign)) {
            alignment = Layout.Alignment.ALIGN_NORMAL;
        } else if (TextUtils.equals((CharSequence)"center", (CharSequence)textAlign)) {
            alignment = Layout.Alignment.ALIGN_CENTER;
        } else if (TextUtils.equals((CharSequence)"right", (CharSequence)textAlign)) {
            alignment = Layout.Alignment.ALIGN_OPPOSITE;
        }
        return alignment;
    }

    public static TextUtils.TruncateAt getTextOverflow(Map<String, Object> style) {
        TextUtils.TruncateAt truncateAt = null;
        String ellipse = (String)style.get("textOverflow");
        if (TextUtils.equals((CharSequence)"ellipsis", (CharSequence)ellipse)) {
            truncateAt = TextUtils.TruncateAt.END;
        }
        return truncateAt;
    }

    public static int getLines(Map<String, Object> style) {
        return WXUtils.getInt(style.get("lines"));
    }

    public static int getLineHeight(Map<String, Object> style, int viewPortW) {
        if (style == null) {
            return -1;
        }
        int lineHeight = WXUtils.getInt(style.get("lineHeight"));
        if (lineHeight <= 0) {
            lineHeight = -1;
            return lineHeight;
        }
        return (int)WXViewUtils.getRealPxByWidth(lineHeight, viewPortW);
    }

    public float getBorderRadius() {
        float temp = WXUtils.getFloat(this.get("borderRadius"));
        if (WXUtils.isUndefined(temp)) {
            return Float.NaN;
        }
        return temp;
    }

    public String getBorderColor() {
        Object color = this.get("borderColor");
        return color == null ? null : color.toString();
    }

    public String getBorderStyle() {
        Object borderStyle = this.get("borderStyle");
        return borderStyle == null ? null : borderStyle.toString();
    }

    public boolean isSticky() {
        Object position = this.get("position");
        if (position == null) {
            return false;
        }
        return position.toString().equals("sticky");
    }

    public boolean isFixed() {
        Object position = this.get("position");
        if (position == null) {
            return false;
        }
        return position.toString().equals("fixed");
    }

    public float getLeft() {
        float temp = WXUtils.getFloat(this.get("left"));
        if (WXUtils.isUndefined(temp)) {
            return Float.NaN;
        }
        return temp;
    }

    public float getRight() {
        float temp = WXUtils.getFloat(this.get("right"));
        if (WXUtils.isUndefined(temp)) {
            return Float.NaN;
        }
        return temp;
    }

    public float getTop() {
        float temp = WXUtils.getFloat(this.get("top"));
        if (WXUtils.isUndefined(temp)) {
            return Float.NaN;
        }
        return temp;
    }

    public float getBottom() {
        float temp = WXUtils.getFloat(this.get("bottom"));
        if (WXUtils.isUndefined(temp)) {
            return Float.NaN;
        }
        return temp;
    }

    public String getBackgroundColor() {
        Object temp = this.get("backgroundColor");
        return temp == null ? "" : temp.toString();
    }

    public int getTimeFontSize() {
        int fontSize = WXUtils.getInt(this.get("timeFontSize"));
        if (fontSize <= 0) {
            fontSize = 32;
        }
        return fontSize;
    }

    public float getOpacity() {
        Object object = this.get("opacity");
        float opacity = 1.0f;
        if (object == null) {
            return opacity;
        }
        return WXUtils.getFloat(object);
    }

    public String getOverflow() {
        Object obj = this.get("overflow");
        return obj == null ? "visible" : obj.toString();
    }

    @Override
    public boolean equals(Object o) {
        return this.mStyles.equals(o);
    }

    @Override
    public int hashCode() {
        return this.mStyles.hashCode();
    }

    @Override
    public void clear() {
        this.mStyles.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.mStyles.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.mStyles.containsValue(value);
    }

    @Override
    @NonNull
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.mStyles.entrySet();
    }

    @Override
    public Object get(Object key) {
        return this.mStyles.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.mStyles.isEmpty();
    }

    @Override
    @NonNull
    public Set<String> keySet() {
        return this.mStyles.keySet();
    }

    @Override
    public Object put(String key, Object value) {
        if (this.addBindingStyleIfStatement(key, value)) {
            return null;
        }
        return this.mStyles.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ?> map) {
        this.mStyles.putAll(map);
    }

    public void putAll(Map<? extends String, ?> map, boolean byPesudo) {
        this.mStyles.putAll(map);
        if (!byPesudo) {
            this.processPesudoClasses(map);
        }
    }

    public void updateStyle(Map<? extends String, ?> map, boolean byPesudo) {
        this.parseBindingStylesStatements(map);
        this.putAll(map, byPesudo);
    }

    public Map<String, Object> getPesudoResetStyles() {
        if (this.mPesudoResetStyleMap == null) {
            this.mPesudoResetStyleMap = new ArrayMap();
        }
        return this.mPesudoResetStyleMap;
    }

    public Map<String, Map<String, Object>> getPesudoStyles() {
        if (this.mPesudoStyleMap == null) {
            this.mPesudoStyleMap = new ArrayMap();
        }
        return this.mPesudoStyleMap;
    }

    <T extends String, V> void processPesudoClasses(Map<T, V> styles) {
        Map tempMap = null;
        for (Map.Entry<T, V> entry : styles.entrySet()) {
            String key = (String)entry.getKey();
            int i = key.indexOf(":");
            if (i <= 0) continue;
            this.initPesudoMapsIfNeed(styles);
            String clzName = key.substring(i);
            if (clzName.equals(":enabled")) {
                String styleKey = key.substring(0, i);
                if (tempMap == null) {
                    tempMap = new ArrayMap();
                }
                tempMap.put(styleKey, entry.getValue());
                this.mPesudoResetStyleMap.put(styleKey, entry.getValue());
                continue;
            }
            ArrayMap stylesMap = this.mPesudoStyleMap.get(clzName = clzName.replace(":enabled", ""));
            if (stylesMap == null) {
                stylesMap = new ArrayMap();
                this.mPesudoStyleMap.put(clzName, (Map<String, Object>)stylesMap);
            }
            stylesMap.put(key.substring(0, i), entry.getValue());
        }
        if (tempMap != null && !tempMap.isEmpty()) {
            this.mStyles.putAll(tempMap);
        }
    }

    @Override
    public Object remove(Object key) {
        return this.mStyles.remove(key);
    }

    @Override
    public int size() {
        return this.mStyles.size();
    }

    @Override
    @NonNull
    public Collection<Object> values() {
        return this.mStyles.values();
    }

    private void initPesudoMapsIfNeed(Map<? extends String, ?> styles) {
        if (this.mPesudoStyleMap == null) {
            this.mPesudoStyleMap = new ArrayMap();
        }
        if (this.mPesudoResetStyleMap == null) {
            this.mPesudoResetStyleMap = new ArrayMap();
        }
        if (this.mPesudoResetStyleMap.isEmpty()) {
            this.mPesudoResetStyleMap.putAll(styles);
        }
    }

    public void parseStatements() {
        if (this.mStyles != null) {
            this.mStyles = this.parseBindingStylesStatements(this.mStyles);
        }
    }

    private Map<String, Object> parseBindingStylesStatements(Map styles) {
        if (styles == null || styles.size() == 0) {
            return styles;
        }
        Set entries = styles.entrySet();
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (!this.addBindingStyleIfStatement((String)entry.getKey(), entry.getValue())) continue;
            if (this.mPesudoStyleMap != null) {
                this.mPesudoStyleMap.remove(entry.getKey());
            }
            if (this.mPesudoResetStyleMap != null) {
                this.mPesudoResetStyleMap.remove(entry.getKey());
            }
            it.remove();
        }
        return styles;
    }

    private boolean addBindingStyleIfStatement(String key, Object value) {
        if (ELUtils.isBinding(value)) {
            if (this.mBindingStyle == null) {
                this.mBindingStyle = new ArrayMap();
            }
            value = ELUtils.bindingBlock(value);
            this.mBindingStyle.put((Object)key, value);
            return true;
        }
        return false;
    }

    public ArrayMap<String, Object> getBindingStyle() {
        return this.mBindingStyle;
    }

    public WXStyle clone() {
        WXStyle style = new WXStyle();
        style.mStyles.putAll(this.mStyles);
        if (this.mBindingStyle != null) {
            style.mBindingStyle = new ArrayMap(this.mBindingStyle);
        }
        if (this.mPesudoStyleMap != null) {
            style.mPesudoStyleMap = new ArrayMap();
            for (Map.Entry<String, Map<String, Object>> entry : this.mPesudoStyleMap.entrySet()) {
                ArrayMap valueClone = new ArrayMap();
                valueClone.putAll(entry.getValue());
                style.mPesudoStyleMap.put(entry.getKey(), (Map<String, Object>)valueClone);
            }
        }
        if (this.mPesudoResetStyleMap != null) {
            style.mPesudoResetStyleMap = new ArrayMap();
            style.mPesudoResetStyleMap.putAll(this.mPesudoResetStyleMap);
        }
        return style;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public String toString() {
        return this.mStyles.toString();
    }
}

