/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.common;

import android.content.Intent;
import android.text.TextUtils;
import android.view.Menu;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.weex.WXSDKInstance;
import org.apache.weex.WXSDKManager;
import org.apache.weex.annotation.JSMethod;
import org.apache.weex.common.IWXObject;
import org.apache.weex.ui.component.WXComponent;
import org.apache.weex.utils.WXUtils;

public abstract class WXModule
implements IWXObject {
    public static final String ACTION_ACTIVITY_RESULT = "actionActivityResult";
    public static final String ACTION_REQUEST_PERMISSIONS_RESULT = "actionRequestPermissionsResult";
    public static final String REQUEST_CODE = "requestCode";
    public static final String RESULT_CODE = "resultCode";
    public static final String PERMISSIONS = "permissions";
    public static final String GRANT_RESULTS = "grantResults";
    public WXSDKInstance mWXSDKInstance;
    private String mModuleName;
    private Map<String, List<String>> mEvents = new HashMap<String, List<String>>();
    private Map<String, Boolean> mKeepAlives = new HashMap<String, Boolean>();

    protected final WXComponent findComponent(String ref) {
        if (this.mWXSDKInstance != null && ref != null) {
            return WXSDKManager.getInstance().getWXRenderManager().getWXComponent(this.mWXSDKInstance.getInstanceId(), ref);
        }
        return null;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
    }

    public void onActivityCreate() {
    }

    public void onActivityStart() {
    }

    public void onActivityPause() {
    }

    public void onActivityResume() {
    }

    public void onActivityStop() {
    }

    public void onActivityDestroy() {
    }

    public boolean onActivityBack() {
        return false;
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        return false;
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
    }

    @JSMethod
    public void addEventListener(String eventName, String callback, Map<String, Object> options) {
        Object temp;
        if (TextUtils.isEmpty((CharSequence)eventName) || TextUtils.isEmpty((CharSequence)callback)) {
            return;
        }
        boolean isOnce = false;
        if (options != null && options.size() > 0 && options.containsKey("once") && WXUtils.getBoolean(temp = options.get("once"), false).booleanValue()) {
            isOnce = true;
        }
        this.mKeepAlives.put(callback, isOnce);
        if (this.mEvents.get(eventName) == null) {
            this.mEvents.put(eventName, new ArrayList());
        }
        this.mEvents.get(eventName).add(callback);
    }

    @JSMethod
    public void removeAllEventListeners(String eventName) {
        if (this.mEvents.containsKey(eventName)) {
            List<String> callbacks = this.mEvents.remove(eventName);
            for (String callback : callbacks) {
                this.mKeepAlives.remove(callback);
            }
        }
    }

    public List<String> getEventCallbacks(String eventName) {
        return this.mEvents.get(eventName);
    }

    public boolean isOnce(String callback) {
        return this.mKeepAlives.get(callback);
    }

    public String getModuleName() {
        return this.mModuleName;
    }

    public void setModuleName(String moduleName) {
        this.mModuleName = moduleName;
    }
}

