/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.bridge;

import android.net.Uri;
import android.support.annotation.Keep;
import android.text.TextUtils;
import java.util.HashMap;
import java.util.Locale;
import org.apache.weex.WXEnvironment;
import org.apache.weex.WXHttpListener;
import org.apache.weex.WXSDKInstance;
import org.apache.weex.WXSDKManager;
import org.apache.weex.adapter.IWXHttpAdapter;
import org.apache.weex.base.CalledByNative;
import org.apache.weex.bridge.WXBridgeManager;
import org.apache.weex.common.WXErrorCode;
import org.apache.weex.common.WXRequest;
import org.apache.weex.common.WXResponse;
import org.apache.weex.http.WXHttpUtil;
import org.apache.weex.utils.WXExceptionUtils;
import org.apache.weex.utils.WXLogUtils;

public class RequestHandler {
    @Keep
    native void nativeInvokeOnSuccess(long var1, String var3, String var4);

    native void nativeInvokeOnFailed(long var1);

    @CalledByNative
    public static RequestHandler create() {
        return new RequestHandler();
    }

    @CalledByNative
    public void send(String instanceId, String url, long nativeCallback) {
        if (TextUtils.isEmpty((CharSequence)instanceId) || TextUtils.isEmpty((CharSequence)url) || nativeCallback == 0L || !WXSDKManager.getInstance().getAllInstanceMap().containsKey(instanceId)) {
            return;
        }
        WXSDKManager manager = WXSDKManager.getInstance();
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
        if (instance == null) {
            return;
        }
        IWXHttpAdapter adapter = WXSDKManager.getInstance().getIWXHttpAdapter();
        WXRequest wxRequest = new WXRequest();
        wxRequest.url = manager.getURIAdapter().rewrite(instance, "bundle", Uri.parse((String)url)).toString();
        if (wxRequest.paramMap == null) {
            wxRequest.paramMap = new HashMap<String, String>();
        }
        wxRequest.paramMap.put("user-agent", WXHttpUtil.assembleUserAgent(instance.getContext(), WXEnvironment.getConfig()));
        wxRequest.paramMap.put("isBundleRequest", "true");
        WXLogUtils.i("Eagle", String.format(Locale.ENGLISH, "Weex eagle is going to download script from %s", url));
        adapter.sendRequest(wxRequest, new OnHttpListenerInner(instance, nativeCallback, url));
    }

    @Keep
    @CalledByNative
    public void getBundleType(String instanceId, final String content, final long nativeCallback) {
        WXBridgeManager.BundType bundleType = WXBridgeManager.getInstance().getBundleType("", content);
        final String bundleTypeStr = bundleType == null ? "Others" : bundleType.toString();
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
        if ("Others".equalsIgnoreCase(bundleTypeStr) && null != instance) {
            WXExceptionUtils.commitCriticalExceptionRT(instanceId, WXErrorCode.WX_KEY_EXCEPTION_NO_BUNDLE_TYPE, "RequestHandler.onSuccess", "eagle ->" + WXErrorCode.WX_KEY_EXCEPTION_NO_BUNDLE_TYPE.getErrorMsg(), null);
        }
        WXBridgeManager.getInstance().post(new Runnable(){

            @Override
            public void run() {
                if (WXBridgeManager.getInstance().isJSFrameworkInit()) {
                    RequestHandler.this.nativeInvokeOnSuccess(nativeCallback, content, bundleTypeStr);
                } else {
                    RequestHandler.this.nativeInvokeOnFailed(nativeCallback);
                }
            }
        });
    }

    class OnHttpListenerInner
    extends WXHttpListener {
        private long sNativeCallback;

        OnHttpListenerInner(WXSDKInstance instance, long nativeCallback, String bundlUrl) {
            super(instance, bundlUrl);
            this.sNativeCallback = nativeCallback;
        }

        @Override
        public void onSuccess(WXResponse response) {
            String bundleTypeStr;
            final String script = new String(response.originalData);
            WXBridgeManager.BundType bundleType = WXBridgeManager.getInstance().getBundleType("", script);
            String string2 = bundleTypeStr = bundleType == null ? "Others" : bundleType.toString();
            if ("Others".equalsIgnoreCase(bundleTypeStr) && null != this.getInstance()) {
                WXExceptionUtils.commitCriticalExceptionRT(this.getInstance().getInstanceId(), WXErrorCode.WX_KEY_EXCEPTION_NO_BUNDLE_TYPE, "RequestHandler.onSuccess", "eagle ->" + WXErrorCode.WX_KEY_EXCEPTION_NO_BUNDLE_TYPE.getErrorMsg(), null);
            }
            WXBridgeManager.getInstance().post(new Runnable(){

                @Override
                public void run() {
                    if (WXBridgeManager.getInstance().isJSFrameworkInit()) {
                        RequestHandler.this.nativeInvokeOnSuccess(OnHttpListenerInner.this.sNativeCallback, script, bundleTypeStr);
                    } else {
                        RequestHandler.this.nativeInvokeOnFailed(OnHttpListenerInner.this.sNativeCallback);
                    }
                }
            });
        }

        @Override
        public void onFail(WXResponse response) {
            RequestHandler.this.nativeInvokeOnFailed(this.sNativeCallback);
        }
    }
}

