/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.appfram.pickers;

import android.app.AlertDialog;
import android.app.DatePickerDialog;
import android.app.TimePickerDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.widget.Button;
import android.widget.DatePicker;
import android.widget.TimePicker;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.weex.common.WXThread;
import org.apache.weex.utils.WXLogUtils;

public class DatePickerImpl {
    private static final int DEFAULT_START_YEAR = 1900;
    private static final int DEFAULT_END_YEAR = 2100;
    private static SimpleDateFormat timeFormatter;
    private static SimpleDateFormat dateFormatter;

    public static void pickDate(@NonNull Context context, String value, String max, String min, final @NonNull OnPickListener listener, @Nullable Map<String, Object> extras) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DatePickerImpl.parseDate(value));
        DatePickerDialog dialog = new DatePickerDialog(context, new DatePickerDialog.OnDateSetListener(){

            public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
                int realMonth = monthOfYear + 1;
                String realMonthString = realMonth < 10 ? "0" + realMonth : String.valueOf(realMonth);
                String realDayString = dayOfMonth < 10 ? "0" + dayOfMonth : String.valueOf(dayOfMonth);
                String result = year + "-" + realMonthString + "-" + realDayString;
                listener.onPick(true, result);
            }
        }, calendar.get(1), calendar.get(2), calendar.get(5));
        DatePicker datePicker = dialog.getDatePicker();
        Calendar defaultMinDate = Calendar.getInstance(Locale.getDefault());
        Calendar defaultMaxDate = Calendar.getInstance(Locale.getDefault());
        defaultMinDate.set(1900, 0, 1);
        defaultMaxDate.set(2100, 11, 31);
        if (!TextUtils.isEmpty((CharSequence)min)) {
            long minDate = DatePickerImpl.parseDate(min).getTime();
            if (datePicker.getMaxDate() >= minDate) {
                datePicker.setMinDate(DatePickerImpl.parseDate(min).getTime());
            } else {
                datePicker.setMinDate(defaultMinDate.getTimeInMillis());
                datePicker.setMaxDate(defaultMaxDate.getTimeInMillis());
            }
        }
        if (!TextUtils.isEmpty((CharSequence)max)) {
            long maxDate = DatePickerImpl.parseDate(max).getTime();
            if (datePicker.getMinDate() <= maxDate) {
                datePicker.setMaxDate(DatePickerImpl.parseDate(max).getTime());
            } else {
                datePicker.setMinDate(defaultMinDate.getTimeInMillis());
                datePicker.setMaxDate(defaultMaxDate.getTimeInMillis());
            }
        }
        dialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                listener.onPick(false, null);
            }
        });
        DatePickerImpl.setButtonText((AlertDialog)dialog, -2, String.valueOf(extras != null ? extras.get("cancelTitle") : null));
        DatePickerImpl.setButtonText((AlertDialog)dialog, -1, String.valueOf(extras != null ? extras.get("confirmTitle") : null));
        dialog.show();
    }

    public static void pickTime(@NonNull Context context, String value, final @NonNull OnPickListener listener, @Nullable Map<String, Object> extras) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DatePickerImpl.parseTime(value));
        TimePickerDialog dialog = new TimePickerDialog(context, new TimePickerDialog.OnTimeSetListener(){

            public void onTimeSet(TimePicker view, int hourOfDay, int minute) {
                String h = hourOfDay < 10 ? "0" + hourOfDay : String.valueOf(hourOfDay);
                String m = minute < 10 ? "0" + minute : String.valueOf(minute);
                String result = h + ":" + m;
                listener.onPick(true, result);
            }
        }, calendar.get(11), calendar.get(12), false);
        dialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                listener.onPick(false, null);
            }
        });
        DatePickerImpl.setButtonText((AlertDialog)dialog, -2, String.valueOf(extras != null ? extras.get("cancelTitle") : null));
        DatePickerImpl.setButtonText((AlertDialog)dialog, -1, String.valueOf(extras != null ? extras.get("confirmTitle") : null));
        dialog.show();
    }

    private static Date parseDate(String s) {
        if (dateFormatter == null) {
            dateFormatter = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
        }
        try {
            return dateFormatter.parse(s);
        }
        catch (ParseException e) {
            WXLogUtils.w("[DatePickerImpl] " + e.toString());
            return new Date();
        }
    }

    private static Date parseTime(String s) {
        if (timeFormatter == null) {
            timeFormatter = new SimpleDateFormat("HH:mm", Locale.getDefault());
        }
        try {
            return timeFormatter.parse(s);
        }
        catch (ParseException e) {
            WXLogUtils.w("[DatePickerImpl] " + e.toString());
            return new Date();
        }
    }

    private static void setButtonText(final AlertDialog dialog, final int which, final CharSequence text) {
        if (TextUtils.isEmpty((CharSequence)text) || "null".equals(text)) {
            return;
        }
        try {
            dialog.getWindow().getDecorView().post(WXThread.secure(new Runnable(){

                @Override
                public void run() {
                    Button button = dialog.getButton(which);
                    if (button != null) {
                        button.setAllCaps(false);
                        button.setText(text);
                    }
                }
            }));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static interface OnPickListener {
        public void onPick(boolean var1, @Nullable String var2);
    }
}

