/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.appfram.clipboard;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetFileDescriptor;
import android.net.Uri;
import android.support.annotation.Nullable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.apache.weex.annotation.JSMethod;
import org.apache.weex.appfram.clipboard.IWXClipboard;
import org.apache.weex.bridge.JSCallback;
import org.apache.weex.common.WXModule;
import org.apache.weex.utils.WXLogUtils;

public class WXClipboardModule
extends WXModule
implements IWXClipboard {
    private final String CLIP_KEY = "WEEX_CLIP_KEY_MAIN";
    private static final String RESULT = "result";
    private static final String DATA = "data";
    private static final String RESULT_OK = "success";
    private static final String RESULT_FAILED = "failed";

    @Override
    @JSMethod
    public void setString(String text) {
        if (null == text) {
            return;
        }
        Context context = this.mWXSDKInstance.getContext();
        ClipboardManager clipboard = (ClipboardManager)context.getSystemService("clipboard");
        ClipData clip = ClipData.newPlainText((CharSequence)"WEEX_CLIP_KEY_MAIN", (CharSequence)text);
        clipboard.setPrimaryClip(clip);
    }

    @Override
    @JSMethod
    public void getString(@Nullable JSCallback callback) {
        Context context = this.mWXSDKInstance.getContext();
        ClipboardManager clipboard = (ClipboardManager)context.getSystemService("clipboard");
        HashMap<String, CharSequence> map = new HashMap<String, CharSequence>(2);
        ClipData clip = clipboard.getPrimaryClip();
        if (clip != null && clip.getItemCount() > 0) {
            ClipData.Item item = clip.getItemAt(0);
            CharSequence text = this.coerceToText(context, item);
            map.put(RESULT, text != null ? RESULT_OK : RESULT_FAILED);
            map.put(DATA, text != null ? text : "");
        } else {
            map.put(RESULT, RESULT_FAILED);
            map.put(DATA, "");
        }
        if (null != callback) {
            callback.invoke(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private CharSequence coerceToText(Context context, ClipData.Item item) {
        CharSequence text = item.getText();
        if (text != null) {
            return text;
        }
        Uri uri = item.getUri();
        if (uri != null) {
            InputStreamReader reader = null;
            FileInputStream stream = null;
            try {
                int len;
                AssetFileDescriptor assetFileDescriptor = context.getContentResolver().openTypedAssetFileDescriptor(uri, "text/*", null);
                stream = assetFileDescriptor.createInputStream();
                reader = new InputStreamReader((InputStream)stream, "UTF-8");
                StringBuilder builder = new StringBuilder(128);
                char[] buffer = new char[8192];
                while ((len = reader.read(buffer)) > 0) {
                    builder.append(buffer, 0, len);
                }
                String string = builder.toString();
                return string;
            }
            catch (FileNotFoundException assetFileDescriptor) {
            }
            catch (IOException e) {
                WXLogUtils.w("ClippedData Failure loading text.", e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return uri.toString();
        }
        Intent intent = item.getIntent();
        if (intent != null) {
            return intent.toUri(1);
        }
        return null;
    }
}

