/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.stylemap;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumn;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.TaeDescription;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.cas.CAS;
import org.apache.uima.tools.stylemap.AnTreeListener;
import org.apache.uima.tools.stylemap.AnnotationFeaturesViewer;
import org.apache.uima.tools.stylemap.ColorEditor;
import org.apache.uima.tools.stylemap.ColorParser;
import org.apache.uima.tools.stylemap.ColorRenderer;
import org.apache.uima.tools.stylemap.LabelCellEditor;
import org.apache.uima.tools.stylemap.MyCellRenderer;
import org.apache.uima.tools.stylemap.StyleConstants;
import org.apache.uima.tools.stylemap.StyleMapEntry;
import org.apache.uima.tools.stylemap.StyleMapTable;
import org.apache.uima.tools.stylemap.StyleMapTableModel;
import org.apache.uima.tools.stylemap.StyleMapXmlParser;
import org.apache.uima.tools.stylemap.TableGUIMediator;
import org.apache.uima.tools.util.gui.ImageButton;
import org.apache.uima.tools.util.htmlview.AnnotationViewGenerator;

public class StyleMapEditor
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -7774771368169207250L;
    private boolean buttonPress = false;
    private boolean populated = false;
    private AnnotationFeaturesViewer annotationFeaturesViewer;
    private ImageButton addTableEntryButton;
    private StyleMapTableModel tableModel;
    private StyleMapTable annotationsTable;
    private ArrayList styleList;
    private ImageButton removeTableRowButton;
    private ImageButton moveRowUpButton;
    private ImageButton moveRowDownButton;
    private JButton okButton = new JButton("Save");
    private JButton cancelButton = new JButton("Cancel");
    private JButton resetButton = new JButton("Reset");
    private JDialog styleMapEditorDialog;
    private HashMap colorNameMap;
    private AnalysisEngineMetaData analysisEngineMetaData;
    private AnalysisEngineDescription ae;
    private TableGUIMediator med;
    Object[][] data;

    public StyleMapEditor(JFrame aOwner, CAS cas) {
        super(aOwner, "Style Map Editor", true);
        this.styleList = new ArrayList();
        this.styleMapEditorDialog = this;
        this.getContentPane().setLayout(new BorderLayout());
        JPanel annotationFeaturesPanel = new JPanel();
        annotationFeaturesPanel.setLayout(new BorderLayout());
        this.annotationFeaturesViewer = new AnnotationFeaturesViewer();
        annotationFeaturesPanel.add((Component)this.annotationFeaturesViewer, "Center");
        JPanel iconPanel = new JPanel();
        this.addTableEntryButton = new ImageButton("/org/apache/uima/tools/images/forward_24.gif");
        this.addTableEntryButton.setToolTipText("Create stylemap table entry");
        this.addTableEntryButton.addActionListener(this);
        iconPanel.add(this.addTableEntryButton);
        annotationFeaturesPanel.add((Component)iconPanel, "East");
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BorderLayout());
        JSplitPane splitPane = new JSplitPane(1, true, annotationFeaturesPanel, tablePanel);
        Dimension screenDimension = this.getToolkit().getScreenSize();
        splitPane.setDividerLocation((int)((double)screenDimension.width * 0.28));
        this.okButton.setToolTipText("Save stylemap and exit");
        this.cancelButton.setToolTipText("Exit without saving");
        this.resetButton.setToolTipText("Reset stylemap to that auto-generated from metadata");
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(this.okButton);
        buttonsPanel.add(this.cancelButton);
        buttonsPanel.add(this.resetButton);
        this.getContentPane().add((Component)splitPane, "Center");
        this.getContentPane().add((Component)buttonsPanel, "South");
        this.tableModel = new StyleMapTableModel(StyleConstants.columnNames);
        this.med = new TableGUIMediator();
        this.annotationsTable = new StyleMapTable(this.tableModel, this.annotationFeaturesViewer, this, this.med);
        this.med.setTable(this.annotationsTable);
        this.annotationsTable.setDefaultRenderer(Color.class, new ColorRenderer(this.annotationsTable));
        this.setUpColorEditor(this.annotationsTable);
        this.annotationsTable.setDefaultEditor(String.class, new LabelCellEditor());
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add((Component)this.annotationsTable, null);
        tablePanel.add((Component)scrollPane, "Center");
        JPanel tableButtonsPanel = new JPanel();
        this.moveRowUpButton = new ImageButton("/org/apache/uima/tools/images/up_24.gif");
        this.moveRowUpButton.setToolTipText("Move Row Up");
        this.moveRowUpButton.addActionListener(this);
        tableButtonsPanel.add(this.moveRowUpButton);
        this.moveRowDownButton = new ImageButton("/org/apache/uima/tools/images/down_24.gif");
        this.moveRowDownButton.setToolTipText("Move Row Down");
        this.moveRowDownButton.addActionListener(this);
        tableButtonsPanel.add(this.moveRowDownButton);
        this.removeTableRowButton = new ImageButton("/org/apache/uima/tools/images/RowDelete_24.gif");
        this.removeTableRowButton.setToolTipText("Delete Row");
        this.removeTableRowButton.addActionListener(this);
        tableButtonsPanel.add(this.removeTableRowButton);
        this.med.setButtons(this.moveRowUpButton, this.moveRowDownButton, this.removeTableRowButton);
        tablePanel.add((Component)tableButtonsPanel, "North");
        MyCellRenderer cellRenderer = new MyCellRenderer();
        TableColumn tc = this.annotationsTable.getColumnModel().getColumn(0);
        tc.setCellRenderer(cellRenderer);
        TableColumn labelTableColumn = this.annotationsTable.getColumnModel().getColumn(1);
        TableColumn typeNameTableColumn = this.annotationsTable.getColumnModel().getColumn(2);
        labelTableColumn.setCellRenderer(cellRenderer);
        typeNameTableColumn.setCellRenderer(cellRenderer);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Vector<String> vn = new Vector<String>();
                for (int row = 0; row < StyleMapEditor.this.styleList.size(); ++row) {
                    StyleMapEntry styleMapEntry = (StyleMapEntry)StyleMapEditor.this.styleList.get(row);
                    styleMapEntry.setAnnotationTypeName(String.valueOf(StyleMapEditor.this.tableModel.getValueAt(row, 2)));
                    styleMapEntry.setLabel(String.valueOf(StyleMapEditor.this.tableModel.getValueAt(row, 1)));
                    vn.add(styleMapEntry.getLabel());
                }
                StyleMapEditor.this.buttonPress = true;
                Vector noDups = new Vector();
                Object var4_6 = null;
                for (Object e : vn) {
                    if (e == null || e.equals("")) continue;
                    if (noDups.contains(e)) {
                        JOptionPane.showMessageDialog(StyleMapEditor.this, "Duplicate Label :  " + String.valueOf(e) + "\nChange the Label and click OK!", "Duplicate Values", -1);
                        StyleMapEditor.this.buttonPress = false;
                        break;
                    }
                    noDups.addElement(e);
                }
                if (StyleMapEditor.this.buttonPress) {
                    StyleMapEditor.this.styleMapEditorDialog.setVisible(false);
                }
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StyleMapEditor.this.buttonPress = false;
                StyleMapEditor.this.styleMapEditorDialog.setVisible(false);
            }
        });
        this.resetButton.addActionListener(this);
        this.pack();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension d = super.getPreferredSize();
        return new Dimension(screenSize.width, d.height);
    }

    @Deprecated
    public void setTextAnalysisEngine(TaeDescription tae) {
        this.ae = tae;
    }

    public void setAnalysisEngine(AnalysisEngineDescription ae) {
        this.ae = ae;
    }

    public String launchEditor(AnalysisEngineMetaData aAnalysisEngineMetaData, String aStyleMapXml, CAS cas) {
        this.analysisEngineMetaData = aAnalysisEngineMetaData;
        ArrayList styleList = this.createStyleList(aAnalysisEngineMetaData, aStyleMapXml);
        if (this.launchGUI(styleList, cas)) {
            return this.generateStyleMap(styleList);
        }
        return null;
    }

    public ArrayList createStyleList(AnalysisEngineMetaData aAnalysisEngineMetaData, String aStyleMapXml) {
        this.styleList = new ArrayList();
        if (aStyleMapXml == null) {
            aStyleMapXml = AnnotationViewGenerator.autoGenerateStyleMap(aAnalysisEngineMetaData);
        }
        return this.parseStyleList(aStyleMapXml);
    }

    public ArrayList parseStyleList(String aStyleMapXml) {
        StyleMapXmlParser smxp = new StyleMapXmlParser(aStyleMapXml);
        Vector annotType_SME = smxp.annotType;
        Vector styleLabel_SME = smxp.styleLabel;
        Vector featureValue_SME = smxp.featureValue;
        Vector styleColor_SME = smxp.styleColor;
        ColorParser cp = new ColorParser();
        this.colorNameMap = cp.getColorNameMap();
        for (int i = 0; i < annotType_SME.size(); ++i) {
            String typeName = (String)annotType_SME.elementAt(i);
            String labelString = (String)styleLabel_SME.elementAt(i);
            String featureValue = (String)featureValue_SME.elementAt(i);
            String styleColor = styleColor_SME.elementAt(i).toString();
            StyleMapEntry e = cp.parseAndAssignColors(typeName, featureValue, labelString, styleColor);
            this.styleList.add(e);
        }
        return this.styleList;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        JComponent source = (JComponent)evt.getSource();
        if (source == this.moveRowUpButton) {
            int selectedRow = this.annotationsTable.getSelectedRow();
            if (selectedRow == -1) {
                JOptionPane.showMessageDialog(source, "Select table row", "Error", 0);
                return;
            }
            if (selectedRow == 0) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                this.tableModel.moveRowUp(selectedRow);
                ListSelectionModel lsm = this.annotationsTable.getSelectionModel();
                int newSelectedRow = selectedRow - 1;
                lsm.setSelectionInterval(newSelectedRow, newSelectedRow);
                StyleMapEntry e = (StyleMapEntry)this.styleList.get(selectedRow);
                this.styleList.remove(selectedRow);
                this.styleList.add(newSelectedRow, e);
            }
        } else if (source == this.moveRowDownButton) {
            int selectedRow = this.annotationsTable.getSelectedRow();
            if (selectedRow == -1) {
                JOptionPane.showMessageDialog(source, "Select table row", "Error", 0);
                return;
            }
            if (selectedRow == this.tableModel.getRowCount() - 1) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                this.tableModel.moveRowDown(selectedRow);
                ListSelectionModel lsm = this.annotationsTable.getSelectionModel();
                int newSelectedRow = selectedRow + 1;
                lsm.setSelectionInterval(newSelectedRow, newSelectedRow);
                StyleMapEntry e = (StyleMapEntry)this.styleList.get(selectedRow);
                this.styleList.remove(selectedRow);
                this.styleList.add(newSelectedRow, e);
            }
        } else if (source == this.addTableEntryButton) {
            String typeName = this.annotationFeaturesViewer.getSelection();
            if (typeName == null) {
                JOptionPane.showMessageDialog(source, "You must first select an annotation type or feature", "Error", 0);
                return;
            }
            this.addRow(typeName);
        } else if (source == this.removeTableRowButton) {
            int row = this.annotationsTable.getSelectedRow();
            if (row >= 0) {
                String message = "Are you sure you want to remove " + String.valueOf(this.tableModel.getValueAt(row, 1));
                int rv = JOptionPane.showConfirmDialog(this.removeTableRowButton, message, "Remove Table Row", 0);
                if (rv == 0) {
                    this.styleList.remove(row);
                    this.styleList.trimToSize();
                    this.tableModel.removeRow(row);
                    ListSelectionModel lsm = this.annotationsTable.getSelectionModel();
                    int newSelectedRow = row == this.styleList.size() ? row - 1 : row;
                    lsm.setSelectionInterval(newSelectedRow, newSelectedRow);
                }
            } else {
                JOptionPane.showMessageDialog(source, "You must first select a table row to remove", "Error", 0);
            }
        } else if (source == this.resetButton) {
            this.styleList = this.createStyleList(this.analysisEngineMetaData, null);
            this.data = new Object[this.styleList.size()][7];
            for (int x = 0; x < this.styleList.size(); ++x) {
                StyleMapEntry e = (StyleMapEntry)this.styleList.get(x);
                this.data[x][0] = "";
                this.data[x][1] = e.getLabel().trim();
                this.data[x][2] = e.getAnnotationTypeName();
                this.data[x][3] = e.getBackground();
                this.data[x][4] = e.getForeground();
                this.data[x][5] = e.getChecked();
                this.data[x][6] = e.getHidden();
            }
            this.tableModel.set(this.data);
            this.tableModel.fireTableDataChanged();
        }
    }

    protected StyleMapTable getAnnotationsTable() {
        return this.annotationsTable;
    }

    private boolean launchGUI(ArrayList aStyleList, CAS cas) {
        if (!this.populated) {
            this.styleList = aStyleList;
            this.data = new Object[aStyleList.size()][7];
            int[] maxColumnWidths = new int[7];
            maxColumnWidths[0] = 16;
            FontMetrics fm = this.annotationsTable.getFontMetrics(this.annotationsTable.getFont());
            maxColumnWidths[3] = fm.stringWidth(StyleConstants.columnNames[3]);
            maxColumnWidths[4] = fm.stringWidth(StyleConstants.columnNames[4]);
            maxColumnWidths[5] = 60;
            maxColumnWidths[6] = 60;
            for (int x = 0; x < aStyleList.size(); ++x) {
                int labelWidth;
                StyleMapEntry e = (StyleMapEntry)aStyleList.get(x);
                this.data[x][0] = "";
                this.data[x][1] = e.getLabel().trim();
                this.data[x][2] = e.getAnnotationTypeName();
                this.data[x][3] = e.getBackground();
                this.data[x][4] = e.getForeground();
                this.data[x][5] = e.getChecked();
                this.data[x][6] = e.getHidden();
                int typeNameWidth = fm.stringWidth(e.getAnnotationTypeName());
                if (typeNameWidth > maxColumnWidths[2]) {
                    maxColumnWidths[2] = typeNameWidth;
                }
                if ((labelWidth = fm.stringWidth(e.getLabel().trim())) <= maxColumnWidths[1]) continue;
                maxColumnWidths[1] = labelWidth;
            }
            this.tableModel.set(this.data);
            this.tableModel.fireTableDataChanged();
            this.annotationFeaturesViewer.populate(this.ae, this.analysisEngineMetaData, cas);
            this.annotationFeaturesViewer.addTreeSelectionListener(new AnTreeListener(this.med));
            this.med.setEntryButton(this.addTableEntryButton);
            TableColumn column = null;
            for (int i = 0; i < 7; ++i) {
                column = this.annotationsTable.getColumnModel().getColumn(i);
                column.setPreferredWidth(maxColumnWidths[i] + 4);
            }
            this.annotationsTable.getTableHeader().repaint();
            this.populated = true;
        }
        this.styleMapEditorDialog.pack();
        this.styleMapEditorDialog.setVisible(true);
        return this.buttonPress;
    }

    private void setUpColorEditor(JTable table) {
        final JTable tbl = table;
        final JButton button = new JButton(""){
            private static final long serialVersionUID = 3955120051470642157L;

            @Override
            public void setText(String s) {
            }
        };
        button.setBackground(Color.white);
        button.setBorderPainted(false);
        button.setMargin(new Insets(0, 0, 0, 0));
        final ColorEditor colorEditor = new ColorEditor(button);
        table.setDefaultEditor(Color.class, colorEditor);
        final JColorChooser colorChooser = new JColorChooser();
        ActionListener okListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color newColor = colorEditor.currentColor = colorChooser.getColor();
                StyleMapEntry entry = (StyleMapEntry)StyleMapEditor.this.styleList.get(tbl.getSelectedRow());
                int column = tbl.getSelectedColumn();
                if (column == 3) {
                    entry.setBackground(newColor);
                } else {
                    entry.setForeground(newColor);
                }
                tbl.repaint();
            }
        };
        final JDialog dialog = JColorChooser.createDialog(button, "Pick a Color", true, colorChooser, okListener, null);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                button.setBackground(colorEditor.currentColor);
                colorChooser.setColor(colorEditor.currentColor);
                dialog.setLocationRelativeTo(button);
                dialog.show();
            }
        });
    }

    private String generateStyleMap(ArrayList aStyleList) {
        String newStyleMap = null;
        try {
            StringBuffer newStyle = new StringBuffer();
            try {
                newStyle.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
                newStyle.append("<styleMap>\n");
                Iterator smt = this.styleList.iterator();
                int row = 0;
                while (smt.hasNext()) {
                    StyleMapEntry e = (StyleMapEntry)smt.next();
                    newStyle.append("<rule>\n");
                    newStyle.append("<pattern>");
                    newStyle.append(e.getPattern());
                    newStyle.append("</pattern>\n");
                    newStyle.append("<label>");
                    String label = e.getLabel();
                    if (label != null) {
                        if (label != null && !label.equals("")) {
                            newStyle.append(label);
                        } else {
                            newStyle.append(e.getAnnotationTypeName());
                        }
                    } else {
                        newStyle.append(e.getAnnotationTypeName());
                    }
                    newStyle.append("</label>\n");
                    newStyle.append("<style>");
                    String foregroundColor = "#" + Integer.toHexString(e.getForeground().getRGB()).substring(2);
                    String backgroundColor = "#" + Integer.toHexString(e.getBackground().getRGB()).substring(2);
                    if (this.colorNameMap.containsKey(foregroundColor)) {
                        newStyle.append("color:" + String.valueOf(this.colorNameMap.get(foregroundColor)) + ";");
                    } else {
                        newStyle.append("color:" + foregroundColor + ";");
                    }
                    if (this.colorNameMap.containsKey(backgroundColor)) {
                        newStyle.append("background:" + String.valueOf(this.colorNameMap.get(backgroundColor)) + ";");
                    } else {
                        newStyle.append("background:" + backgroundColor + ";");
                    }
                    Boolean ck = (Boolean)this.tableModel.getValueAt(row, 5);
                    String ckString = ck.toString();
                    Boolean hid = (Boolean)this.tableModel.getValueAt(row, 6);
                    String hidString = hid.toString();
                    if (hidString.equals("true")) {
                        ckString = "false";
                    }
                    newStyle.append("checked:" + ckString + ";");
                    newStyle.append("hidden:" + hidString + ";");
                    newStyle.append("</style>\n");
                    newStyle.append("</rule>\n");
                    ++row;
                }
                newStyle.append("</styleMap>\n");
            }
            catch (Exception e) {
                System.out.println(e);
            }
            newStyleMap = newStyle.toString();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return newStyleMap;
    }

    public void addRow(String typeName) {
        for (int i = 0; i < this.styleList.size(); ++i) {
            StyleMapEntry e = (StyleMapEntry)this.styleList.get(i);
            if (!typeName.equals(e.getAnnotationTypeName()) || typeName.indexOf(":") != -1) continue;
            JOptionPane.showMessageDialog(this, "Duplicate Annotation Type", "Error", 0);
            return;
        }
        StyleMapEntry styleMapEntry = new StyleMapEntry();
        styleMapEntry.setAnnotationTypeName(typeName);
        styleMapEntry.setLabel(typeName);
        styleMapEntry.setFeatureValue("");
        styleMapEntry.setForeground(Color.black);
        styleMapEntry.setBackground(Color.white);
        this.styleList.add(styleMapEntry);
        Vector<Object> rowVector = new Vector<Object>();
        rowVector.addElement("");
        rowVector.addElement(typeName);
        rowVector.addElement(typeName);
        rowVector.addElement(Color.white);
        rowVector.addElement(Color.black);
        rowVector.addElement(Boolean.TRUE);
        rowVector.addElement(Boolean.FALSE);
        this.tableModel.addRow(rowVector);
    }
}

