/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.components;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.collection.CasConsumerDescription;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.examples.SourceDocumentInformation;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.tools.components.XCasWriterCasConsumer;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.UriUtils;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLSerializer;
import org.xml.sax.SAXException;

public class XmiWriterCasConsumer
extends CasConsumer_ImplBase {
    public static final String PARAM_OUTPUTDIR = "OutputDirectory";
    private File mOutputDir;
    private int mDocNum;

    public void initialize() throws ResourceInitializationException {
        this.mDocNum = 0;
        this.mOutputDir = new File((String)this.getConfigParameterValue(PARAM_OUTPUTDIR));
        if (!this.mOutputDir.exists()) {
            this.mOutputDir.mkdirs();
        }
    }

    public void processCas(CAS aCAS) throws ResourceProcessException {
        JCas jcas;
        String modelFileName = null;
        try {
            jcas = aCAS.getJCas();
        }
        catch (CASException e) {
            throw new ResourceProcessException((Throwable)e);
        }
        FSIterator it = jcas.getAnnotationIndex(SourceDocumentInformation.type).iterator();
        File outFile = null;
        if (it.hasNext()) {
            SourceDocumentInformation fileLoc = (SourceDocumentInformation)it.next();
            try {
                URI uri = UriUtils.quote((String)fileLoc.getUri());
                File inFile = new File(uri);
                String outFileName = inFile.getName();
                if (fileLoc.getOffsetInSource() > 0) {
                    outFileName = outFileName + "_" + fileLoc.getOffsetInSource();
                }
                outFileName = outFileName + ".xmi";
                outFile = new File(this.mOutputDir, outFileName);
                modelFileName = this.mOutputDir.getAbsolutePath() + "/" + inFile.getName() + ".ecore";
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
        if (outFile == null) {
            outFile = new File(this.mOutputDir, "doc" + this.mDocNum++ + ".xmi");
        }
        try {
            this.writeXmi(jcas.getCas(), outFile, modelFileName);
        }
        catch (IOException e) {
            throw new ResourceProcessException((Throwable)e);
        }
        catch (SAXException e) {
            throw new ResourceProcessException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeXmi(CAS aCas, File name, String modelFileName) throws IOException, SAXException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(name);
            XmiCasSerializer ser = new XmiCasSerializer(aCas.getTypeSystem());
            XMLSerializer xmlSer = new XMLSerializer((OutputStream)out, false);
            ser.serialize(aCas, xmlSer.getContentHandler());
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static CasConsumerDescription getDescription() throws InvalidXMLException {
        InputStream descStream = XCasWriterCasConsumer.class.getResourceAsStream("XmiWriterCasConsumer.xml");
        return UIMAFramework.getXMLParser().parseCasConsumerDescription(new XMLInputSource(descStream, null));
    }

    public static URL getDescriptorURL() {
        return XmiWriterCasConsumer.class.getResource("XmiWriterCasConsumer.xml");
    }
}

