/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.util.gui;

import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.apache.uima.tools.images.Images;
import org.apache.uima.tools.util.gui.TransportControlListener;

public class TransportControlPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -2176626241850938032L;
    public static final int PLAY_BUTTON = 0;
    public static final int PAUSE_BUTTON = 1;
    public static final int STOP_BUTTON = 2;
    private ToggleButton playButton;
    private ToggleButton pauseButton;
    private ToggleButton stopButton;
    private JToggleButton invisibleButton;
    private ToggleButton lastButtonSelected;
    private boolean allowStop = true;
    final TransportControlListener controlListener;

    public TransportControlPanel(TransportControlListener controlListener) {
        this.controlListener = controlListener;
        ButtonGroup buttonGroup = new ButtonGroup();
        this.setBorder(BorderFactory.createBevelBorder(0));
        FlowLayout flowLayout = (FlowLayout)this.getLayout();
        flowLayout.setHgap(10);
        this.playButton = new ToggleButton(Images.getImageIcon("/org/apache/uima/tools/images/play_24.gif"));
        this.add(this.playButton);
        buttonGroup.add(this.playButton);
        this.playButton.addActionListener(this);
        this.pauseButton = new ToggleButton(Images.getImageIcon("/org/apache/uima/tools/images/pause_24.gif"));
        this.add(this.pauseButton);
        buttonGroup.add(this.pauseButton);
        this.pauseButton.addActionListener(this);
        this.stopButton = new ToggleButton(Images.getImageIcon("/org/apache/uima/tools/images/stop_24.gif"));
        this.add(this.stopButton);
        buttonGroup.add(this.stopButton);
        this.stopButton.addActionListener(this);
        this.invisibleButton = new JToggleButton("");
        buttonGroup.add(this.invisibleButton);
        this.pauseButton.setEnabled(false);
        this.stopButton.setEnabled(false);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.playButton && this.lastButtonSelected != this.playButton) {
            this.playButton.setEnabled(false);
            this.pauseButton.setEnabled(true);
            this.stopButton.setEnabled(true);
            this.controlListener.controlStarted();
            this.lastButtonSelected = this.playButton;
        } else if (source == this.pauseButton) {
            if (this.lastButtonSelected != this.pauseButton) {
                this.pause();
            } else {
                this.controlListener.controlResumed();
                this.playButton.setSelected(true);
                this.playButton.setEnabled(true);
                this.stopButton.setEnabled(true);
                this.lastButtonSelected = this.playButton;
            }
        } else if (source == this.stopButton) {
            if (this.allowStop) {
                this.stop();
            } else {
                this.playButton.setSelected(true);
                this.lastButtonSelected = this.playButton;
            }
        }
    }

    private void pause() {
        this.playButton.setEnabled(false);
        this.stopButton.setEnabled(true);
        this.controlListener.controlPaused();
        this.lastButtonSelected = this.pauseButton;
    }

    public void performPause() {
        this.pause();
    }

    public void stop() {
        this.stop(true);
    }

    private void stop(boolean invokeListener) {
        if (invokeListener) {
            this.controlListener.controlStopped();
        }
        this.invisibleButton.setSelected(true);
        this.pauseButton.setEnabled(false);
        this.stopButton.setEnabled(false);
        this.playButton.setEnabled(true);
        this.lastButtonSelected = null;
    }

    public void reset() {
        this.stop(false);
    }

    public void setButtonTooltipText(int buttonIndex, String tooltip) {
        if (buttonIndex == 0) {
            this.playButton.setToolTipText(tooltip);
        } else if (buttonIndex == 1) {
            this.pauseButton.setToolTipText(tooltip);
        } else if (buttonIndex == 2) {
            this.stopButton.setToolTipText(tooltip);
        }
    }

    public AbstractButton getButton(int buttonIndex) {
        if (buttonIndex == 0) {
            return this.playButton;
        }
        if (buttonIndex == 1) {
            return this.pauseButton;
        }
        if (buttonIndex == 2) {
            return this.stopButton;
        }
        return null;
    }

    public void setAllowStop(boolean allowStop) {
        this.allowStop = allowStop;
    }

    static class ToggleButton
    extends JToggleButton {
        private static final long serialVersionUID = 334131406404068987L;

        public ToggleButton(ImageIcon imageIcon) {
            super(imageIcon);
        }

        public Insets getInsets() {
            return new Insets(2, 2, 2, 2);
        }
    }
}

