/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.util.gui;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.apache.uima.tools.util.gui.FileSelectorListener;

public class FileSelector
extends JPanel
implements FocusListener {
    private static final long serialVersionUID = -1438950608628876422L;
    private JTextField field;
    private BrowseButton browseButton;
    private JFileChooser fileChooser;
    private JComponent source;
    private FileSelectorListener fileSelectorListener = null;
    private String previousValue;
    private File initialDir;
    private String fileChooserTitle;
    private int selectionMode;
    private FileFilter filter;

    public FileSelector(String initialValue, String fileChooserTitle, int selectionMode) {
        this(initialValue, fileChooserTitle, selectionMode, null);
    }

    public FileSelector(String initialValue, String fileChooserTitle, int selectionMode, File currentDir) {
        this(initialValue, fileChooserTitle, selectionMode, currentDir, null);
    }

    public FileSelector(String initialValue, String fileChooserTitle, int selectionMode, File currentDir, FileFilter filter) {
        if (currentDir == null && initialValue != null) {
            currentDir = new File(initialValue).getAbsoluteFile();
        }
        this.initialDir = currentDir;
        this.fileChooserTitle = fileChooserTitle;
        this.selectionMode = selectionMode;
        this.filter = filter;
        this.setLayout(new BoxLayout(this, 0));
        this.field = new JTextField(initialValue, 20);
        this.field.addFocusListener(this);
        this.add(this.field);
        this.previousValue = initialValue == null ? "" : initialValue;
        this.add(Box.createHorizontalStrut(8));
        this.browseButton = new BrowseButton("Browse..");
        this.add(this.browseButton);
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = FileSelector.this.getFileChooser();
                int returnVal = chooser.showOpenDialog(FileSelector.this.browseButton);
                if (returnVal == 0) {
                    File file = chooser.getSelectedFile();
                    String fileString = file.getAbsolutePath();
                    if (FileSelector.this.fileSelectorListener != null) {
                        boolean result = FileSelector.this.fileSelectorListener.fileSelected(FileSelector.this.source, fileString);
                        if (result) {
                            FileSelector.this.field.setText(fileString);
                            FileSelector.this.previousValue = fileString;
                        } else {
                            chooser.setSelectedFile(new File(FileSelector.this.previousValue));
                        }
                    } else {
                        FileSelector.this.field.setText(fileString);
                        FileSelector.this.previousValue = fileString;
                    }
                }
            }
        });
        this.field.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                String fileString = FileSelector.this.field.getText();
                if (!fileString.equals(FileSelector.this.previousValue)) {
                    if (FileSelector.this.fileSelectorListener != null) {
                        boolean result = FileSelector.this.fileSelectorListener.fileSelected(FileSelector.this.source, fileString);
                        if (result) {
                            FileSelector.this.previousValue = fileString;
                        } else if (FileSelector.this.fileChooser != null) {
                            FileSelector.this.fileChooser.setSelectedFile(FileSelector.this.previousValue == null ? null : new File(FileSelector.this.previousValue));
                        }
                    } else {
                        FileSelector.this.previousValue = fileString;
                    }
                }
            }
        });
        this.field.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    String fileString = FileSelector.this.field.getText();
                    if (FileSelector.this.fileSelectorListener != null) {
                        String oldValue = FileSelector.this.previousValue;
                        FileSelector.this.previousValue = fileString;
                        boolean result = FileSelector.this.fileSelectorListener.fileSelected(FileSelector.this.source, fileString);
                        if (!result) {
                            FileSelector.this.previousValue = oldValue;
                            if (FileSelector.this.fileChooser != null) {
                                FileSelector.this.fileChooser.setSelectedFile(FileSelector.this.previousValue == null ? null : new File(FileSelector.this.previousValue));
                            }
                        }
                    } else {
                        FileSelector.this.previousValue = fileString;
                    }
                }
            }
        });
    }

    public void addFileSelectorListener(FileSelectorListener fileSelectorListener, JComponent source) {
        this.fileSelectorListener = fileSelectorListener;
        this.source = source;
    }

    public String getSelected() {
        return this.field.getText();
    }

    public void setSelected(String s) {
        this.field.setText(s);
        this.previousValue = s;
        if (s == null || s.length() == 0) {
            s = System.getProperty("user.dir");
        }
        File file = new File(s);
        if (this.fileChooser != null) {
            if (this.fileChooser.getFileSelectionMode() == 0 && file.isDirectory()) {
                this.fileChooser.setCurrentDirectory(file);
            } else {
                this.fileChooser.setSelectedFile(file);
            }
        }
    }

    public void setEnabled(boolean onOff) {
        this.field.setEnabled(onOff);
        this.browseButton.setEnabled(onOff);
    }

    public void clear() {
        this.field.setText("");
    }

    public void focusGained(FocusEvent aEvent) {
    }

    public void focusLost(FocusEvent aEvent) {
        if (aEvent.getComponent() == this.field && this.fileChooser != null) {
            String path = this.getSelected();
            if (path.length() == 0) {
                path = System.getProperty("user.dir");
            }
            File file = new File(path);
            if (this.fileChooser.getFileSelectionMode() == 0 && file.isDirectory()) {
                this.fileChooser.setCurrentDirectory(file);
            } else {
                this.fileChooser.setSelectedFile(file);
            }
        }
    }

    protected JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            String val = this.field.getText();
            File selected = val == null ? null : new File(val);
            this.fileChooser = new JFileChooser(this.initialDir);
            this.fileChooser.setDialogTitle(this.fileChooserTitle);
            this.fileChooser.setFileSelectionMode(this.selectionMode);
            if (this.filter != null) {
                this.fileChooser.addChoosableFileFilter(this.filter);
            }
            this.fileChooser.setSelectedFile(selected);
        }
        return this.fileChooser;
    }

    static class BrowseButton
    extends JButton {
        private static final long serialVersionUID = 1086776109494251334L;

        public BrowseButton(String s) {
            super(s);
        }

        public Insets getInsets() {
            return new Insets(3, 6, 3, 6);
        }
    }
}

