/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cvd.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import org.apache.uima.UIMAFramework;
import org.apache.uima.internal.util.Timer;
import org.apache.uima.resource.metadata.FsIndexDescription;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.tools.cvd.MainFrame;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLizable;

public class TypeSystemFileOpenEventHandler
implements ActionListener {
    private final MainFrame main;

    public TypeSystemFileOpenEventHandler(MainFrame frame) {
        this.main = frame;
    }

    public void actionPerformed(ActionEvent event) {
        File tsFile;
        int rc;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Open Type System File");
        if (this.main.getXcasFileOpenDir() != null) {
            fileChooser.setCurrentDirectory(this.main.getXcasFileOpenDir());
        }
        if ((rc = fileChooser.showOpenDialog(this.main)) == 0 && (tsFile = fileChooser.getSelectedFile()).exists() && tsFile.isFile()) {
            try {
                this.main.setXcasFileOpenDir(tsFile.getParentFile());
                Timer time = new Timer();
                time.start();
                XMLizable descriptor = UIMAFramework.getXMLParser().parse(new XMLInputSource(tsFile));
                TypeSystemDescription tsDesc = (TypeSystemDescription)descriptor;
                tsDesc.resolveImports();
                this.main.destroyAe();
                this.main.setCas(CasCreationUtils.createCas((TypeSystemDescription)tsDesc, null, (FsIndexDescription[])new FsIndexDescription[0]));
                this.main.setRunOnCasEnabled();
                this.main.setRerunEnabled(false);
                this.main.getTextArea().setText("");
                this.main.resetTrees();
                this.main.setTypeSystemViewerEnabled(true);
                this.main.setEnableCasFileReadingAndWriting();
                time.stop();
                this.main.setStatusbarMessage("Done loading type system file in " + time.getTimeSpan() + ".");
            }
            catch (Exception e) {
                e.printStackTrace();
                this.main.handleException(e);
            }
        }
    }
}

