/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cvd;

import java.util.ArrayList;
import java.util.Map;
import javax.swing.text.Style;
import javax.swing.text.StyleContext;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.tools.cvd.AnnotationExtent;
import org.apache.uima.tools.cvd.MarkupExtent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultiMarkup {
    public static AnnotationExtent[] createAnnotationMarkups(FSIterator it, int textLen, Map<String, Style> styleMap) {
        AnnotExtent ext;
        ArrayList<AnnotExtent> list = new ArrayList<AnnotExtent>();
        list.add(new AnnotExtent(0, textLen, 0, null));
        int pos = 0;
        it.moveToFirst();
        while (it.isValid()) {
            AnnotationFS fs = (AnnotationFS)it.get();
            if (fs.getEnd() != fs.getBegin()) {
                ext = (AnnotExtent)list.get(pos);
                while (fs.getBegin() >= ext.end) {
                    ext = (AnnotExtent)list.get(++pos);
                }
                if (ext.start < fs.getBegin()) {
                    list.add(++pos, new AnnotExtent(fs.getBegin(), ext.end, ext.depth + 1, fs.getType().getName()));
                    ext.end = fs.getBegin();
                    ext = (AnnotExtent)list.get(pos);
                } else {
                    ++ext.depth;
                }
                if (ext.end > fs.getEnd()) {
                    list.add(pos + 1, new AnnotExtent(fs.getEnd(), ext.end, ext.depth - 1, ext.annotName));
                    ext.end = fs.getEnd();
                } else if (ext.end < fs.getEnd()) {
                    int tmp = pos;
                    while (ext.end < fs.getEnd()) {
                        ext = (AnnotExtent)list.get(++tmp);
                        ++ext.depth;
                    }
                    if (ext.start < fs.getEnd()) {
                        list.add(tmp + 1, new AnnotExtent(fs.getEnd(), ext.end, ext.depth, ext.annotName));
                        ext.end = fs.getEnd();
                    }
                    ++ext.depth;
                }
            }
            it.moveToNext();
        }
        Style unmarkedStyle = StyleContext.getDefaultStyleContext().getStyle("default");
        Style annotStyle = styleMap.get("uima.tcas.Annotation");
        int size = list.size();
        AnnotationExtent[] extentArray = new AnnotationExtent[size];
        block7: for (int i = 0; i < size; ++i) {
            ext = (AnnotExtent)list.get(i);
            switch (ext.depth) {
                case 0: {
                    extentArray[i] = new AnnotationExtent(ext.start, ext.end, unmarkedStyle);
                    continue block7;
                }
                case 1: {
                    Style style = styleMap.get(ext.annotName);
                    if (style == null) {
                        style = annotStyle;
                    }
                    extentArray[i] = new AnnotationExtent(ext.start, ext.end, style);
                    continue block7;
                }
                default: {
                    extentArray[i] = new AnnotationExtent(ext.start, ext.end, annotStyle);
                }
            }
        }
        return extentArray;
    }

    public static MarkupExtent[] createMarkupExtents(FSIterator it, int textLen) {
        Extent ext;
        ArrayList<Extent> list = new ArrayList<Extent>();
        list.add(new Extent(0, textLen, 0));
        int pos = 0;
        it.moveToFirst();
        while (it.isValid()) {
            AnnotationFS fs = (AnnotationFS)it.get();
            if (fs.getEnd() != fs.getBegin()) {
                ext = (Extent)list.get(pos);
                while (fs.getBegin() >= ext.end) {
                    ext = (Extent)list.get(++pos);
                }
                if (ext.start < fs.getBegin()) {
                    list.add(++pos, new Extent(fs.getBegin(), ext.end, ext.depth + 1));
                    ext.end = fs.getBegin();
                    ext = (Extent)list.get(pos);
                } else {
                    ++ext.depth;
                }
                if (ext.end > fs.getEnd()) {
                    list.add(pos + 1, new Extent(fs.getEnd(), ext.end, ext.depth - 1));
                    ext.end = fs.getEnd();
                } else if (ext.end < fs.getEnd()) {
                    int tmp = pos;
                    while (ext.end < fs.getEnd()) {
                        ext = (Extent)list.get(++tmp);
                        ++ext.depth;
                    }
                    if (ext.start < fs.getEnd()) {
                        list.add(tmp + 1, new Extent(fs.getEnd(), ext.end, ext.depth));
                        ext.end = fs.getEnd();
                    }
                    ++ext.depth;
                }
            }
            it.moveToNext();
        }
        int size = list.size();
        MarkupExtent[] extentArray = new MarkupExtent[size];
        for (int i = 0; i < size; ++i) {
            ext = (Extent)list.get(i);
            extentArray[i] = new MarkupExtent(ext.start, ext.end, ext.depth);
        }
        return extentArray;
    }

    private static class AnnotExtent
    extends Extent {
        private String annotName;

        private AnnotExtent(int start, int end, int depth, String annotName) {
            super(start, end, depth);
            this.annotName = annotName;
        }
    }

    private static class Extent {
        protected int start;
        protected int end;
        protected int depth;

        private Extent(int start, int end, int depth) {
            this.start = start;
            this.end = end;
            this.depth = depth;
        }
    }
}

