/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.migration;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.util.FileUtils;

public class IbmUimaToApacheUima {
    private static List replacements = new ArrayList();
    private static int MAX_FILE_SIZE = 1000000;
    private static Set extensions = new HashSet();
    private static int filesScanned = 0;
    private static int filesModified = 0;
    private static List filesNeedingManualAttention = new ArrayList();
    private static Set ibmPackageNames = new HashSet();
    private static final Pattern IMPORT_PATTERN = Pattern.compile("(?m)^\\s*import\\s+([^;]*);\\s*$");
    private static final Pattern CLASS_NAME_PATTERN = Pattern.compile("public\\s+(final\\s+|abstract\\s+)*class\\s+([A-Za-z0-9_]+)");
    private static final Pattern GET_NEXT_INDEX_PATTERN = Pattern.compile("JCas\\.getNextIndex\\(\\)");
    private static final Pattern THROW_FEAT_MISSING_PATTERN = Pattern.compile("JCas\\.throwFeatMissing");
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("(?m)^\\s*package\\s+([A-Za-z0-9_.]+)\\s*;");
    private static final Pattern GETDOCANNOT_PATTERN = Pattern.compile("[Jj][Cc][Aa][Ss](\\(\\))?\\s*\\.\\s*getDocumentAnnotation\\(");

    public static void main(String[] args) throws IOException {
        int i;
        String dir = null;
        for (i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if (args[i].equals("-ext")) {
                    if (i + 1 >= args.length) {
                        IbmUimaToApacheUima.printUsageAndExit();
                    }
                    IbmUimaToApacheUima.parseCommaSeparatedList(args[++i], extensions);
                    continue;
                }
                System.err.println("Unknown switch " + args[i]);
                IbmUimaToApacheUima.printUsageAndExit();
                continue;
            }
            if (dir != null) {
                IbmUimaToApacheUima.printUsageAndExit();
                continue;
            }
            dir = args[i];
        }
        if (dir == null) {
            IbmUimaToApacheUima.printUsageAndExit();
        }
        IbmUimaToApacheUima.readMapping("packageMapping.txt", replacements, true);
        IbmUimaToApacheUima.readMapping("stringReplacements.txt", replacements, false);
        System.out.println("Migrating your files...");
        IbmUimaToApacheUima.replaceInAllFiles(new File(args[0]));
        System.out.println("Migration complete.");
        System.out.println("Scanned " + filesScanned + " files.  " + filesModified + " files modified.");
        if (filesNeedingManualAttention.size() > 0) {
            System.out.println("The following files may need manual attention:");
            for (i = 0; i < filesNeedingManualAttention.size(); ++i) {
                System.out.println("   " + filesNeedingManualAttention.get(i));
            }
            System.out.println("See the \"Migrating from IBM UIMA to Apache UIMA\" chapter in the \"UIMA Overview and Setup\" document for details.");
        } else {
            System.out.println("No problems were detected.  However, if the code does not compilie and run, see the \"Migrating from IBM UIMA to Apache UIMA\" chapter in the \"UIMA Overview and Setup\" document for assistance.");
        }
    }

    private static void parseCommaSeparatedList(String string, Collection results) {
        String[] components = string.split(",", -1);
        for (int i = 0; i < components.length; ++i) {
            results.add(components[i]);
        }
    }

    private static void printUsageAndExit() {
        System.err.println("Usage: java " + IbmUimaToApacheUima.class.getName() + " <directory> [-ext <fileExtensions>]");
        System.err.println("<fileExtensions> is a comma separated list of file extensions to process, e.g.: java,xml,properties");
        System.err.println("\tUse a trailing comma to include files with no extension (meaning their name contains no dot)");
        System.exit(1);
    }

    private static void replaceInAllFiles(File dir) throws IOException {
        File[] fileList = dir.listFiles();
        for (int i = 0; i < fileList.length; ++i) {
            File file = fileList[i];
            if (file.isFile()) {
                if (!extensions.isEmpty()) {
                    String filename = file.getName();
                    String ext = "";
                    int lastDot = filename.lastIndexOf(46);
                    if (lastDot > -1) {
                        ext = filename.substring(lastDot + 1);
                    }
                    if (!extensions.contains(ext.toLowerCase())) continue;
                }
                if (!file.canRead()) {
                    System.err.println("Skipping unreadable file: " + file.getCanonicalPath());
                    continue;
                }
                if (!file.canWrite()) {
                    System.err.println("Skipping unwritable file: " + file.getCanonicalPath());
                    continue;
                }
                if (file.length() > (long)MAX_FILE_SIZE) {
                    System.out.println("Skipping file " + file.getCanonicalPath() + " with size: " + file.length() + " bytes");
                    continue;
                }
                IbmUimaToApacheUima.replaceInFile(file);
            }
            if (!file.isDirectory()) continue;
            IbmUimaToApacheUima.replaceInAllFiles(file);
        }
    }

    private static void replaceInFile(File file) throws IOException {
        String original;
        try {
            original = FileUtils.file2String((File)file);
        }
        catch (IOException e) {
            System.err.println("Error reading " + file.getCanonicalPath());
            System.err.println(e.getMessage());
            return;
        }
        String contents = original;
        for (Replacement replacement : replacements) {
            contents = contents.replaceAll(replacement.regex, replacement.replacementStr);
        }
        if (file.getName().endsWith(".java")) {
            contents = IbmUimaToApacheUima.applyJCasRefactoring(contents);
            contents = IbmUimaToApacheUima.removeDuplicateImports(contents);
        }
        if (!contents.equals(original)) {
            FileUtils.saveString2File((String)contents, (File)file);
            ++filesModified;
        }
        ++filesScanned;
        IbmUimaToApacheUima.checkForManualAttentionNeeded(file, original);
    }

    private static String applyJCasRefactoring(String contents) {
        Matcher classNameMatcher = CLASS_NAME_PATTERN.matcher(contents);
        if (!classNameMatcher.find()) {
            return contents;
        }
        String className = classNameMatcher.group(2);
        Matcher getNextIndexMatcher = GET_NEXT_INDEX_PATTERN.matcher(contents);
        String replacement = "org.apache.uima.jcas.JCasRegistry.register(" + className + ".class)";
        contents = getNextIndexMatcher.replaceAll(replacement);
        Matcher throwFeatMissingMatcher = THROW_FEAT_MISSING_PATTERN.matcher(contents);
        contents = className.endsWith("_Type") ? throwFeatMissingMatcher.replaceAll("this.jcas.throwFeatMissing") : throwFeatMissingMatcher.replaceAll("this.jcasType.jcas.throwFeatMissing");
        return contents;
    }

    private static String removeDuplicateImports(String contents) {
        HashSet<String> classes = new HashSet<String>();
        Matcher matcher = IMPORT_PATTERN.matcher(contents);
        int pos = 0;
        int endOfLastDuplicate = 0;
        StringBuffer result = null;
        while (matcher.find(pos)) {
            String className = matcher.group(1);
            if (!classes.add(className = className.replaceAll("\\s*", ""))) {
                if (result == null) {
                    result = new StringBuffer(contents.length());
                }
                result.append(contents.substring(endOfLastDuplicate, matcher.start()));
                endOfLastDuplicate = matcher.end();
            }
            pos = matcher.end();
        }
        if (result == null) {
            return contents;
        }
        result.append(contents.substring(endOfLastDuplicate));
        return result.toString();
    }

    private static void checkForManualAttentionNeeded(File file, String contents) {
        String packageName;
        Matcher packageNameMatcher = PACKAGE_PATTERN.matcher(contents);
        if (packageNameMatcher.find() && ibmPackageNames.contains(packageName = packageNameMatcher.group(1))) {
            filesNeedingManualAttention.add(file.getPath() + " (Uses an IBM UIMA Package Name)");
            return;
        }
        if (GETDOCANNOT_PATTERN.matcher(contents).find()) {
            filesNeedingManualAttention.add(file.getPath() + " (Calls JCas.getDocumentAnnotation())");
            return;
        }
        if (contents.indexOf("<xi:include") >= 0) {
            filesNeedingManualAttention.add(file.getPath() + " (Uses xi:include)");
            return;
        }
    }

    private static void readMapping(String fileName, List mappings, boolean treatAsPackageNames) throws IOException {
        URL pkgListFile = IbmUimaToApacheUima.class.getResource(fileName);
        InputStream inStream = pkgListFile.openStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inStream));
        String line = reader.readLine();
        while (line != null) {
            String replaceStr;
            String regex;
            String[] mapping = line.split(" ");
            if (treatAsPackageNames) {
                String pkgRegex = mapping[0].replaceAll("\\.", "\\\\s*\\\\.\\\\s*");
                regex = pkgRegex + "(\\.(\\*|[A-Z]\\w*))";
                replaceStr = mapping[1] + "$1";
                ibmPackageNames.add(mapping[0]);
            } else {
                regex = mapping[0].replaceAll("\\.", "\\\\s*\\\\.\\\\s*");
                replaceStr = mapping[1];
            }
            Replacement replacement = new Replacement(regex, replaceStr);
            mappings.add(replacement);
            line = reader.readLine();
        }
        inStream.close();
    }

    private static class Replacement {
        String regex;
        String replacementStr;

        Replacement(String regex, String replacement) {
            this.regex = regex;
            this.replacementStr = replacement;
        }
    }
}

